/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.math;

import java.io.Serializable;

public strictfp final class DD
implements Serializable,
Comparable,
Cloneable {
    public static final DD PI = new DD(Math.PI, 1.2246467991473532E-16);
    public static final DD TWO_PI = new DD(Math.PI * 2, 2.4492935982947064E-16);
    public static final DD PI_2 = new DD(1.5707963267948966, 6.123233995736766E-17);
    public static final DD E = new DD(Math.E, 1.4456468917292502E-16);
    public static final DD NaN = new DD(Double.NaN, Double.NaN);
    public static final double EPS = 1.23259516440783E-32;
    private static final double SPLIT = 1.34217729E8;
    private double hi = 0.0;
    private double lo = 0.0;
    private static final int MAX_PRINT_DIGITS = 32;
    private static final DD TEN = DD.valueOf(10.0);
    private static final DD ONE = DD.valueOf(1.0);
    private static final String SCI_NOT_EXPONENT_CHAR = "E";
    private static final String SCI_NOT_ZERO = "0.0E0";

    private static DD createNaN() {
        return new DD(Double.NaN, Double.NaN);
    }

    public static DD valueOf(String str) throws NumberFormatException {
        return DD.parse(str);
    }

    public static DD valueOf(double x) {
        return new DD(x);
    }

    public DD() {
        this.init(0.0);
    }

    public DD(double x) {
        this.init(x);
    }

    public DD(double hi, double lo) {
        this.init(hi, lo);
    }

    public DD(DD dd) {
        this.init(dd);
    }

    public DD(String str) throws NumberFormatException {
        this(DD.parse(str));
    }

    public static DD copy(DD dd) {
        return new DD(dd);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    private final void init(double x) {
        this.hi = x;
        this.lo = 0.0;
    }

    private final void init(double hi, double lo) {
        this.hi = hi;
        this.lo = lo;
    }

    private final void init(DD dd) {
        this.hi = dd.hi;
        this.lo = dd.lo;
    }

    public DD setValue(DD value) {
        this.init(value);
        return this;
    }

    public DD setValue(double value) {
        this.init(value);
        return this;
    }

    public final DD add(DD y) {
        return DD.copy(this).selfAdd(y);
    }

    public final DD add(double y) {
        return DD.copy(this).selfAdd(y);
    }

    public final DD selfAdd(DD y) {
        return this.selfAdd(y.hi, y.lo);
    }

    public final DD selfAdd(double y) {
        double S = this.hi + y;
        double e = S - this.hi;
        double s = S - e;
        s = y - e + (this.hi - s);
        double f = s + this.lo;
        double H = S + f;
        double h = f + (S - H);
        this.hi = H + h;
        this.lo = h + (H - this.hi);
        return this;
    }

    private final DD selfAdd(double yhi, double ylo) {
        double S = this.hi + yhi;
        double T2 = this.lo + ylo;
        double e = S - this.hi;
        double f = T2 - this.lo;
        double s = S - e;
        double t = T2 - f;
        s = yhi - e + (this.hi - s);
        t = ylo - f + (this.lo - t);
        e = s + T2;
        double H = S + e;
        double h = e + (S - H);
        e = t + h;
        double zhi = H + e;
        double zlo = e + (H - zhi);
        this.hi = zhi;
        this.lo = zlo;
        return this;
    }

    public final DD subtract(DD y) {
        return this.add(y.negate());
    }

    public final DD subtract(double y) {
        return this.add(-y);
    }

    public final DD selfSubtract(DD y) {
        if (this.isNaN()) {
            return this;
        }
        return this.selfAdd(-y.hi, -y.lo);
    }

    public final DD selfSubtract(double y) {
        if (this.isNaN()) {
            return this;
        }
        return this.selfAdd(-y, 0.0);
    }

    public final DD negate() {
        if (this.isNaN()) {
            return this;
        }
        return new DD(-this.hi, -this.lo);
    }

    public final DD multiply(DD y) {
        if (y.isNaN()) {
            return DD.createNaN();
        }
        return DD.copy(this).selfMultiply(y);
    }

    public final DD multiply(double y) {
        if (Double.isNaN(y)) {
            return DD.createNaN();
        }
        return DD.copy(this).selfMultiply(y, 0.0);
    }

    public final DD selfMultiply(DD y) {
        return this.selfMultiply(y.hi, y.lo);
    }

    public final DD selfMultiply(double y) {
        return this.selfMultiply(y, 0.0);
    }

    private final DD selfMultiply(double yhi, double ylo) {
        double C = 1.34217729E8 * this.hi;
        double hx = C - this.hi;
        double c = 1.34217729E8 * yhi;
        hx = C - hx;
        double tx = this.hi - hx;
        double hy = c - yhi;
        C = this.hi * yhi;
        hy = c - hy;
        double ty = yhi - hy;
        c = hx * hy - C + hx * ty + tx * hy + tx * ty + (this.hi * ylo + this.lo * yhi);
        double zhi = C + c;
        hx = C - zhi;
        double zlo = c + hx;
        this.hi = zhi;
        this.lo = zlo;
        return this;
    }

    public final DD divide(DD y) {
        double C = this.hi / y.hi;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * y.hi;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - y.hi;
        double U = C * y.hi;
        hy = u - hy;
        double ty = y.hi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (this.hi - U - u + this.lo - C * y.lo) / y.hi;
        double zhi = u = C + c;
        double zlo = C - u + c;
        return new DD(zhi, zlo);
    }

    public final DD divide(double y) {
        if (Double.isNaN(y)) {
            return DD.createNaN();
        }
        return DD.copy(this).selfDivide(y, 0.0);
    }

    public final DD selfDivide(DD y) {
        return this.selfDivide(y.hi, y.lo);
    }

    public final DD selfDivide(double y) {
        return this.selfDivide(y, 0.0);
    }

    private final DD selfDivide(double yhi, double ylo) {
        double C = this.hi / yhi;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * yhi;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - yhi;
        double U = C * yhi;
        hy = u - hy;
        double ty = yhi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (this.hi - U - u + this.lo - C * ylo) / yhi;
        this.hi = u = C + c;
        this.lo = C - u + c;
        return this;
    }

    public final DD reciprocal() {
        double C = 1.0 / this.hi;
        double c = 1.34217729E8 * C;
        double hc = c - C;
        double u = 1.34217729E8 * this.hi;
        hc = c - hc;
        double tc = C - hc;
        double hy = u - this.hi;
        double U = C * this.hi;
        hy = u - hy;
        double ty = this.hi - hy;
        u = hc * hy - U + hc * ty + tc * hy + tc * ty;
        c = (1.0 - U - u - C * this.lo) / this.hi;
        double zhi = C + c;
        double zlo = C - zhi + c;
        return new DD(zhi, zlo);
    }

    public DD floor() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.floor(this.hi);
        double flo = 0.0;
        if (fhi == this.hi) {
            flo = Math.floor(this.lo);
        }
        return new DD(fhi, flo);
    }

    public DD ceil() {
        if (this.isNaN()) {
            return NaN;
        }
        double fhi = Math.ceil(this.hi);
        double flo = 0.0;
        if (fhi == this.hi) {
            flo = Math.ceil(this.lo);
        }
        return new DD(fhi, flo);
    }

    public int signum() {
        if (this.hi > 0.0) {
            return 1;
        }
        if (this.hi < 0.0) {
            return -1;
        }
        if (this.lo > 0.0) {
            return 1;
        }
        if (this.lo < 0.0) {
            return -1;
        }
        return 0;
    }

    public DD rint() {
        if (this.isNaN()) {
            return this;
        }
        DD plus5 = this.add(0.5);
        return plus5.floor();
    }

    public DD trunc() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isPositive()) {
            return this.floor();
        }
        return this.ceil();
    }

    public DD abs() {
        if (this.isNaN()) {
            return NaN;
        }
        if (this.isNegative()) {
            return this.negate();
        }
        return new DD(this);
    }

    public DD sqr() {
        return this.multiply(this);
    }

    public DD selfSqr() {
        return this.selfMultiply(this);
    }

    public static DD sqr(double x) {
        return DD.valueOf(x).selfMultiply(x);
    }

    public DD sqrt() {
        if (this.isZero()) {
            return DD.valueOf(0.0);
        }
        if (this.isNegative()) {
            return NaN;
        }
        double x = 1.0 / Math.sqrt(this.hi);
        double ax = this.hi * x;
        DD axdd = DD.valueOf(ax);
        DD diffSq = this.subtract(axdd.sqr());
        double d2 = diffSq.hi * (x * 0.5);
        return axdd.add(d2);
    }

    public static DD sqrt(double x) {
        return DD.valueOf(x).sqrt();
    }

    public DD pow(int exp) {
        if ((double)exp == 0.0) {
            return DD.valueOf(1.0);
        }
        DD r = new DD(this);
        DD s = DD.valueOf(1.0);
        int n = Math.abs(exp);
        if (n > 1) {
            while (n > 0) {
                if (n % 2 == 1) {
                    s.selfMultiply(r);
                }
                if ((n /= 2) <= 0) continue;
                r = r.sqr();
            }
        } else {
            s = r;
        }
        if (exp < 0) {
            return s.reciprocal();
        }
        return s;
    }

    public static DD determinant(double x1, double y1, double x2, double y2) {
        return DD.determinant(DD.valueOf(x1), DD.valueOf(y1), DD.valueOf(x2), DD.valueOf(y2));
    }

    public static DD determinant(DD x1, DD y1, DD x2, DD y2) {
        DD det = x1.multiply(y2).selfSubtract(y1.multiply(x2));
        return det;
    }

    public DD min(DD x) {
        if (this.le(x)) {
            return this;
        }
        return x;
    }

    public DD max(DD x) {
        if (this.ge(x)) {
            return this;
        }
        return x;
    }

    public double doubleValue() {
        return this.hi + this.lo;
    }

    public int intValue() {
        return (int)this.hi;
    }

    public boolean isZero() {
        return this.hi == 0.0 && this.lo == 0.0;
    }

    public boolean isNegative() {
        return this.hi < 0.0 || this.hi == 0.0 && this.lo < 0.0;
    }

    public boolean isPositive() {
        return this.hi > 0.0 || this.hi == 0.0 && this.lo > 0.0;
    }

    public boolean isNaN() {
        return Double.isNaN(this.hi);
    }

    public boolean equals(DD y) {
        return this.hi == y.hi && this.lo == y.lo;
    }

    public boolean gt(DD y) {
        return this.hi > y.hi || this.hi == y.hi && this.lo > y.lo;
    }

    public boolean ge(DD y) {
        return this.hi > y.hi || this.hi == y.hi && this.lo >= y.lo;
    }

    public boolean lt(DD y) {
        return this.hi < y.hi || this.hi == y.hi && this.lo < y.lo;
    }

    public boolean le(DD y) {
        return this.hi < y.hi || this.hi == y.hi && this.lo <= y.lo;
    }

    public int compareTo(Object o) {
        DD other = (DD)o;
        if (this.hi < other.hi) {
            return -1;
        }
        if (this.hi > other.hi) {
            return 1;
        }
        if (this.lo < other.lo) {
            return -1;
        }
        if (this.lo > other.lo) {
            return 1;
        }
        return 0;
    }

    public String dump() {
        return "DD<" + this.hi + ", " + this.lo + ">";
    }

    public String toString() {
        int mag = DD.magnitude(this.hi);
        if (mag >= -3 && mag <= 20) {
            return this.toStandardNotation();
        }
        return this.toSciNotation();
    }

    public String toStandardNotation() {
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String sigDigits = this.extractSignificantDigits(true, magnitude);
        int decimalPointPos = magnitude[0] + 1;
        String num = sigDigits;
        if (sigDigits.charAt(0) == '.') {
            num = "0" + sigDigits;
        } else if (decimalPointPos < 0) {
            num = "0." + DD.stringOfChar('0', -decimalPointPos) + sigDigits;
        } else if (sigDigits.indexOf(46) == -1) {
            int numZeroes = decimalPointPos - sigDigits.length();
            String zeroes = DD.stringOfChar('0', numZeroes);
            num = sigDigits + zeroes + ".0";
        }
        if (this.isNegative()) {
            return "-" + num;
        }
        return num;
    }

    public String toSciNotation() {
        if (this.isZero()) {
            return SCI_NOT_ZERO;
        }
        String specialStr = this.getSpecialNumberString();
        if (specialStr != null) {
            return specialStr;
        }
        int[] magnitude = new int[1];
        String digits = this.extractSignificantDigits(false, magnitude);
        String expStr = SCI_NOT_EXPONENT_CHAR + magnitude[0];
        if (digits.charAt(0) == '0') {
            throw new IllegalStateException("Found leading zero: " + digits);
        }
        String trailingDigits = "";
        if (digits.length() > 1) {
            trailingDigits = digits.substring(1);
        }
        String digitsWithDecimal = digits.charAt(0) + "." + trailingDigits;
        if (this.isNegative()) {
            return "-" + digitsWithDecimal + expStr;
        }
        return digitsWithDecimal + expStr;
    }

    private String extractSignificantDigits(boolean insertDecimalPoint, int[] magnitude) {
        DD y = this.abs();
        int mag = DD.magnitude(y.hi);
        DD scale = TEN.pow(mag);
        if ((y = y.divide(scale)).gt(TEN)) {
            y = y.divide(TEN);
            ++mag;
        } else if (y.lt(ONE)) {
            y = y.multiply(TEN);
            --mag;
        }
        int decimalPointPos = mag + 1;
        StringBuffer buf = new StringBuffer();
        int numDigits = 31;
        for (int i = 0; i <= numDigits; ++i) {
            int digit;
            if (insertDecimalPoint && i == decimalPointPos) {
                buf.append('.');
            }
            if ((digit = (int)y.hi) < 0 || digit > 9) {
                // empty if block
            }
            if (digit < 0) break;
            boolean rebiasBy10 = false;
            char digitChar = '\u0000';
            if (digit > 9) {
                rebiasBy10 = true;
                digitChar = '9';
            } else {
                digitChar = (char)(48 + digit);
            }
            buf.append(digitChar);
            y = y.subtract(DD.valueOf(digit)).multiply(TEN);
            if (rebiasBy10) {
                y.selfAdd(TEN);
            }
            boolean continueExtractingDigits = true;
            int remMag = DD.magnitude(y.hi);
            if (remMag < 0 && Math.abs(remMag) >= numDigits - i) {
                continueExtractingDigits = false;
            }
            if (!continueExtractingDigits) break;
        }
        magnitude[0] = mag;
        return buf.toString();
    }

    private static String stringOfChar(char ch, int len) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    private String getSpecialNumberString() {
        if (this.isZero()) {
            return "0.0";
        }
        if (this.isNaN()) {
            return "NaN ";
        }
        return null;
    }

    private static int magnitude(double x) {
        double xAbs = Math.abs(x);
        double xLog10 = Math.log(xAbs) / Math.log(10.0);
        int xMag = (int)Math.floor(xLog10);
        double xApprox = Math.pow(10.0, xMag);
        if (xApprox * 10.0 <= xAbs) {
            ++xMag;
        }
        return xMag;
    }

    public static DD parse(String str) throws NumberFormatException {
        int numDecPlaces;
        char signCh;
        int i = 0;
        int strlen = str.length();
        while (Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        boolean isNegative = false;
        if (i < strlen && ((signCh = str.charAt(i)) == '-' || signCh == '+')) {
            ++i;
            if (signCh == '-') {
                isNegative = true;
            }
        }
        DD val = new DD();
        int numDigits = 0;
        int numBeforeDec = 0;
        int exp = 0;
        boolean hasDecimalChar = false;
        while (i < strlen) {
            char ch = str.charAt(i);
            ++i;
            if (Character.isDigit(ch)) {
                double d = ch - 48;
                val.selfMultiply(TEN);
                val.selfAdd(d);
                ++numDigits;
                continue;
            }
            if (ch == '.') {
                numBeforeDec = numDigits;
                hasDecimalChar = true;
                continue;
            }
            if (ch == 'e' || ch == 'E') {
                String expStr = str.substring(i);
                try {
                    exp = Integer.parseInt(expStr);
                    break;
                }
                catch (NumberFormatException ex) {
                    throw new NumberFormatException("Invalid exponent " + expStr + " in string " + str);
                }
            }
            throw new NumberFormatException("Unexpected character '" + ch + "' at position " + i + " in string " + str);
        }
        DD val2 = val;
        if (!hasDecimalChar) {
            numBeforeDec = numDigits;
        }
        if ((numDecPlaces = numDigits - numBeforeDec - exp) == 0) {
            val2 = val;
        } else if (numDecPlaces > 0) {
            DD scale = TEN.pow(numDecPlaces);
            val2 = val.divide(scale);
        } else if (numDecPlaces < 0) {
            DD scale = TEN.pow(-numDecPlaces);
            val2 = val.multiply(scale);
        }
        if (isNegative) {
            return val2.negate();
        }
        return val2;
    }
}

