/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum ProjectProperties {
    INSTANCE;

    private static final String PROPERTIES_FILE = "/project.properties";
    private static final String PROP_VERSION = "version";
    private static final String PROP_NAME = "name";
    private final Log log = LogFactory.getLog(ProjectProperties.class);
    private final Properties props = new Properties();

    private ProjectProperties() {
        this.log.debug("Loading project properties...");
        try (InputStream is = ProjectProperties.class.getResourceAsStream(PROPERTIES_FILE);){
            if (is != null) {
                this.props.load(is);
                this.log.debug("Properties successfully loaded.");
            } else {
                this.log.warn("Project properties file not found. Set default values.");
                this.props.put(PROP_NAME, "JxMapViewer");
                this.props.put(PROP_VERSION, "1.0");
            }
        }
        catch (IOException e) {
            this.log.warn("Unable to read project properties.", e);
            this.props.put(PROP_NAME, "JxMapViewer");
            this.props.put(PROP_VERSION, "1.0");
        }
    }

    public String getVersion() {
        return this.props.getProperty(PROP_VERSION);
    }

    public String getName() {
        return this.props.getProperty(PROP_NAME);
    }
}

