/*
 * Decompiled with CFR 0.152.
 */
package org.jxmapviewer.painter;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.painter.AbstractPainter;

public class AttributionPainter
extends AbstractPainter<JXMapViewer> {
    private Font font = new Font("Dialog", 1, 10);
    private Color backgroundColor = Color.WHITE;
    private Color fontColor = Color.BLACK;
    private int horizontal = 2;
    private int vertical = 1;
    private int margin = 2;

    @Override
    protected void doPaint(Graphics2D graphics, JXMapViewer mapViewer, int width, int height) {
        String attributionText = "Map: " + mapViewer.getTileFactory().getInfo().getAttribution() + "  Licence: " + mapViewer.getTileFactory().getInfo().getLicense();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D textBounds = fontMetrics.getStringBounds(attributionText, graphics);
        int attributionWidth = (int)textBounds.getWidth() + this.margin;
        int attributionHeight = (int)textBounds.getHeight() + this.margin;
        Point position = this.getPosition(width, height, attributionWidth, attributionHeight);
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(position.x, position.y, attributionWidth, attributionHeight);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(position.x, position.y, attributionWidth, attributionHeight);
        graphics.setColor(this.fontColor);
        graphics.drawString(attributionText, position.x, position.y + fontMetrics.getAscent());
    }

    private Point getPosition(int width, int height, int attributionWidth, int attributionHeight) {
        int x = 0;
        int y = 0;
        if (this.vertical == 1) {
            y = 2;
        }
        if (this.vertical == 3) {
            y = height - attributionHeight - 2;
        }
        if (this.horizontal == 2) {
            x = 2;
        }
        if (this.horizontal == 4) {
            x = width - attributionWidth - 2;
        }
        return new Point(x, y);
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void setFontColor(Color fontColor) {
        this.fontColor = fontColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPosition(int vertical, int horizontal) {
        this.vertical = vertical;
        this.horizontal = horizontal;
    }
}

