/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.AbstractQueue;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.geotools.util.factory.Hints;

public final class Utilities {
    private static final String[] spaces = new String[21];
    private static final int PRIME_NUMBER = 37;
    private static final Queue<?> EMPTY_QUEUE;

    private Utilities() {
    }

    public static boolean equals(boolean o1, boolean o2) {
        return o1 == o2;
    }

    public static boolean equals(char o1, char o2) {
        return o1 == o2;
    }

    public static boolean equals(byte o1, byte o2) {
        return o1 == o2;
    }

    public static boolean equals(short o1, short o2) {
        return o1 == o2;
    }

    public static boolean equals(int o1, int o2) {
        return o1 == o2;
    }

    public static boolean equals(long o1, long o2) {
        return o1 == o2;
    }

    public static boolean equals(float o1, float o2) {
        if (Float.floatToIntBits(o1) == Float.floatToIntBits(o2)) {
            return true;
        }
        double tol = Utilities.getTolerance();
        double min = (double)o1 - (double)o1 * tol;
        double max = (double)o1 + (double)o1 * tol;
        return min <= (double)o2 && (double)o2 <= max;
    }

    public static boolean equals(double o1, double o2) {
        if (Double.doubleToLongBits(o1) == Double.doubleToLongBits(o2)) {
            return true;
        }
        double tol = Utilities.getTolerance();
        double min = o1 - Math.signum(o1) * o1 * tol;
        double max = o1 + Math.signum(o1) * o1 * tol;
        return min <= o2 && o2 <= max;
    }

    private static double getTolerance() {
        Double tol = (Double)Hints.getSystemDefault(Hints.COMPARISON_TOLERANCE);
        if (tol == null) {
            return Hints.COMPARISON_TOLERANCE.getDefault();
        }
        return tol;
    }

    public static boolean equals(Object object1, Object object2) throws AssertionError {
        assert (object1 == null || !object1.getClass().isArray()) : object1;
        assert (object2 == null || !object2.getClass().isArray()) : object2;
        return object1 == object2 || object1 != null && object1.equals(object2);
    }

    public static boolean deepEquals(Object object1, Object object2) {
        if (object1 == object2) {
            return true;
        }
        if (object1 == null || object2 == null) {
            return false;
        }
        if (object1 instanceof Object[]) {
            Object[] os;
            return object2 instanceof Object[] && Arrays.deepEquals((Object[])object1, os = (Object[])object2);
        }
        if (object1 instanceof double[]) {
            double[] ds;
            return object2 instanceof double[] && Arrays.equals((double[])object1, ds = (double[])object2);
        }
        if (object1 instanceof float[]) {
            float[] fs;
            return object2 instanceof float[] && Arrays.equals((float[])object1, fs = (float[])object2);
        }
        if (object1 instanceof long[]) {
            long[] ls;
            return object2 instanceof long[] && Arrays.equals((long[])object1, ls = (long[])object2);
        }
        if (object1 instanceof int[]) {
            int[] is;
            return object2 instanceof int[] && Arrays.equals((int[])object1, is = (int[])object2);
        }
        if (object1 instanceof short[]) {
            short[] ss;
            return object2 instanceof short[] && Arrays.equals((short[])object1, ss = (short[])object2);
        }
        if (object1 instanceof byte[]) {
            byte[] bs;
            return object2 instanceof byte[] && Arrays.equals((byte[])object1, bs = (byte[])object2);
        }
        if (object1 instanceof char[]) {
            char[] cs;
            return object2 instanceof char[] && Arrays.equals((char[])object1, cs = (char[])object2);
        }
        if (object1 instanceof boolean[]) {
            boolean[] bs;
            return object2 instanceof boolean[] && Arrays.equals((boolean[])object1, bs = (boolean[])object2);
        }
        return object1.equals(object2);
    }

    public static int hash(boolean value, int seed) {
        return seed * 37 + (value ? 1231 : 1237);
    }

    public static int hash(char value, int seed) {
        return seed * 37 + value;
    }

    public static int hash(int value, int seed) {
        return seed * 37 + value;
    }

    public static int hash(long value, int seed) {
        return seed * 37 + ((int)value ^ (int)(value >>> 32));
    }

    public static int hash(float value, int seed) {
        return seed * 37 + Float.floatToIntBits(value);
    }

    public static int hash(double value, int seed) {
        return Utilities.hash(Double.doubleToLongBits(value), seed);
    }

    public static int hash(Object value, int seed) throws AssertionError {
        seed *= 37;
        if (value != null) {
            assert (!value.getClass().isArray()) : value;
            seed += value.hashCode();
        }
        return seed;
    }

    public static int deepHashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof Object[]) {
            Object[] object1s = (Object[])object;
            return Arrays.deepHashCode(object1s);
        }
        if (object instanceof double[]) {
            double[] doubles = (double[])object;
            return Arrays.hashCode(doubles);
        }
        if (object instanceof float[]) {
            float[] floats = (float[])object;
            return Arrays.hashCode(floats);
        }
        if (object instanceof long[]) {
            long[] longs = (long[])object;
            return Arrays.hashCode(longs);
        }
        if (object instanceof int[]) {
            int[] ints = (int[])object;
            return Arrays.hashCode(ints);
        }
        if (object instanceof short[]) {
            short[] shorts = (short[])object;
            return Arrays.hashCode(shorts);
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return Arrays.hashCode(bytes);
        }
        if (object instanceof char[]) {
            char[] chars = (char[])object;
            return Arrays.hashCode(chars);
        }
        if (object instanceof boolean[]) {
            boolean[] booleans = (boolean[])object;
            return Arrays.hashCode(booleans);
        }
        return object.hashCode();
    }

    public static String deepToString(Object object) {
        if (object instanceof Object[]) {
            Object[] object1s = (Object[])object;
            return Arrays.deepToString(object1s);
        }
        if (object instanceof double[]) {
            double[] doubles = (double[])object;
            return Arrays.toString(doubles);
        }
        if (object instanceof float[]) {
            float[] floats = (float[])object;
            return Arrays.toString(floats);
        }
        if (object instanceof long[]) {
            long[] longs = (long[])object;
            return Arrays.toString(longs);
        }
        if (object instanceof int[]) {
            int[] ints = (int[])object;
            return Arrays.toString(ints);
        }
        if (object instanceof short[]) {
            short[] shorts = (short[])object;
            return Arrays.toString(shorts);
        }
        if (object instanceof byte[]) {
            byte[] bytes = (byte[])object;
            return Arrays.toString(bytes);
        }
        if (object instanceof char[]) {
            char[] chars = (char[])object;
            return Arrays.toString(chars);
        }
        if (object instanceof boolean[]) {
            boolean[] booleans = (boolean[])object;
            return Arrays.toString(booleans);
        }
        return String.valueOf(object);
    }

    public static <E> Queue<E> emptyQueue() {
        return EMPTY_QUEUE;
    }

    public static String spaces(int length) {
        String s;
        if (length < 0) {
            length = 0;
        }
        if (length < spaces.length) {
            s = spaces[length];
            if (s == null) {
                Utilities.spaces[length] = s = spaces[spaces.length - 1].substring(0, length).intern();
            }
        } else {
            char[] blancs = new char[length];
            Arrays.fill(blancs, ' ');
            s = new String(blancs);
        }
        return s;
    }

    public static void ensureNonNull(String name, Object object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException(MessageFormat.format("Argument \"{0}\" should not be null.", name));
        }
    }

    public static void ensureArgumentNonNull(String name, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" should not be null.", name));
        }
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 0), false);
    }

    public static <T> Stream<T> stream(Optional<T> optional) {
        return optional.isPresent() ? Stream.of(optional.get()) : Stream.empty();
    }

    public static <T, U> Stream<Class<? extends U>> streamIfSubtype(Class<T> type, Class<U> supertype) {
        return supertype.isAssignableFrom(type) ? Stream.of(type.asSubclass(supertype)) : Stream.empty();
    }

    public static <T> Collector<T, ?, Set<T>> toUnmodifiableSet() {
        return Collectors.collectingAndThen(Collectors.toSet(), Collections::unmodifiableSet);
    }

    public static <T> Collector<T, ?, Map<String, T>> toInstanceByClassNameMap() {
        return Collectors.toMap(element -> element.getClass().getName(), Function.identity(), (first, second) -> second);
    }

    public static final void assertNotZipSlipVulnarable(File file, Path destinationDir) throws IOException {
        if (!file.toPath().normalize().startsWith(destinationDir)) {
            throw new IOException("Bad zip entry: ZipSlip extracting %s to %s".formatted(file, destinationDir));
        }
    }

    static {
        int last = spaces.length - 1;
        char[] blancs = new char[last];
        Arrays.fill(blancs, ' ');
        Utilities.spaces[last] = new String(blancs).intern();
        EMPTY_QUEUE = new EmptyQueue();
    }

    private static final class EmptyQueue<E>
    extends AbstractQueue<E>
    implements Serializable {
        private static final long serialVersionUID = -6147951199761870325L;

        private EmptyQueue() {
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Iterator<E> iterator() {
            Set empty = Collections.emptySet();
            return empty.iterator();
        }

        @Override
        public boolean offer(E e) {
            return false;
        }

        @Override
        public E poll() {
            return null;
        }

        @Override
        public E peek() {
            return null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return EMPTY_QUEUE;
        }
    }
}

