/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.IllegalComponentStateException;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.util.InternalWindowListener;

public final class SwingUtilities {
    private SwingUtilities() {
    }

    public static Component toFrame(Component owner, JComponent panel, String title, WindowListener listener) {
        while (owner != null) {
            if (owner == panel) {
                throw new IllegalArgumentException();
            }
            if (owner instanceof JDesktopPane) {
                JDesktopPane pane = (JDesktopPane)owner;
                JInternalFrame frame = new JInternalFrame(title, true, true, true, true);
                frame.setDefaultCloseOperation(2);
                frame.addInternalFrameListener(InternalWindowListener.wrap(listener));
                pane.add(frame);
                frame.getContentPane().add(panel);
                frame.pack();
                return frame;
            }
            if (owner instanceof Frame) {
                Frame frame = (Frame)owner;
                JDialog dialog = new JDialog(frame, title);
                dialog.setDefaultCloseOperation(2);
                dialog.addWindowListener(listener);
                dialog.getContentPane().add(panel);
                dialog.pack();
                return dialog;
            }
            if (owner instanceof Dialog) {
                Dialog dialog1 = (Dialog)owner;
                JDialog dialog = new JDialog(dialog1, title);
                dialog.setDefaultCloseOperation(2);
                dialog.addWindowListener(listener);
                dialog.getContentPane().add(panel);
                dialog.pack();
                return dialog;
            }
            owner = owner.getParent();
        }
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(2);
        frame.addWindowListener(listener);
        frame.getContentPane().add(panel);
        frame.pack();
        return frame;
    }

    public static void setTitle(Component component, String title) {
        while (component != null) {
            Container frame;
            if (component instanceof JInternalFrame) {
                frame = (JInternalFrame)component;
                ((JInternalFrame)frame).setTitle(title);
            }
            if (component instanceof Frame) {
                frame = (Frame)component;
                ((Frame)frame).setTitle(title);
                return;
            }
            if (!(component instanceof Dialog)) continue;
            Dialog dialog = (Dialog)component;
            dialog.setTitle(title);
            return;
        }
    }

    public static boolean showOptionDialog(Component owner, Object dialog, String title) {
        return SwingUtilities.showOptionDialog(owner, dialog, title, null);
    }

    public static boolean showOptionDialog(Component owner, Object dialog, String title, ActionListener reset) {
        if (!EventQueue.isDispatchThread()) {
            boolean[] result = new boolean[1];
            SwingUtilities.invokeAndWait(() -> {
                result[0] = SwingUtilities.showOptionDialog(owner, dialog, title, reset);
            });
            return result[0];
        }
        Object[] options = null;
        Object initialValue = null;
        int okChoice = 0;
        if (reset != null) {
            JButton button;
            Vocabulary resources = Vocabulary.getResources(owner != null ? owner.getLocale() : null);
            if (reset instanceof Action) {
                Action action = (Action)reset;
                button = new JButton(action);
            } else {
                button = new JButton(resources.getString(182));
                button.addActionListener(reset);
            }
            options = new Object[]{resources.getString(155), resources.getString(13), button};
            okChoice = 0;
            initialValue = options[0];
        }
        int choice = JOptionPane.getDesktopPaneForComponent(owner) != null ? JOptionPane.showInternalOptionDialog(owner, dialog, title, 2, -1, null, options, initialValue) : JOptionPane.showOptionDialog(owner, dialog, title, 2, -1, null, options, initialValue);
        return choice == okChoice;
    }

    public static void showMessageDialog(Component owner, Object message, String title, int type) {
        if (!EventQueue.isDispatchThread()) {
            SwingUtilities.invokeAndWait(() -> SwingUtilities.showMessageDialog(owner, message, title, type));
            return;
        }
        if (JOptionPane.getDesktopPaneForComponent(owner) != null) {
            JOptionPane.showInternalMessageDialog(owner, message, title, type);
        } else {
            JOptionPane.showMessageDialog(owner, message, title, type);
        }
    }

    public static boolean showConfirmDialog(Component owner, Object message, String title, int type) {
        if (!EventQueue.isDispatchThread()) {
            boolean[] result = new boolean[1];
            SwingUtilities.invokeAndWait(() -> {
                result[0] = SwingUtilities.showConfirmDialog(owner, message, title, type);
            });
            return result[0];
        }
        int choice = JOptionPane.getDesktopPaneForComponent(owner) != null ? JOptionPane.showInternalConfirmDialog(owner, message, title, 0, type) : JOptionPane.showConfirmDialog(owner, message, title, 0, type);
        return choice == 0;
    }

    public static JComponent getMultilineLabelFor(JComponent owner, String text) {
        JTextArea label = new JTextArea(text);
        Dimension size = owner.getPreferredSize();
        size.height = label.getMaximumSize().height;
        label.setMaximumSize(size);
        label.setWrapStyleWord(true);
        label.setLineWrap(true);
        label.setEditable(false);
        label.setFocusable(false);
        label.setOpaque(false);
        label.setBorder(null);
        LookAndFeel.installColorsAndFont(label, "Label.background", "Label.foreground", "Label.font");
        return label;
    }

    public static Locale getLocale(Component component) {
        if (component != null) {
            try {
                return component.getLocale();
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
        return JComponent.getDefaultLocale();
    }

    public static void invokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException target) {
                Throwable exception = target.getTargetException();
                if (exception instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)exception;
                    throw runtimeException;
                }
                if (exception instanceof Error) {
                    Error error = (Error)exception;
                    throw error;
                }
                throw new UndeclaredThrowableException(exception, exception.getLocalizedMessage());
            }
        }
    }
}

