/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling.visitor;

import java.util.Map;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Length;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.measure.Units;
import org.geotools.styling.visitor.Measure;
import si.uom.SI;
import systems.uom.common.USCustomary;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum RescalingMode {
    KeepUnits{

        @Override
        public String rescaleToStringInternal(double scaleFactor, Measure measure) {
            double rescaled = measure.value * scaleFactor;
            String rescaledString = rescaled == (double)((int)rescaled) ? String.valueOf((int)rescaled) : String.valueOf(rescaled);
            if (measure.isPixelInPixelDefault()) {
                return rescaledString;
            }
            return rescaledString + (String)this.UNIT_SYMBOLS.get(measure.uom);
        }
    }
    ,
    Pixels{

        @Override
        public String rescaleToStringInternal(double scaleFactor, Measure measure) {
            if (measure.isRealWorldUnit()) {
                if (measure.isRealWorldUnitInPixelDefault()) {
                    return String.valueOf(measure.value) + (String)this.UNIT_SYMBOLS.get(measure.uom);
                }
                return String.valueOf(measure.value);
            }
            return String.valueOf(measure.value * scaleFactor);
        }

        @Override
        public Expression rescaleToExpression(Expression scaleFactor, Measure measure) {
            if (measure.isRealWorldUnit()) {
                return measure.expression;
            }
            return super.rescaleToExpression(scaleFactor, measure);
        }
    }
    ,
    RealWorld{

        @Override
        public String rescaleToStringInternal(double scaleFactor, Measure measure) {
            return String.valueOf(measure.value * this.computeRescaleMultiplier(scaleFactor, measure.uom));
        }

        double computeRescaleMultiplier(double mapScale, Unit<Length> uom) {
            if (uom == null || uom.equals(Units.PIXEL)) {
                return 1.0;
            }
            if (uom == SI.METRE) {
                return mapScale;
            }
            UnitConverter converter = uom.getConverterTo(SI.METRE);
            return converter.convert(mapScale);
        }
    };

    final Map<Unit, String> UNIT_SYMBOLS = Map.ofEntries(Map.entry(Units.PIXEL, "px"), Map.entry(USCustomary.FOOT, "ft"), Map.entry(SI.METRE, "m"));

    public abstract String rescaleToStringInternal(double var1, Measure var3);

    public String rescaleToString(double scaleFactor, Measure measure) {
        if (measure.value == null) {
            throw new IllegalStateException("Cannot rescale to literal, the value is a generic expression, not a static value: " + String.valueOf(measure.expression));
        }
        return this.rescaleToStringInternal(scaleFactor, measure);
    }

    public Expression rescaleToExpression(Expression scaleFactor, Measure measure) {
        if (measure.value != null && scaleFactor instanceof Literal) {
            Double scale = scaleFactor.evaluate(null, Double.class);
            return Measure.ff.literal(this.rescaleToStringInternal(scale, measure));
        }
        return Measure.ff.function("rescaleToPixels", measure.expression, Measure.ff.literal(measure.uom), scaleFactor, Measure.ff.literal((Object)this));
    }
}

