/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.measure.Units;
import si.uom.SI;
import systems.uom.common.USCustomary;

public enum UomOgcMapping {
    METRE(SI.METRE, "http://www.opengeospatial.org/se/units/metre"),
    FOOT(USCustomary.FOOT, "http://www.opengeospatial.org/se/units/foot"),
    PIXEL(Units.PIXEL, "http://www.opengeospatial.org/se/units/pixel");

    private String seString;
    private Unit<Length> unit;

    private UomOgcMapping(Unit<Length> unit, String seString) {
        this.unit = unit;
        this.seString = seString;
    }

    public String toString() {
        return this.seString;
    }

    public String getSEString() {
        return this.seString;
    }

    public Unit<Length> getUnit() {
        return this.unit;
    }

    public static UomOgcMapping get(String seString) throws IllegalArgumentException {
        for (UomOgcMapping uom : UomOgcMapping.values()) {
            if (!uom.getSEString().equals(seString)) continue;
            return uom;
        }
        throw new IllegalArgumentException("'" + seString + "' is not a valid OGC SE standard Unit of Measure");
    }

    public static UomOgcMapping get(Unit<Length> unit) throws IllegalArgumentException {
        for (UomOgcMapping uom : UomOgcMapping.values()) {
            if (!uom.getUnit().equals(unit)) continue;
            return uom;
        }
        throw new IllegalArgumentException("'" + String.valueOf(unit) + "' is not a valid OGC SE standard Unit of Measure");
    }
}

