/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.Description;
import org.geotools.api.style.Fill;
import org.geotools.api.style.Font;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.Halo;
import org.geotools.api.style.LabelPlacement;
import org.geotools.api.style.LinePlacement;
import org.geotools.api.style.OtherText;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbolizer;
import org.geotools.api.style.TextSymbolizer;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.styling.AbstractSymbolizer;
import org.geotools.styling.FillImpl;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.util.factory.GeoTools;

public class TextSymbolizerImpl
extends AbstractSymbolizer
implements TextSymbolizer,
Cloneable {
    private List<Font> fonts = new ArrayList<Font>(1);
    private final FilterFactory filterFactory;
    private FillImpl fill;
    private HaloImpl halo;
    private LabelPlacement placement;
    private Expression label = null;
    private Graphic graphic = null;
    private Expression priority = null;
    private Expression abxtract = null;
    private Expression description = null;
    private OtherText otherText = null;

    protected TextSymbolizerImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    protected TextSymbolizerImpl(FilterFactory factory) {
        this(factory, null, null, null);
    }

    protected TextSymbolizerImpl(FilterFactory factory, Description desc, String name, Unit<Length> uom) {
        super(name, desc, (Expression)null, uom);
        this.filterFactory = factory;
        this.fill = new FillImpl(factory);
        this.fill.setColor(this.filterFactory.literal("#000000"));
        this.halo = null;
        this.placement = new PointPlacementImpl();
    }

    @Override
    public Fill getFill() {
        return this.fill;
    }

    @Override
    public void setFill(Fill fill) {
        if (this.fill == fill) {
            return;
        }
        this.fill = FillImpl.cast(fill);
    }

    @Override
    public List<Font> fonts() {
        return this.fonts;
    }

    @Override
    public Font getFont() {
        return this.fonts.isEmpty() ? null : this.fonts.get(0);
    }

    @Override
    public void setFont(Font font) {
        if (this.fonts.size() == 1 && this.fonts.get(0) == font) {
            return;
        }
        if (font != null) {
            if (this.fonts.isEmpty()) {
                this.fonts.add(font);
            } else {
                this.fonts.set(0, font);
            }
        }
    }

    public void addFont(Font font) {
        this.fonts.add(font);
    }

    @Override
    public Halo getHalo() {
        return this.halo;
    }

    @Override
    public void setHalo(Halo halo) {
        if (this.halo == halo) {
            return;
        }
        this.halo = HaloImpl.cast(halo);
    }

    @Override
    public Expression getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(Expression label) {
        this.label = label;
    }

    @Override
    public LabelPlacement getLabelPlacement() {
        return this.placement;
    }

    @Override
    public void setLabelPlacement(LabelPlacement labelPlacement) {
        if (this.placement == labelPlacement) {
            return;
        }
        this.placement = labelPlacement instanceof LinePlacement ? LinePlacementImpl.cast(labelPlacement) : PointPlacementImpl.cast(labelPlacement);
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void setPriority(Expression priority) {
        if (this.priority == priority) {
            return;
        }
        this.priority = priority;
    }

    @Override
    public Expression getPriority() {
        return this.priority;
    }

    @Override
    public Graphic getGraphic() {
        return this.graphic;
    }

    @Override
    public void setGraphic(Graphic graphic) {
        if (this.graphic == graphic) {
            return;
        }
        this.graphic = graphic;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<TextSymbolizerImp property=");
        buf.append(this.getGeometryPropertyName());
        buf.append(" label=");
        buf.append(this.label);
        buf.append(">");
        buf.append(this.fonts);
        return buf.toString();
    }

    @Override
    public Expression getSnippet() {
        return this.abxtract;
    }

    @Override
    public void setSnippet(Expression abxtract) {
        this.abxtract = abxtract;
    }

    @Override
    public Expression getFeatureDescription() {
        return this.description;
    }

    @Override
    public void setFeatureDescription(Expression description) {
        this.description = description;
    }

    @Override
    public OtherText getOtherText() {
        return this.otherText;
    }

    @Override
    public void setOtherText(OtherText otherText) {
        this.otherText = otherText;
    }

    static TextSymbolizerImpl cast(Symbolizer symbolizer) {
        if (symbolizer == null) {
            return null;
        }
        if (symbolizer instanceof TextSymbolizerImpl) {
            TextSymbolizerImpl impl = (TextSymbolizerImpl)symbolizer;
            return impl;
        }
        TextSymbolizer textSymbolizer = (TextSymbolizer)symbolizer;
        TextSymbolizerImpl copy = new TextSymbolizerImpl();
        copy.setDescription(textSymbolizer.getDescription());
        copy.setFill(textSymbolizer.getFill());
        if (textSymbolizer.fonts() != null) {
            copy.fonts().addAll(textSymbolizer.fonts());
        }
        copy.setGeometryPropertyName(textSymbolizer.getGeometryPropertyName());
        copy.setHalo(textSymbolizer.getHalo());
        copy.setLabel(textSymbolizer.getLabel());
        copy.setLabelPlacement(textSymbolizer.getLabelPlacement());
        copy.setName(textSymbolizer.getName());
        copy.setUnitOfMeasure(textSymbolizer.getUnitOfMeasure());
        copy.setPriority(textSymbolizer.getPriority());
        copy.setGraphic(textSymbolizer.getGraphic());
        copy.setOtherText(textSymbolizer.getOtherText());
        copy.setFeatureDescription(textSymbolizer.getFeatureDescription());
        copy.setSnippet(textSymbolizer.getSnippet());
        if (textSymbolizer.getOptions() != null) {
            copy.getOptions().putAll(textSymbolizer.getOptions());
        }
        return copy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.abxtract == null ? 0 : this.abxtract.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.fill == null ? 0 : this.fill.hashCode());
        result = 31 * result + (this.filterFactory == null ? 0 : this.filterFactory.hashCode());
        result = 31 * result + (this.fonts == null ? 0 : this.fonts.hashCode());
        result = 31 * result + (this.graphic == null ? 0 : this.graphic.hashCode());
        result = 31 * result + (this.halo == null ? 0 : this.halo.hashCode());
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        result = 31 * result + (this.otherText == null ? 0 : this.otherText.hashCode());
        result = 31 * result + (this.placement == null ? 0 : this.placement.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextSymbolizerImpl other = (TextSymbolizerImpl)obj;
        if (this.abxtract == null ? other.abxtract != null : !this.abxtract.equals(other.abxtract)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.fill == null ? other.fill != null : !this.fill.equals(other.fill)) {
            return false;
        }
        if (this.filterFactory == null ? other.filterFactory != null : !this.filterFactory.equals(other.filterFactory)) {
            return false;
        }
        if (this.fonts == null ? other.fonts != null : !this.fonts.equals(other.fonts)) {
            return false;
        }
        if (this.graphic == null ? other.graphic != null : !this.graphic.equals(other.graphic)) {
            return false;
        }
        if (this.halo == null ? other.halo != null : !this.halo.equals(other.halo)) {
            return false;
        }
        if (this.label == null ? other.label != null : !this.label.equals(other.label)) {
            return false;
        }
        if (this.otherText == null ? other.otherText != null : !this.otherText.equals(other.otherText)) {
            return false;
        }
        if (this.placement == null ? other.placement != null : !this.placement.equals(other.placement)) {
            return false;
        }
        return !(this.priority == null ? other.priority != null : !this.priority.equals(other.priority));
    }
}

