/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import org.geotools.api.style.Style;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.StyledLayer;
import org.geotools.api.style.StyledLayerDescriptor;
import org.geotools.api.style.UserLayer;
import org.geotools.styling.StyledLayerImpl;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class StyledLayerDescriptorImpl
implements StyledLayerDescriptor {
    private static final Logger LOGGER = Logging.getLogger(StyledLayerDescriptorImpl.class);
    private String name;
    private String title;
    private String abstractStr;
    private List<StyledLayer> layers = new ArrayList<StyledLayer>();

    public Style getDefaultStyle() {
        for (StyledLayer layer : this.layers) {
            Style[] styles;
            if (!(layer instanceof UserLayer)) continue;
            UserLayer userLayer = (UserLayer)layer;
            for (Style style : styles = userLayer.getUserStyles()) {
                if (!style.isDefault()) continue;
                return style;
            }
        }
        return null;
    }

    @Override
    public StyledLayer[] getStyledLayers() {
        return this.layers.toArray(new StyledLayerImpl[this.layers.size()]);
    }

    @Override
    public void setStyledLayers(StyledLayer ... layers) {
        this.layers.clear();
        for (StyledLayer layer : layers) {
            this.addStyledLayer(layer);
        }
        LOGGER.fine("StyleLayerDescriptorImpl added " + this.layers.size() + " styled layers");
    }

    @Override
    public List<StyledLayer> layers() {
        return this.layers;
    }

    @Override
    public void addStyledLayer(StyledLayer layer) {
        this.layers.add(layer);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getAbstract() {
        return this.abstractStr;
    }

    @Override
    public void setAbstract(String abstractStr) {
        this.abstractStr = abstractStr;
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof StyledLayerDescriptorImpl) {
            StyledLayerDescriptorImpl other = (StyledLayerDescriptorImpl)oth;
            return Utilities.equals(this.abstractStr, other.abstractStr) && Utilities.equals(this.layers, other.layers) && Utilities.equals(this.name, other.name) && Utilities.equals(this.title, other.title);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.title, this.abstractStr, this.layers);
    }
}

