/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.ShadedRelief;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;

public class ShadedReliefImpl
implements ShadedRelief {
    private FilterFactory filterFactory;
    private Expression reliefFactor;
    private boolean brightness = false;

    public ShadedReliefImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public ShadedReliefImpl(FilterFactory factory) {
        this.filterFactory = factory;
        this.reliefFactor = this.filterFactory.literal(55);
    }

    @Override
    public Expression getReliefFactor() {
        return this.reliefFactor;
    }

    @Override
    public boolean isBrightnessOnly() {
        return this.brightness;
    }

    @Override
    public void setBrightnessOnly(boolean flag) {
        this.brightness = flag;
    }

    @Override
    public void setReliefFactor(Expression reliefFactor) {
        this.reliefFactor = reliefFactor;
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.reliefFactor != null) {
            result = 1000003 * result + this.reliefFactor.hashCode();
        }
        result = 1000003 * result + (this.brightness ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ShadedReliefImpl) {
            ShadedReliefImpl other = (ShadedReliefImpl)obj;
            return Utilities.equals(this.reliefFactor, other.reliefFactor) && Utilities.equals(this.brightness, other.brightness);
        }
        return false;
    }

    static ShadedReliefImpl cast(ShadedRelief shadedRelief) {
        if (shadedRelief == null) {
            return null;
        }
        if (shadedRelief instanceof ShadedReliefImpl) {
            ShadedReliefImpl impl = (ShadedReliefImpl)shadedRelief;
            return impl;
        }
        ShadedReliefImpl copy = new ShadedReliefImpl();
        copy.setBrightnessOnly(shadedRelief.isBrightnessOnly());
        copy.setReliefFactor(shadedRelief.getReliefFactor());
        return copy;
    }
}

