/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.style.AnchorPoint;
import org.geotools.api.style.Displacement;
import org.geotools.api.style.ExternalGraphic;
import org.geotools.api.style.Graphic;
import org.geotools.api.style.GraphicFill;
import org.geotools.api.style.GraphicLegend;
import org.geotools.api.style.GraphicStroke;
import org.geotools.api.style.GraphicalSymbol;
import org.geotools.api.style.Mark;
import org.geotools.api.style.StyleVisitor;
import org.geotools.api.style.Symbol;
import org.geotools.api.style.TraversingStyleVisitor;
import org.geotools.api.util.Cloneable;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.ConstantExpression;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.MarkImpl;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;

public class GraphicImpl
implements GraphicLegend,
Graphic,
GraphicFill,
GraphicStroke,
Cloneable {
    public static final Graphic DEFAULT = new ConstantGraphic(){

        @Override
        public List<GraphicalSymbol> graphicalSymbols() {
            return Collections.emptyList();
        }

        @Override
        public Expression getOpacity() {
            return ConstantExpression.ONE;
        }

        @Override
        public Expression getSize() {
            return Expression.NIL;
        }

        @Override
        public Displacement getDisplacement() {
            return DisplacementImpl.DEFAULT;
        }

        @Override
        public Expression getRotation() {
            return ConstantExpression.ZERO;
        }
    };
    public static final Graphic NULL = new ConstantGraphic(){

        @Override
        public List<GraphicalSymbol> graphicalSymbols() {
            return Collections.emptyList();
        }

        @Override
        public Expression getOpacity() {
            return ConstantExpression.NULL;
        }

        @Override
        public Expression getSize() {
            return ConstantExpression.NULL;
        }

        @Override
        public Displacement getDisplacement() {
            return DisplacementImpl.NULL;
        }

        @Override
        public Expression getRotation() {
            return ConstantExpression.NULL;
        }
    };
    private final List<GraphicalSymbol> graphics = new ArrayList<GraphicalSymbol>();
    private AnchorPointImpl anchor;
    private Expression gap;
    private Expression initialGap;
    private Expression rotation = null;
    private Expression size = null;
    private DisplacementImpl displacement = null;
    private Expression opacity = null;

    protected GraphicImpl() {
        this(CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints()));
    }

    public GraphicImpl(FilterFactory factory) {
        this(factory, null, null, null);
    }

    public GraphicImpl(FilterFactory factory, AnchorPoint anchor, Expression gap, Expression initialGap) {
        this.anchor = AnchorPointImpl.cast(anchor);
        this.gap = gap == null ? ConstantExpression.constant(0) : gap;
        this.initialGap = initialGap == null ? ConstantExpression.constant(0) : initialGap;
    }

    @Override
    public List<GraphicalSymbol> graphicalSymbols() {
        return this.graphics;
    }

    @Override
    public AnchorPoint getAnchorPoint() {
        return this.anchor;
    }

    @Override
    public void setAnchorPoint(AnchorPoint anchor) {
        this.anchor = AnchorPointImpl.cast(anchor);
    }

    @Override
    public Expression getOpacity() {
        return this.opacity;
    }

    @Override
    public Expression getRotation() {
        return this.rotation;
    }

    @Override
    public Expression getSize() {
        return this.size;
    }

    @Override
    public Displacement getDisplacement() {
        return this.displacement;
    }

    @Override
    public Expression getInitialGap() {
        return this.initialGap;
    }

    @Override
    public void setInitialGap(Expression initialGap) {
        this.initialGap = initialGap;
    }

    @Override
    public Expression getGap() {
        return this.gap;
    }

    @Override
    public void setGap(Expression gap) {
        this.gap = gap;
    }

    @Override
    public void setDisplacement(Displacement offset) {
        this.displacement = DisplacementImpl.cast(offset);
    }

    @Override
    public void setOpacity(Expression opacity) {
        this.opacity = opacity;
    }

    @Override
    public void setRotation(Expression rotation) {
        this.rotation = rotation;
    }

    @Override
    public void setSize(Expression size) {
        this.size = size;
    }

    @Override
    public Object accept(TraversingStyleVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public void accept(StyleVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        GraphicImpl clone;
        try {
            clone = (GraphicImpl)super.clone();
            clone.graphics.clear();
            clone.graphics.addAll(this.graphics);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return clone;
    }

    public int hashCode() {
        int PRIME = 1000003;
        int result = 0;
        if (this.graphics != null) {
            result = 1000003 * result + this.graphics.hashCode();
        }
        if (this.rotation != null) {
            result = 1000003 * result + this.rotation.hashCode();
        }
        if (this.size != null) {
            result = 1000003 * result + this.size.hashCode();
        }
        if (this.opacity != null) {
            result = 1000003 * result + this.opacity.hashCode();
        }
        return result;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth instanceof GraphicImpl) {
            GraphicImpl other = (GraphicImpl)oth;
            return Utilities.equals(this.size, other.size) && Utilities.equals(this.rotation, other.rotation) && Utilities.equals(this.opacity, other.opacity) && Objects.equals(this.graphicalSymbols(), other.graphicalSymbols());
        }
        return false;
    }

    static GraphicImpl cast(Graphic graphic) {
        if (graphic == null) {
            return null;
        }
        if (graphic instanceof GraphicImpl) {
            GraphicImpl impl = (GraphicImpl)graphic;
            return impl;
        }
        GraphicImpl copy = new GraphicImpl();
        copy.setAnchorPoint(graphic.getAnchorPoint());
        copy.setDisplacement(graphic.getDisplacement());
        if (graphic.graphicalSymbols() != null) {
            for (GraphicalSymbol item : graphic.graphicalSymbols()) {
                if (item instanceof ExternalGraphic) {
                    copy.graphicalSymbols().add(ExternalGraphicImpl.cast(item));
                    continue;
                }
                if (!(item instanceof Mark)) continue;
                copy.graphicalSymbols().add(MarkImpl.cast(item));
            }
        }
        return copy;
    }

    public static abstract class ConstantGraphic
    implements Graphic,
    GraphicStroke,
    GraphicFill {
        private void cannotModifyConstant() {
            throw new UnsupportedOperationException("Constant Graphic may not be modified");
        }

        @Override
        public void setDisplacement(Displacement offset) {
            this.cannotModifyConstant();
        }

        public void setExternalGraphics(ExternalGraphic ... externalGraphics) {
            this.cannotModifyConstant();
        }

        public void addExternalGraphic(ExternalGraphic externalGraphic) {
            this.cannotModifyConstant();
        }

        public void setMarks(Mark ... marks) {
            this.cannotModifyConstant();
        }

        public void addMark(Mark mark) {
            this.cannotModifyConstant();
        }

        @Override
        public void setGap(Expression gap) {
            this.cannotModifyConstant();
        }

        @Override
        public void setInitialGap(Expression initialGap) {
            this.cannotModifyConstant();
        }

        public void setSymbols(Symbol ... symbols) {
            this.cannotModifyConstant();
        }

        public void addSymbol(Symbol symbol) {
            this.cannotModifyConstant();
        }

        @Override
        public void setOpacity(Expression opacity) {
            this.cannotModifyConstant();
        }

        @Override
        public void setSize(Expression size) {
            this.cannotModifyConstant();
        }

        @Override
        public void setRotation(Expression rotation) {
            this.cannotModifyConstant();
        }

        @Override
        public void setAnchorPoint(AnchorPoint anchor) {
            this.cannotModifyConstant();
        }

        @Override
        public Object accept(TraversingStyleVisitor visitor, Object data) {
            return visitor.visit(this, data);
        }

        @Override
        public void accept(StyleVisitor visitor) {
            visitor.visit(this);
        }

        @Override
        public List<GraphicalSymbol> graphicalSymbols() {
            return Collections.emptyList();
        }

        @Override
        public AnchorPoint getAnchorPoint() {
            return AnchorPointImpl.DEFAULT;
        }

        @Override
        public Expression getGap() {
            return ConstantExpression.constant(0);
        }

        @Override
        public Expression getInitialGap() {
            return ConstantExpression.constant(0);
        }
    }
}

