/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.logging.Logger;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.EquidistantCylindrical;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.PlateCarree;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.geotools.util.logging.Logging;

public class PlateCarreeHandlerFactory
implements ProjectionHandlerFactory {
    protected static final Logger LOGGER = Logging.getLogger(PlateCarreeHandlerFactory.class);
    private static final ReferencedEnvelope VALID_AREA = new ReferencedEnvelope(-1800.0, 1800.0, -90.0, 90.0, DefaultGeographicCRS.WGS84);

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCrs, boolean wrap, int maxWraps) throws FactoryException {
        ProjectionHandler handler;
        if (renderingEnvelope == null) {
            return null;
        }
        CoordinateReferenceSystem renderingCrs = renderingEnvelope.getCoordinateReferenceSystem();
        if (renderingCrs == null) {
            return null;
        }
        MapProjection mapProjection = CRS.getMapProjection(renderingCrs);
        boolean isPlateCarree = false;
        if (mapProjection != null && !(isPlateCarree = mapProjection instanceof PlateCarree) && mapProjection instanceof EquidistantCylindrical) {
            double stdParallel = 0.0;
            try {
                stdParallel = mapProjection.getParameterValues().parameter(EquidistantCylindrical.Provider.STANDARD_PARALLEL_1.getName().getCode()).doubleValue();
            }
            catch (Exception ignore) {
                LOGGER.finest("Unable to read standard_parallel_1 parameter, assuming 0");
            }
            boolean bl = isPlateCarree = Math.abs(stdParallel) < 1.0E-12;
        }
        if (!isPlateCarree) {
            return null;
        }
        double centralMeridian = 0.0;
        ParameterValueGroup params = mapProjection.getParameterValues();
        if (params != null) {
            try {
                centralMeridian = params.parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
            }
            catch (Exception ignore) {
                LOGGER.finest("Unable to read central_meridian parameter, assuming 0");
            }
        }
        centralMeridian = ((centralMeridian + 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
        if (wrap && maxWraps > 0) {
            handler = new WrappingProjectionHandler(renderingEnvelope, VALID_AREA, sourceCrs, centralMeridian, maxWraps);
        } else {
            handler = new ProjectionHandler(sourceCrs, VALID_AREA, renderingEnvelope);
            handler.setCentralMeridian(centralMeridian);
            handler.queryAcrossDateline = false;
        }
        return handler;
    }
}

