/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.net.URI;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchIdentifierException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.Operation;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.wkt.AbstractParser;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.Symbols;

public class MathTransformParser
extends AbstractParser {
    protected final MathTransformFactory mtFactory;
    private String classification;
    private OperationMethod lastMethod;

    public MathTransformParser() {
        this(Symbols.DEFAULT);
    }

    public MathTransformParser(Symbols symbols) {
        this(symbols, ReferencingFactoryFinder.getMathTransformFactory(null));
    }

    public MathTransformParser(Symbols symbols, MathTransformFactory mtFactory) {
        super(symbols);
        this.mtFactory = mtFactory;
    }

    public MathTransform parseMathTransform(String text) throws ParseException {
        Element element = this.getTree(text, new ParsePosition(0));
        MathTransform mt = this.parseMathTransform(element, true);
        element.close();
        return mt;
    }

    @Override
    protected Object parse(Element element) throws ParseException {
        return this.parseMathTransform(element, true);
    }

    final MathTransform parseMathTransform(Element element, boolean required) throws ParseException {
        this.lastMethod = null;
        this.classification = null;
        Object key = element.peek();
        if (key instanceof Element) {
            Element element1 = (Element)key;
            String keyword = element1.keyword.trim().toUpperCase(this.symbols.locale);
            if ("PARAM_MT".equals(keyword)) {
                return this.parseParamMT(element);
            }
            if ("CONCAT_MT".equals(keyword)) {
                return this.parseConcatMT(element);
            }
            if ("INVERSE_MT".equals(keyword)) {
                return this.parseInverseMT(element);
            }
            if ("PASSTHROUGH_MT".equals(keyword)) {
                return this.parsePassThroughMT(element);
            }
        }
        if (required) {
            throw element.parseFailed(null, MessageFormat.format("Type \"{0}\" is unknow in this context.", key));
        }
        return null;
    }

    private MathTransform parseParamMT(Element parent) throws ParseException {
        MathTransform transform;
        Element param;
        ParameterValueGroup parameters;
        Element element = parent.pullElement("PARAM_MT");
        this.classification = element.pullString("classification");
        try {
            parameters = this.mtFactory.getDefaultParameters(this.classification);
        }
        catch (NoSuchIdentifierException exception) {
            throw element.parseFailed(exception, null);
        }
        while ((param = element.pullOptionalElement("PARAMETER")) != null) {
            String name = param.pullString("name");
            ParameterValue<?> parameter = parameters.parameter(name);
            Class type = parameter.getDescriptor().getValueClass();
            if (Integer.class.equals(type)) {
                parameter.setValue(param.pullInteger("value"));
            } else if (Double.class.equals(type)) {
                parameter.setValue(param.pullDouble("value"));
            } else if (URI.class.equals(type)) {
                parameter.setValue(URI.create(param.pullString("value")));
            } else {
                parameter.setValue(param.pullString("value"));
            }
            param.close();
        }
        element.close();
        try {
            transform = this.mtFactory.createParameterizedTransform(parameters);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
        this.lastMethod = this.mtFactory.getLastMethodUsed();
        return transform;
    }

    private MathTransform parseInverseMT(Element parent) throws ParseException {
        Element element = parent.pullElement("INVERSE_MT");
        try {
            MathTransform transform = this.parseMathTransform(element, true).inverse();
            element.close();
            return transform;
        }
        catch (NoninvertibleTransformException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private MathTransform parsePassThroughMT(Element parent) throws ParseException {
        Element element = parent.pullElement("PASSTHROUGH_MT");
        int firstAffectedOrdinate = parent.pullInteger("firstAffectedOrdinate");
        MathTransform transform = this.parseMathTransform(element, true);
        element.close();
        try {
            return this.mtFactory.createPassThroughTransform(firstAffectedOrdinate, transform, 0);
        }
        catch (FactoryException exception) {
            throw element.parseFailed(exception, null);
        }
    }

    private MathTransform parseConcatMT(Element parent) throws ParseException {
        MathTransform optionalTransform;
        Element element = parent.pullElement("CONCAT_MT");
        MathTransform transform = this.parseMathTransform(element, true);
        while ((optionalTransform = this.parseMathTransform(element, false)) != null) {
            try {
                transform = this.mtFactory.createConcatenatedTransform(transform, optionalTransform);
            }
            catch (FactoryException exception) {
                throw element.parseFailed(exception, null);
            }
        }
        element.close();
        return transform;
    }

    final OperationMethod getOperationMethod() {
        if (this.lastMethod == null && this.classification != null) {
            for (OperationMethod method : this.mtFactory.getAvailableMethods(Operation.class)) {
                if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)method, this.classification)) continue;
                this.lastMethod = method;
                break;
            }
        }
        return this.lastMethod;
    }
}

