/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.text.MessageFormat;
import java.util.prefs.Preferences;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.referencing.wkt.UnformattableObjectException;
import org.geotools.util.Classes;

public class Formattable {
    static final String INDENTATION = "Indentation";
    private static final ThreadLocal<Formatter> FORMATTER = new ThreadLocal();
    public static final int SINGLE_LINE = 0;

    protected Formattable() {
    }

    public String toString() {
        return this.toWKT(Citations.OGC, Formattable.getIndentation(), false);
    }

    public String toWKT() throws UnformattableObjectException {
        return this.toWKT(Formattable.getIndentation());
    }

    public String toWKT(int indentation) throws UnformattableObjectException {
        return this.toWKT(Citations.OGC, indentation);
    }

    public String toWKT(int indentation, boolean strict) throws UnformattableObjectException {
        return this.toWKT(Citations.OGC, indentation, strict);
    }

    public String toWKT(Citation authority, int indentation) throws UnformattableObjectException {
        return this.toWKT(authority, indentation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toWKT(Citation authority, int indentation, boolean strict) throws UnformattableObjectException {
        if (authority == null) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" should not be null.", "authority"));
        }
        Formatter formatter = FORMATTER.get();
        if (formatter == null || formatter.indentation != indentation || formatter.getAuthority() != authority) {
            formatter = new Formatter(Symbols.DEFAULT, indentation);
            formatter.setAuthority(authority);
            FORMATTER.set(formatter);
        }
        try {
            Formattable formattable = this;
            if (formattable instanceof GeneralParameterValue) {
                GeneralParameterValue value = (GeneralParameterValue)((Object)formattable);
                formatter.append(value);
            } else {
                formatter.append(this);
            }
            if (strict && formatter.isInvalidWKT()) {
                Class unformattable = formatter.getUnformattableClass();
                throw new UnformattableObjectException(formatter.warning, unformattable);
            }
            String string = formatter.toString();
            return string;
        }
        finally {
            formatter.clear();
        }
    }

    protected String formatWKT(Formatter formatter) {
        Class<?>[] interfaces;
        Class<?> type = this.getClass();
        formatter.setInvalidWKT(type);
        for (Class<?> candidate : interfaces = type.getInterfaces()) {
            if (!candidate.getName().startsWith("org.geotools.api.referencing.")) continue;
            type = candidate;
            break;
        }
        return Classes.getShortName(type);
    }

    static int getIndentation() {
        try {
            return Preferences.userNodeForPackage(Formattable.class).getInt(INDENTATION, 2);
        }
        catch (SecurityException ignore) {
            return 2;
        }
    }

    static void setIndentation(int indentation) throws SecurityException {
        Preferences.userNodeForPackage(Formattable.class).putInt(INDENTATION, indentation);
    }

    public static void cleanupThreadLocals() {
        FORMATTER.remove();
    }
}

