/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.wkt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.referencing.wkt.Element;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.referencing.wkt.Symbols;
import org.geotools.util.Utilities;

public abstract class AbstractParser
extends Format {
    private static final boolean SCIENTIFIC_NOTATION = true;
    private transient Formatter formatter;
    final Symbols symbols;
    private final NumberFormat numberFormat;

    public AbstractParser(Symbols symbols) {
        DecimalFormat numberFormat;
        Object pattern;
        this.symbols = symbols;
        NumberFormat numberFormat2 = this.numberFormat = (NumberFormat)symbols.numberFormat.clone();
        if (numberFormat2 instanceof DecimalFormat && ((String)(pattern = (numberFormat = (DecimalFormat)numberFormat2).toPattern())).indexOf("E0") < 0) {
            int split = ((String)pattern).indexOf(59);
            if (split >= 0) {
                pattern = ((String)pattern).substring(0, split) + "E0" + ((String)pattern).substring(split);
            }
            pattern = (String)pattern + "E0";
            numberFormat.applyPattern((String)pattern);
        }
    }

    public Citation getAuthority() {
        return this.getFormatter().getAuthority();
    }

    public void setAuthority(Citation authority) {
        if (authority == null) {
            throw new IllegalArgumentException(MessageFormat.format("Argument \"{0}\" should not be null.", "authority"));
        }
        this.getFormatter().setAuthority(authority);
    }

    public boolean isColorEnabled() {
        return this.getFormatter().colorEnabled;
    }

    public void setColorEnabled(boolean enabled) {
        this.getFormatter().colorEnabled = enabled;
    }

    @Override
    public final Object parseObject(String text) throws ParseException {
        Element element = this.getTree(text, new ParsePosition(0));
        Object object = this.parse(element);
        element.close();
        return object;
    }

    @Override
    public final Object parseObject(String text, ParsePosition position) {
        int origin = position.getIndex();
        try {
            return this.parse(this.getTree(text, position));
        }
        catch (ParseException exception) {
            position.setIndex(origin);
            if (position.getErrorIndex() < origin) {
                position.setErrorIndex(exception.getErrorOffset());
            }
            return null;
        }
    }

    final Number parseNumber(String text, ParsePosition position) {
        int i;
        int base = position.getIndex();
        Number number = this.numberFormat.parse(text, position);
        if (number != null && (i = position.getIndex()) < text.length() && text.charAt(i) == 'e') {
            StringBuilder buffer = new StringBuilder(text);
            buffer.setCharAt(i, 'E');
            text = buffer.toString();
            position.setIndex(base);
            number = this.numberFormat.parse(text, position);
        }
        return number;
    }

    protected abstract Object parse(Element var1) throws ParseException;

    protected final Element getTree(String text, ParsePosition position) throws ParseException {
        return new Element(new Element(this, text, position));
    }

    private Formatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = new Formatter(this.symbols, (NumberFormat)this.symbols.numberFormat.clone());
        }
        return this.formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(Object object, StringBuffer toAppendTo, FieldPosition pos) {
        Formatter formatter = this.getFormatter();
        try {
            formatter.clear();
            formatter.buffer = toAppendTo;
            formatter.bufferBase = toAppendTo.length();
            if (object instanceof MathTransform) {
                MathTransform transform = (MathTransform)object;
                formatter.append(transform);
            } else if (object instanceof GeneralParameterValue) {
                GeneralParameterValue value = (GeneralParameterValue)object;
                formatter.append(value);
            } else {
                formatter.append((IdentifiedObject)object);
            }
            StringBuffer stringBuffer = toAppendTo;
            return stringBuffer;
        }
        finally {
            formatter.buffer = null;
        }
    }

    public void reformat(BufferedReader in, Writer out, PrintWriter err) throws IOException {
        String lineSeparator = System.getProperty("line.separator", "\n");
        String line = null;
        try {
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                out.write(lineSeparator);
                out.write(this.format(this.parseObject(line)));
                out.write(lineSeparator);
                out.write(lineSeparator);
                out.flush();
            }
        }
        catch (ParseException exception) {
            err.println(exception.getLocalizedMessage());
            if (line != null) {
                AbstractParser.reportError(err, line, exception.getErrorOffset());
            }
        }
        catch (InvalidParameterValueException exception) {
            String arg0 = exception.getParameterName();
            err.print(MessageFormat.format("Error in \"{0}\":", arg0));
            err.print(' ');
            err.println(exception.getLocalizedMessage());
        }
    }

    public String getWarning() {
        if (this.formatter != null && this.formatter.isInvalidWKT()) {
            if (this.formatter.warning != null) {
                return this.formatter.warning;
            }
            return MessageFormat.format("This \"{0}\" object is too complex for WKT syntax.", this.formatter.getUnformattableClass());
        }
        return null;
    }

    static void reportError(PrintWriter err, String line, int errorOffset) {
        boolean hasTrailing;
        line = line.replace('\r', ' ').replace('\n', ' ');
        int WINDOW_WIDTH = 80;
        int stop = line.length();
        int base = errorOffset - 40;
        int baseMax = stop - 80;
        boolean bl = hasTrailing = Math.max(base, 0) < baseMax;
        if (!hasTrailing) {
            base = baseMax;
        }
        if (base < 0) {
            base = 0;
        }
        stop = Math.min(stop, base + 80);
        if (hasTrailing) {
            stop -= 3;
        }
        if (base != 0) {
            err.print("...");
            errorOffset += 3;
            base += 3;
        }
        err.print(line.substring(base, stop));
        if (hasTrailing) {
            err.println("...");
        } else {
            err.println();
        }
        err.print(Utilities.spaces(errorOffset - base));
        err.println('^');
    }
}

