/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.proj;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class PROJAliases {
    private static final String ALIAS_TABLE = "PROJAliases.txt";
    private Map<String, String> ellipsoidAliases = new HashMap<String, String>();
    private Map<String, String> primeMeridianAliases = new HashMap<String, String>();

    public PROJAliases() {
        URL aliasURL = PROJAliases.class.getResource(ALIAS_TABLE);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(aliasURL.openStream(), StandardCharsets.UTF_8));){
            String line;
            Map<String, String> currentMap = null;
            while ((line = br.readLine()) != null) {
                String[] parts;
                if ((line = line.trim()).startsWith("[EllipsoidAliases]")) {
                    currentMap = this.ellipsoidAliases;
                    continue;
                }
                if (line.startsWith("[PrimeMeridianAliases]")) {
                    currentMap = this.primeMeridianAliases;
                    continue;
                }
                if (line.isEmpty() || line.startsWith("#") || (parts = line.split(";")).length != 2 || currentMap == null) continue;
                String epsgVersion = parts[0].trim();
                String projAlias = parts[1].trim();
                currentMap.put(epsgVersion, projAlias);
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to load PROJ Aliases ", ioe.getCause());
        }
    }

    public String getEllipsoidAlias(String epsgEllipsoid) {
        return this.ellipsoidAliases.get(epsgEllipsoid);
    }

    public String getPrimeMeridianAlias(String epsgPrimeMeridian) {
        return this.primeMeridianAliases.get(epsgPrimeMeridian);
    }
}

