/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.transform.ThinPlateSpline2D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class ThinPlateSplineTransform
implements MathTransform {
    private final List<Coordinate> sourcePoints;
    private final List<Coordinate> targetPoints;
    private final ThinPlateSpline2D tpsX;
    private final ThinPlateSpline2D tpsY;

    public ThinPlateSplineTransform(List<Coordinate> sourcePoints, List<Coordinate> targetPoints) {
        if (sourcePoints.size() != targetPoints.size()) {
            throw new IllegalArgumentException("Source and target point lists must be the same size.");
        }
        this.sourcePoints = sourcePoints;
        this.targetPoints = targetPoints;
        double[] xTarget = new double[targetPoints.size()];
        double[] yTarget = new double[targetPoints.size()];
        for (int i = 0; i < sourcePoints.size(); ++i) {
            xTarget[i] = targetPoints.get((int)i).x;
            yTarget[i] = targetPoints.get((int)i).y;
        }
        CoordinateArraySequence sourcePointsSeq = new CoordinateArraySequence(sourcePoints.toArray(new Coordinate[0]));
        this.tpsX = new ThinPlateSpline2D(sourcePointsSeq, xTarget);
        this.tpsY = new ThinPlateSpline2D(sourcePointsSeq, yTarget);
    }

    public ThinPlateSplineTransform(List<MappedPosition> positions) {
        if (positions == null || positions.isEmpty()) {
            throw new IllegalArgumentException("Positions list must not be null or empty.");
        }
        ArrayList<Coordinate> src = new ArrayList<Coordinate>(positions.size());
        ArrayList<Coordinate> dst = new ArrayList<Coordinate>(positions.size());
        for (MappedPosition mp : positions) {
            src.add(new Coordinate(mp.getSource().getOrdinate(0), mp.getSource().getOrdinate(1)));
            dst.add(new Coordinate(mp.getTarget().getOrdinate(0), mp.getTarget().getOrdinate(1)));
        }
        this.sourcePoints = src;
        this.targetPoints = dst;
        double[] xTarget = new double[dst.size()];
        double[] yTarget = new double[dst.size()];
        for (int i = 0; i < src.size(); ++i) {
            xTarget[i] = ((Coordinate)dst.get((int)i)).x;
            yTarget[i] = ((Coordinate)dst.get((int)i)).y;
        }
        CoordinateArraySequence sourcePointsSeq = new CoordinateArraySequence(this.sourcePoints.toArray(new Coordinate[0]));
        this.tpsX = new ThinPlateSpline2D(sourcePointsSeq, xTarget);
        this.tpsY = new ThinPlateSpline2D(sourcePointsSeq, yTarget);
    }

    @Override
    public int getSourceDimensions() {
        return 2;
    }

    @Override
    public int getTargetDimensions() {
        return 2;
    }

    @Override
    public Position transform(Position ptSrc, Position ptDst) throws MismatchedDimensionException, TransformException {
        if (ptDst == null) {
            ptDst = new Position2D();
        }
        double x = ptSrc.getOrdinate(0);
        double y = ptSrc.getOrdinate(1);
        ptDst.setOrdinate(0, this.tpsX.interpolate(x, y));
        ptDst.setOrdinate(1, this.tpsY.interpolate(x, y));
        return ptDst;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        for (int i = 0; i < numPts; ++i) {
            double x = srcPts[srcOff + 2 * i];
            double y = srcPts[srcOff + 2 * i + 1];
            dstPts[dstOff + 2 * i] = this.tpsX.interpolate(x, y);
            dstPts[dstOff + 2 * i + 1] = this.tpsY.interpolate(x, y);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        for (int i = 0; i < numPts; ++i) {
            double x = srcPts[srcOff + 2 * i];
            double y = srcPts[srcOff + 2 * i + 1];
            dstPts[dstOff + 2 * i] = (float)this.tpsX.interpolate(x, y);
            dstPts[dstOff + 2 * i + 1] = (float)this.tpsY.interpolate(x, y);
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        for (int i = 0; i < numPts; ++i) {
            double x = srcPts[srcOff + 2 * i];
            double y = srcPts[srcOff + 2 * i + 1];
            dstPts[dstOff + 2 * i] = this.tpsX.interpolate(x, y);
            dstPts[dstOff + 2 * i + 1] = this.tpsY.interpolate(x, y);
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        for (int i = 0; i < numPts; ++i) {
            double x = srcPts[srcOff + 2 * i];
            double y = srcPts[srcOff + 2 * i + 1];
            dstPts[dstOff + 2 * i] = (float)this.tpsX.interpolate(x, y);
            dstPts[dstOff + 2 * i + 1] = (float)this.tpsY.interpolate(x, y);
        }
    }

    @Override
    public Matrix derivative(Position point) throws MismatchedDimensionException, TransformException {
        double x = point.getOrdinate(0);
        double y = point.getOrdinate(1);
        double eps = 1.0E-6;
        double dx1 = (this.tpsX.interpolate(x + eps, y) - this.tpsX.interpolate(x - eps, y)) / (2.0 * eps);
        double dy1 = (this.tpsX.interpolate(x, y + eps) - this.tpsX.interpolate(x, y - eps)) / (2.0 * eps);
        double dx2 = (this.tpsY.interpolate(x + eps, y) - this.tpsY.interpolate(x - eps, y)) / (2.0 * eps);
        double dy2 = (this.tpsY.interpolate(x, y + eps) - this.tpsY.interpolate(x, y - eps)) / (2.0 * eps);
        return new GeneralMatrix(new double[][]{{dx1, dy1}, {dx2, dy2}});
    }

    @Override
    public MathTransform inverse() throws UnsupportedOperationException {
        return new ThinPlateSplineTransform(this.targetPoints, this.sourcePoints);
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    @Override
    public String toWKT() throws UnsupportedOperationException {
        StringBuilder wkt = new StringBuilder();
        wkt.append("PARAM_MT[\"ThinPlateSpline\",\n");
        wkt.append("  PARAMETER[\"num_points\", ").append(this.sourcePoints.size()).append("],\n");
        for (int i = 0; i < this.sourcePoints.size(); ++i) {
            Coordinate src = this.sourcePoints.get(i);
            Coordinate dst = this.targetPoints.get(i);
            wkt.append("  PARAMETER[\"source_").append(i).append("\", [").append(src.x).append(", ").append(src.y).append("]],\n");
            wkt.append("  PARAMETER[\"target_").append(i).append("\", [").append(dst.x).append(", ").append(dst.y).append("]]");
            if (i < this.sourcePoints.size() - 1) {
                wkt.append(",");
            }
            wkt.append("\n");
        }
        wkt.append("]");
        return wkt.toString();
    }

    public String toString() {
        return "ThinPlateSplineTransform";
    }
}

