/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.util.HashSet;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;

public class ThinPlateSpline2D {
    private final CoordinateSequence sourcePoints;
    private final double[] weights;
    private final int n;

    public ThinPlateSpline2D(CoordinateSequence sourcePoints, double[] values) {
        if (sourcePoints.size() != values.length) {
            throw new IllegalArgumentException("Source points and target values must have the same length.");
        }
        HashSet<Coordinate> uniquePoints = new HashSet<Coordinate>();
        for (int i = 0; i < sourcePoints.size(); ++i) {
            Coordinate p = sourcePoints.getCoordinate(i);
            if (uniquePoints.add(p)) continue;
            throw new IllegalArgumentException("Duplicate control points are not allowed.");
        }
        if (uniquePoints.size() < 3) {
            throw new IllegalArgumentException("At least 3 unique control points are required for TPS.");
        }
        this.n = sourcePoints.size();
        this.sourcePoints = sourcePoints;
        this.weights = this.solveSystem(sourcePoints, values);
    }

    private double U(double r2) {
        if (r2 == 0.0) {
            return 0.0;
        }
        return r2 * Math.log(Math.sqrt(r2));
    }

    private double r2(double x1, double y1, double x2, double y2) {
        double dx = x1 - x2;
        double dy = y1 - y2;
        return dx * dx + dy * dy;
    }

    private double[] solveSystem(CoordinateSequence sourcePoints, double[] v) {
        int i;
        int N = sourcePoints.size();
        int M = N + 3;
        double[][] A = new double[M][M];
        double[] b = new double[M];
        for (i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                A[i][j] = this.U(this.r2(sourcePoints.getX(i), sourcePoints.getY(i), sourcePoints.getX(j), sourcePoints.getY(j)));
            }
        }
        for (i = 0; i < N; ++i) {
            A[i][N] = 1.0;
            A[i][N + 1] = sourcePoints.getX(i);
            A[i][N + 2] = sourcePoints.getY(i);
            A[N][i] = 1.0;
            A[N + 1][i] = sourcePoints.getX(i);
            A[N + 2][i] = sourcePoints.getY(i);
        }
        System.arraycopy(v, 0, b, 0, N);
        return this.gaussianElimination(A, b);
    }

    private double[] gaussianElimination(double[][] A, double[] b) {
        int i;
        int N = A.length;
        double[][] aug = new double[N][N + 1];
        for (i = 0; i < N; ++i) {
            System.arraycopy(A[i], 0, aug[i], 0, N);
            aug[i][N] = b[i];
        }
        for (i = 0; i < N; ++i) {
            int maxRow = i;
            for (int k = i + 1; k < N; ++k) {
                if (!(Math.abs(aug[k][i]) > Math.abs(aug[maxRow][i]))) continue;
                maxRow = k;
            }
            double[] tmp = aug[i];
            aug[i] = aug[maxRow];
            aug[maxRow] = tmp;
            for (int k = i + 1; k < N; ++k) {
                double f = aug[k][i] / aug[i][i];
                for (int j = i; j <= N; ++j) {
                    double[] dArray = aug[k];
                    int n = j;
                    dArray[n] = dArray[n] - f * aug[i][j];
                }
            }
        }
        double[] x = new double[N];
        for (int i2 = N - 1; i2 >= 0; --i2) {
            x[i2] = aug[i2][N] / aug[i2][i2];
            for (int k = i2 - 1; k >= 0; --k) {
                double[] dArray = aug[k];
                int n = N;
                dArray[n] = dArray[n] - aug[k][i2] * x[i2];
            }
        }
        return x;
    }

    public double interpolate(double xVal, double yVal) {
        double sum = 0.0;
        for (int i = 0; i < this.n; ++i) {
            sum += this.weights[i] * this.U(this.r2(xVal, yVal, this.sourcePoints.getX(i), this.sourcePoints.getY(i)));
        }
        sum += this.weights[this.n];
        sum += this.weights[this.n + 1] * xVal;
        return sum += this.weights[this.n + 2] * yVal;
    }
}

