/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.util.prefs.Preferences;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.NoSuchIdentifierException;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.referencing.operation.Transformation;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.gridshift.GridShiftLocator;
import org.geotools.referencing.factory.gridshift.NADCONGridShiftFactory;
import org.geotools.referencing.factory.gridshift.NADConGridShift;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.util.Arguments;

public class NADCONTransform
extends AbstractMathTransform
implements MathTransform2D,
Serializable {
    private static final long serialVersionUID = -4707304160205218546L;
    private static NADCONGridShiftFactory FACTORY = new NADCONGridShiftFactory();
    private static final String GRID_LOCATION = "Grid location";
    private static final String DEFAULT_GRID_LOCATION = ".";
    private static final double TOL = 5.0E-10;
    private static final int MAX_ITER = 10;
    private static final double SEC_2_DEG = 3600.0;
    private final URI latGridName;
    private final URI longGridName;
    private MathTransform gridShiftTransform;
    private transient MathTransform2D inverse;
    NADConGridShift grid;

    public NADCONTransform(URI latGridName, URI longGridName) throws ParameterNotFoundException, FactoryException {
        if (latGridName == null) {
            throw new NoSuchIdentifierException("Latitud grid shift file name is null", null);
        }
        if (longGridName == null) {
            throw new NoSuchIdentifierException("Latitud grid shift file name is null", null);
        }
        this.latGridName = latGridName;
        this.longGridName = longGridName;
        URL latGridURL = this.locateGrid(latGridName);
        URL longGridURL = this.locateGrid(longGridName);
        this.grid = FACTORY.loadGridShift(latGridURL, longGridURL);
        this.gridShiftTransform = this.grid.getMathTransform();
    }

    protected URL locateGrid(URI uri) throws FactoryException {
        String grid = uri.toString();
        for (GridShiftLocator locator : ReferencingFactoryFinder.getGridShiftLocators(null)) {
            URL result = locator.locateGrid(grid);
            if (result == null) continue;
            return result;
        }
        throw new FactoryException("Could not locate grid file " + grid);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameter<URI> lat_diff_file = new Parameter<URI>(Provider.LAT_DIFF_FILE);
        lat_diff_file.setValue(this.latGridName);
        Parameter<URI> long_diff_file = new Parameter<URI>(Provider.LONG_DIFF_FILE);
        long_diff_file.setValue(this.longGridName);
        return new ParameterGroup(this.getParameterDescriptors(), lat_diff_file, long_diff_file);
    }

    @Override
    public int getSourceDimensions() {
        return 2;
    }

    @Override
    public int getTargetDimensions() {
        return 2;
    }

    @Override
    public void transform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int step = 0;
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * this.getSourceDimensions() > dstOff) {
            step = -this.getSourceDimensions();
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double x = srcPts[srcOff++];
            double y = srcPts[srcOff++];
            if (x < this.grid.getMinX() || x > this.grid.getMaxX() || y < this.grid.getMinY() || y > this.grid.getMaxY()) {
                throw new TransformException("Point (" + x + " " + y + ") is not outside of ((" + this.grid.getMinX() + " " + this.grid.getMinY() + ")(" + this.grid.getMaxX() + " " + this.grid.getMaxY() + "))");
            }
            double xgrid = (x - this.grid.getMinX()) / this.grid.getDx();
            double ygrid = (y - this.grid.getMinY()) / this.grid.getDy();
            double[] array = new double[]{xgrid, ygrid};
            this.gridShiftTransform.transform(array, 0, array, 0, 1);
            dstPts[dstOff++] = x - array[0] / 3600.0;
            dstPts[dstOff++] = y + array[1] / 3600.0;
            srcOff += step;
            dstOff += step;
        }
    }

    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int step = 0;
        if (srcPts == dstPts && srcOff < dstOff && srcOff + numPts * this.getSourceDimensions() > dstOff) {
            step = -this.getSourceDimensions();
            srcOff -= (numPts - 1) * step;
            dstOff -= (numPts - 1) * step;
        }
        while (--numPts >= 0) {
            double ytemp;
            double xtemp;
            block5: {
                double x = srcPts[srcOff++];
                double y = srcPts[srcOff++];
                xtemp = x;
                ytemp = y;
                int i = 10;
                do {
                    double[] array = new double[]{xtemp, ytemp};
                    this.transform(array, 0, array, 0, 1);
                    double xdif = array[0] - x;
                    double ydif = array[1] - y;
                    if (Math.abs(xdif) > 5.0E-10) {
                        xtemp -= xdif;
                    }
                    if (Math.abs(ydif) > 5.0E-10) {
                        ytemp -= ydif;
                    }
                    if (Math.abs(xdif) <= 5.0E-10 && Math.abs(ydif) <= 5.0E-10) break block5;
                } while (--i >= 0);
                throw new TransformException("Transformation doesn't convergence.");
            }
            dstPts[dstOff++] = xtemp;
            dstPts[dstOff++] = ytemp;
            srcOff += step;
            dstOff += step;
        }
    }

    @Override
    public synchronized MathTransform2D inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    @Override
    public int hashCode() {
        return this.grid.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            NADCONTransform that = (NADCONTransform)object;
            return this.grid.equals(that.grid);
        }
        return false;
    }

    public static void main(String ... args) {
        Arguments arguments = new Arguments(args);
        PrintWriter out = arguments.out;
        Preferences prefs = Preferences.userNodeForPackage(NADCONTransform.class);
        if (args.length == 1) {
            if (args[0].equalsIgnoreCase("default")) {
                prefs.remove(GRID_LOCATION);
            } else {
                prefs.put(GRID_LOCATION, args[0]);
            }
        } else {
            String location = prefs.get(GRID_LOCATION, DEFAULT_GRID_LOCATION);
            out.println("Usage: java org.geotools.referencing.operation.transform.NADCONTransform <defalult grid file location (path)>");
            out.print("Grid location: \"");
            out.print(location);
            out.println('\"');
        }
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -4707304160205218546L;
        public static final ParameterDescriptor<URI> LAT_DIFF_FILE = new DefaultParameterDescriptor<Object>("Latitude difference file", URI.class, null, null);
        public static final ParameterDescriptor<URI> LONG_DIFF_FILE = new DefaultParameterDescriptor<Object>("Longitude difference file", URI.class, null, null);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "NADCON"), new NamedIdentifier(Citations.EPSG, "NADCON"), new NamedIdentifier(Citations.EPSG, "9613"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(145))}, new ParameterDescriptor[]{LAT_DIFF_FILE, LONG_DIFF_FILE});

        public Provider() {
            super(2, 2, PARAMETERS);
        }

        public Class<Transformation> getOperationType() {
            return Transformation.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup values) throws ParameterNotFoundException, FactoryException {
            return new NADCONTransform(Provider.getParameter(LAT_DIFF_FILE, values).getValue(), Provider.getParameter(LONG_DIFF_FILE, values).getValue());
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse
    implements MathTransform2D,
    Serializable {
        private static final long serialVersionUID = -4707304160205218546L;

        @Override
        public ParameterValueGroup getParameterValues() {
            return null;
        }

        @Override
        public void transform(double[] source, int srcOffset, double[] dest, int dstOffset, int length) throws TransformException {
            NADCONTransform.this.inverseTransform(source, srcOffset, dest, dstOffset, length);
        }

        @Override
        public MathTransform2D inverse() {
            return (MathTransform2D)super.inverse();
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            NADCONTransform.this.inverse = this;
        }
    }
}

