/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform1D;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.Position1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;

final class ConcatenatedTransform1D
extends ConcatenatedTransform
implements MathTransform1D {
    private static final long serialVersionUID = 8150427971141078395L;

    public ConcatenatedTransform1D(MathTransform transform1, MathTransform transform2) {
        super(transform1, transform2);
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 1 && this.getTargetDimensions() == 1;
    }

    @Override
    public double transform(double value) throws TransformException {
        double[] values = new double[]{value};
        double[] buffer = new double[]{this.transform1.getTargetDimensions()};
        this.transform1.transform(values, 0, buffer, 0, 1);
        this.transform2.transform(buffer, 0, values, 0, 1);
        return values[0];
    }

    @Override
    public double derivative(double value) throws TransformException {
        Position1D p = new Position1D(value);
        Matrix m = this.derivative(p);
        assert (m.getNumRow() == 1 && m.getNumCol() == 1);
        return m.getElement(0, 0);
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }
}

