/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.text.MessageFormat;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.InvalidParameterValueException;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.ReferenceIdentifier;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform1D;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.api.referencing.operation.NoninvertibleTransformException;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.geometry.GeneralPosition;
import org.geotools.geometry.util.ShapeUtilities;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.SingularMatrixException;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;

public abstract class AbstractMathTransform
extends Formattable
implements MathTransform {
    protected AbstractMathTransform() {
    }

    public String getName() {
        String code;
        ReferenceIdentifier identifier;
        ParameterDescriptorGroup descriptor = this.getParameterDescriptors();
        if (descriptor != null && (identifier = descriptor.getName()) != null && (code = identifier.getCode()) != null) {
            return code;
        }
        return Classes.getShortClassName(this);
    }

    @Override
    public abstract int getSourceDimensions();

    @Override
    public abstract int getTargetDimensions();

    public ParameterDescriptorGroup getParameterDescriptors() {
        return null;
    }

    public ParameterValueGroup getParameterValues() {
        return null;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    private static String constructMessage(String argument, int dimension, int expected) {
        return MessageFormat.format("Argument \"{0}\" has {1} dimensions, while {2} was expected.", argument, dimension, expected);
    }

    public Point2D transform(Point2D ptSrc, Point2D ptDst) throws TransformException {
        int dim = this.getSourceDimensions();
        if (dim != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptSrc", 2, dim));
        }
        dim = this.getTargetDimensions();
        if (dim != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptDst", 2, dim));
        }
        double[] ord = new double[]{ptSrc.getX(), ptSrc.getY()};
        this.transform(ord, 0, ord, 0, 1);
        if (ptDst != null) {
            ptDst.setLocation(ord[0], ord[1]);
            return ptDst;
        }
        return new Point2D.Double(ord[0], ord[1]);
    }

    @Override
    public Position transform(Position ptSrc, Position ptDst) throws TransformException {
        int dimPoint = ptSrc.getDimension();
        int dimSource = this.getSourceDimensions();
        int dimTarget = this.getTargetDimensions();
        if (dimPoint != dimSource) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptSrc", dimPoint, dimSource));
        }
        if (ptDst != null) {
            int i;
            double[] array;
            dimPoint = ptDst.getDimension();
            if (dimPoint != dimTarget) {
                throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptDst", dimPoint, dimTarget));
            }
            if (dimSource >= dimTarget) {
                array = ptSrc.getCoordinate();
            } else {
                array = new double[dimTarget];
                i = dimSource;
                while (--i >= 0) {
                    array[i] = ptSrc.getOrdinate(i);
                }
            }
            this.transform(array, 0, array, 0, 1);
            i = dimTarget;
            while (--i >= 0) {
                ptDst.setOrdinate(i, array[i]);
            }
        } else {
            double[] source;
            GeneralPosition destination = new GeneralPosition(dimTarget);
            ptDst = destination;
            if (dimSource <= dimTarget) {
                source = destination.ordinates;
                int i = dimSource;
                while (--i >= 0) {
                    source[i] = ptSrc.getOrdinate(i);
                }
            } else {
                source = ptSrc.getCoordinate();
            }
            this.transform(source, 0, destination.ordinates, 0, 1);
        }
        return ptDst;
    }

    @Override
    public void transform(float[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int dimSource = this.getSourceDimensions();
        int dimTarget = this.getTargetDimensions();
        double[] tmpPts = new double[numPts * Math.max(dimSource, dimTarget)];
        int i = numPts * dimSource;
        while (--i >= 0) {
            tmpPts[i] = srcPts[srcOff + i];
        }
        this.transform(tmpPts, 0, tmpPts, 0, numPts);
        i = numPts * dimTarget;
        while (--i >= 0) {
            dstPts[dstOff + i] = (float)tmpPts[i];
        }
    }

    @Override
    public void transform(double[] srcPts, int srcOff, float[] dstPts, int dstOff, int numPts) throws TransformException {
        int dimSource = this.getSourceDimensions();
        int dimTarget = this.getTargetDimensions();
        double[] tmpPts = new double[numPts * Math.max(dimSource, dimTarget)];
        System.arraycopy(srcPts, srcOff, tmpPts, 0, numPts * dimSource);
        this.transform(tmpPts, 0, tmpPts, 0, numPts);
        int i = numPts * dimTarget;
        while (--i >= 0) {
            dstPts[dstOff + i] = (float)tmpPts[i];
        }
    }

    @Override
    public void transform(float[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws TransformException {
        int dimTarget;
        int dimSource = this.getSourceDimensions();
        if (dimSource == (dimTarget = this.getTargetDimensions())) {
            int n = numPts * dimSource;
            for (int i = 0; i < n; ++i) {
                dstPts[dstOff + i] = srcPts[srcOff + i];
            }
            this.transform(dstPts, dstOff, dstPts, dstOff, numPts);
        } else {
            double[] tmpPts = new double[numPts * dimSource];
            int i = tmpPts.length;
            while (--i >= 0) {
                tmpPts[i] = srcPts[srcOff + i];
            }
            this.transform(tmpPts, 0, dstPts, 0, numPts);
        }
    }

    public Shape createTransformedShape(Shape shape) throws TransformException {
        return this.isIdentity() ? shape : this.createTransformedShape(shape, null, null, 0);
    }

    final Shape createTransformedShape(Shape shape, AffineTransform preTransform, AffineTransform postTransform, int orientation) throws TransformException {
        int dim = this.getSourceDimensions();
        if (dim != 2 || (dim = this.getTargetDimensions()) != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("shape", 2, dim));
        }
        PathIterator it = shape.getPathIterator(preTransform);
        GeneralPath path = new GeneralPath(it.getWindingRule());
        Point2D.Float ctrl = new Point2D.Float();
        double[] buffer = new double[6];
        double ax = 0.0;
        double ay = 0.0;
        double px = 0.0;
        double py = 0.0;
        while (!it.isDone()) {
            block13: {
                switch (it.currentSegment(buffer)) {
                    default: {
                        throw new IllegalPathStateException();
                    }
                    case 4: {
                        path.closePath();
                        break block13;
                    }
                    case 0: {
                        ax = buffer[0];
                        ay = buffer[1];
                        this.transform(buffer, 0, buffer, 0, 1);
                        px = buffer[0];
                        py = buffer[1];
                        path.moveTo((float)px, (float)py);
                        break block13;
                    }
                    case 1: {
                        double d = ax;
                        ax = buffer[0];
                        buffer[0] = 0.5 * (d + ax);
                        double d2 = ay;
                        ay = buffer[1];
                        buffer[1] = 0.5 * (d2 + ay);
                        buffer[2] = ax;
                        buffer[3] = ay;
                        break;
                    }
                    case 2: {
                        double d = ax;
                        ax = buffer[2];
                        buffer[0] = 0.5 * (buffer[0] + 0.5 * (d + ax));
                        double d3 = ay;
                        ay = buffer[3];
                        buffer[1] = 0.5 * (buffer[1] + 0.5 * (d3 + ay));
                        break;
                    }
                    case 3: {
                        double d = ax;
                        ax = buffer[4];
                        buffer[0] = 0.25 * (1.5 * (buffer[0] + buffer[2]) + 0.5 * (d + ax));
                        double d4 = ay;
                        ay = buffer[5];
                        buffer[1] = 0.25 * (1.5 * (buffer[1] + buffer[3]) + 0.5 * (d4 + ay));
                        buffer[2] = ax;
                        buffer[3] = ay;
                    }
                }
                this.transform(buffer, 0, buffer, 0, 2);
                Point2D ctrlPoint = ShapeUtilities.parabolicControlPoint(px, py, buffer[0], buffer[1], buffer[2], buffer[3], orientation, ctrl);
                px = buffer[2];
                py = buffer[3];
                if (ctrlPoint != null) {
                    assert (ctrl == ctrlPoint);
                    path.quadTo(ctrl.x, ctrl.y, (float)px, (float)py);
                } else {
                    path.lineTo((float)px, (float)py);
                }
            }
            it.next();
        }
        if (postTransform != null) {
            path.transform(postTransform);
        }
        return ShapeUtilities.toPrimitive(path);
    }

    public Matrix derivative(Point2D point) throws TransformException {
        int dimSource = this.getSourceDimensions();
        if (dimSource != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("point", 2, dimSource));
        }
        throw new TransformException("Can't compute derivative.");
    }

    @Override
    public Matrix derivative(Position point) throws TransformException {
        int dimSource = this.getSourceDimensions();
        if (point == null) {
            if (dimSource == 2) {
                return this.derivative((Point2D)null);
            }
        } else {
            int dimPoint = point.getDimension();
            if (dimPoint != dimSource) {
                throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("point", dimPoint, dimSource));
            }
            if (dimSource == 2) {
                if (point instanceof Point2D) {
                    Point2D point2D = (Point2D)((Object)point);
                    return this.derivative(point2D);
                }
                return this.derivative(new Point2D.Double(point.getOrdinate(0), point.getOrdinate(1)));
            }
            AbstractMathTransform abstractMathTransform = this;
            if (abstractMathTransform instanceof MathTransform1D) {
                MathTransform1D transform1D = (MathTransform1D)((Object)abstractMathTransform);
                return new Matrix1(transform1D.derivative(point.getOrdinate(0)));
            }
        }
        throw new TransformException("Can't compute derivative.");
    }

    @Override
    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        throw new NoninvertibleTransformException("Transform is not invertible.");
    }

    MathTransform concatenate(MathTransform other, boolean applyOtherFirst) {
        return null;
    }

    public int hashCode() {
        return this.getSourceDimensions() + 37 * this.getTargetDimensions();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            AbstractMathTransform that = (AbstractMathTransform)object;
            return Utilities.equals(this.getParameterDescriptors(), that.getParameterDescriptors());
        }
        return false;
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        ParameterValueGroup parameters = this.getParameterValues();
        if (parameters != null) {
            formatter.append(formatter.getName(parameters.getDescriptor()));
            formatter.append(parameters);
        }
        return "PARAM_MT";
    }

    protected static void ensureNonNull(String name, Object object) throws InvalidParameterValueException {
        if (object == null) {
            throw new InvalidParameterValueException(MessageFormat.format("Argument \"{0}\" should not be null.", name), name, object);
        }
    }

    protected static boolean needCopy(int srcOff, int dimSource, int dstOff, int dimTarget, int numPts) {
        if (numPts <= 1 || srcOff >= dstOff && dimSource >= dimTarget) {
            return false;
        }
        return srcOff < dstOff + numPts * dimTarget && dstOff < srcOff + numPts * dimSource;
    }

    protected static double rollLongitude(double x) {
        return x - Math.PI * 2 * Math.floor(x / (Math.PI * 2) + 0.5);
    }

    protected static double normalizeAngle(double x) {
        return x - Math.PI * 2 * Math.floor(x / (Math.PI * 2) + 0.5);
    }

    static XMatrix toXMatrix(Matrix matrix) {
        if (matrix instanceof XMatrix) {
            XMatrix xMatrix = (XMatrix)matrix;
            return xMatrix;
        }
        return MatrixFactory.create(matrix);
    }

    static GeneralMatrix toGMatrix(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            GeneralMatrix generalMatrix = (GeneralMatrix)matrix;
            return generalMatrix;
        }
        return new GeneralMatrix(matrix);
    }

    static Matrix invert(Matrix matrix) throws NoninvertibleTransformException {
        try {
            XMatrix m = AbstractMathTransform.toXMatrix(matrix);
            m.invert();
            return m;
        }
        catch (SingularMatrixException exception) {
            NoninvertibleTransformException e = new NoninvertibleTransformException("Transform is not invertible.");
            e.initCause(exception);
            throw e;
        }
    }

    protected abstract class Inverse
    extends AbstractMathTransform
    implements Serializable {
        private static final long serialVersionUID = 3528274816628012283L;

        protected Inverse() {
        }

        @Override
        public String getName() {
            return AbstractMathTransform.this.getName() + " (" + Vocabulary.format(114) + ")";
        }

        @Override
        public int getSourceDimensions() {
            return AbstractMathTransform.this.getTargetDimensions();
        }

        @Override
        public int getTargetDimensions() {
            return AbstractMathTransform.this.getSourceDimensions();
        }

        @Override
        public Matrix derivative(Point2D point) throws TransformException {
            return Inverse.invert(AbstractMathTransform.this.derivative(this.transform(point, null)));
        }

        @Override
        public Matrix derivative(Position point) throws TransformException {
            return Inverse.invert(AbstractMathTransform.this.derivative(this.transform(point, null)));
        }

        @Override
        public MathTransform inverse() {
            return AbstractMathTransform.this;
        }

        @Override
        public boolean isIdentity() {
            return AbstractMathTransform.this.isIdentity();
        }

        @Override
        public int hashCode() {
            return ~AbstractMathTransform.this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Inverse) {
                Inverse that = (Inverse)object;
                return Utilities.equals(this.inverse(), that.inverse());
            }
            return false;
        }

        @Override
        protected String formatWKT(Formatter formatter) {
            ParameterValueGroup parameters = this.getParameterValues();
            if (parameters != null) {
                formatter.append(formatter.getName(parameters.getDescriptor()));
                formatter.append(parameters);
                return "PARAM_MT";
            }
            formatter.append(AbstractMathTransform.this);
            return "INVERSE_MT";
        }
    }
}

