/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.CylindricalProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.ProjectionException;

public class Polyconic {
    private static final long serialVersionUID = 6516419168461705584L;
    private static final double EPSILON = 1.0E-10;
    private static final int MAXIMUM_ITERATIONS = 20;
    private static final double ITERATION_TOLERANCE = 1.0E-12;

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = 3082828148070128422L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Polyconic"), new NamedIdentifier(Citations.EPSG, "American Polyconic"), new NamedIdentifier(Citations.EPSG, "9818"), new NamedIdentifier(Citations.GEOTIFF, "Polyconic"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(251)), new NamedIdentifier(Citations.PROJ, "poly")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<CylindricalProjection> getOperationType() {
            return CylindricalProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters);
            }
            return new Ellipsoidal(parameters);
        }
    }

    public static class Spherical
    extends Abstract {
        protected Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double phi;
            double lam;
            double d;
            y = this.latitudeOfOrigin + y;
            if (Math.abs(d) <= 1.0E-10) {
                lam = x;
                phi = 0.0;
            } else {
                block4: {
                    phi = y;
                    double B = x * x + y * y;
                    int i = 20;
                    do {
                        double tp = Math.tan(phi);
                        double dphi = (y * (phi * tp + 1.0) - phi - 0.5 * (phi * phi + B) * tp) / ((phi - y) / tp - 1.0);
                        phi -= dphi;
                        if (!(Math.abs(dphi) > 1.0E-12)) break block4;
                    } while (--i != 0);
                    throw new ProjectionException("Transformation doesn't convergence.");
                }
                lam = Math.asin(x * Math.tan(phi)) / Math.sin(phi);
            }
            if (ptDst != null) {
                ptDst.setLocation(lam, phi);
                return ptDst;
            }
            return new Point2D.Double(lam, phi);
        }

        @Override
        protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
            double y;
            double x;
            if (Math.abs(phi) <= 1.0E-10) {
                x = lam;
                y = this.ml0;
            } else {
                double cot = 1.0 / Math.tan(phi);
                double E = lam * Math.sin(phi);
                x = Math.sin(E) * cot;
                y = phi - this.latitudeOfOrigin + cot * (1.0 - Math.cos(E));
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }
    }

    public static class Ellipsoidal
    extends Abstract {
        protected Ellipsoidal(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
        }

        @Override
        protected Point2D transformNormalized(double lam, double phi, Point2D ptDst) throws ProjectionException {
            double y;
            double x;
            if (Math.abs(phi) <= 1.0E-10) {
                x = lam;
                y = -this.ml0;
            } else {
                double d;
                double sp = Math.sin(phi);
                double cp = Math.cos(phi);
                double ms = Math.abs(d) > 1.0E-10 ? this.msfn(sp, cp) / sp : 0.0;
                x = ms * Math.sin(lam *= sp);
                y = this.mlfn(phi, sp, cp) - this.ml0 + ms * (1.0 - Math.cos(lam));
            }
            if (ptDst != null) {
                ptDst.setLocation(x, y);
                return ptDst;
            }
            return new Point2D.Double(x, y);
        }

        @Override
        protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
            double phi;
            double lam;
            if (Math.abs(y += this.ml0) <= 1.0E-10) {
                lam = x;
                phi = 0.0;
            } else {
                int i;
                double r = y * y + x * x;
                phi = y;
                for (i = 0; i <= 20; ++i) {
                    double mlb;
                    double sp = Math.sin(phi);
                    double cp = Math.cos(phi);
                    if (Math.abs(cp) < 1.0E-12) {
                        throw new ProjectionException("Transformation doesn't convergence.");
                    }
                    double s2ph = sp * cp;
                    double mlp = Math.sqrt(1.0 - this.excentricitySquared * sp * sp);
                    double c = sp * mlp / cp;
                    double ml = this.mlfn(phi, sp, cp);
                    double dPhi = (ml + ml + c * (mlb = ml * ml + r) - 2.0 * y * (c * ml + 1.0)) / (this.excentricitySquared * s2ph * (mlb - 2.0 * y * ml) / c + 2.0 * (y - ml) * (c * (mlp = (1.0 - this.excentricitySquared) / (mlp * mlp * mlp)) - 1.0 / s2ph) - mlp - mlp);
                    if (Math.abs(dPhi) <= 1.0E-12) break;
                    phi += dPhi;
                }
                if (i > 20) {
                    throw new ProjectionException("Transformation doesn't convergence.");
                }
                double c = Math.sin(phi);
                lam = Math.asin(x * Math.tan(phi) * Math.sqrt(1.0 - this.excentricitySquared * c * c)) / Math.sin(phi);
            }
            if (ptDst != null) {
                ptDst.setLocation(lam, phi);
                return ptDst;
            }
            return new Point2D.Double(lam, phi);
        }
    }

    public static abstract class Abstract
    extends MapProjection {
        protected final double ml0;

        protected Abstract(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
            this.ml0 = this.mlfn(this.latitudeOfOrigin, Math.sin(this.latitudeOfOrigin), Math.cos(this.latitudeOfOrigin));
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return Provider.PARAMETERS;
        }

        @Override
        protected double getToleranceForAssertions(double longitude, double latitude) {
            if (Math.abs(longitude - this.centralMeridian) / 2.0 + Math.abs(latitude - this.latitudeOfOrigin) > 10.0) {
                return 0.1;
            }
            return super.getToleranceForAssertions(longitude, latitude);
        }

        @Override
        public int hashCode() {
            long code = Double.doubleToLongBits(this.ml0);
            return ((int)code ^ (int)(code >>> 32)) + 37 * super.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (super.equals(object)) {
                Abstract that = (Abstract)object;
                return Abstract.equals(this.ml0, that.ml0);
            }
            return false;
        }
    }
}

