/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import java.awt.geom.Point2D;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.referencing.operation.projection.Orthographic;
import org.geotools.referencing.operation.projection.ProjectionException;

public class PolarOrthographic
extends Orthographic {
    private static final long serialVersionUID = 3281503361127178484L;
    private static final double EPSILON = 1.0E-6;
    private final boolean northPole;

    protected PolarOrthographic(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
        PolarOrthographic.ensureLatitudeEquals(Orthographic.Provider.LATITUDE_OF_ORIGIN, this.latitudeOfOrigin, 1.5707963267948966);
        this.northPole = this.latitudeOfOrigin > 0.0;
        this.latitudeOfOrigin = this.northPole ? 1.5707963267948966 : -1.5707963267948966;
    }

    @Override
    protected Point2D transformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        if (Math.abs(y - this.latitudeOfOrigin) - 1.0E-6 > 1.5707963267948966) {
            throw new ProjectionException("Point outside hemisphere of projection.");
        }
        double cosphi = Math.cos(y);
        double coslam = Math.cos(x);
        if (this.northPole) {
            coslam = -coslam;
        }
        y = cosphi * coslam;
        x = cosphi * Math.sin(x);
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }

    @Override
    protected Point2D inverseTransformNormalized(double x, double y, Point2D ptDst) throws ProjectionException {
        double rho = Math.hypot(x, y);
        double sinc = rho;
        if (sinc > 1.0) {
            if (sinc - 1.0 > 1.0E-6) {
                throw new ProjectionException("Point outside hemisphere of projection.");
            }
            sinc = 1.0;
        }
        if (rho <= 1.0E-6) {
            y = this.latitudeOfOrigin;
            x = 0.0;
        } else {
            double phi;
            if (this.northPole) {
                y = -y;
                phi = Math.acos(sinc);
            } else {
                phi = -Math.acos(sinc);
            }
            x = Math.atan2(x, y);
            y = phi;
        }
        if (ptDst != null) {
            ptDst.setLocation(x, y);
            return ptDst;
        }
        return new Point2D.Double(x, y);
    }
}

