/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.projection;

import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.parameter.ParameterDescriptorGroup;
import org.geotools.api.parameter.ParameterNotFoundException;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.referencing.operation.CylindricalProjection;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Mercator;

public class Mercator1SP
extends Mercator {
    private static final long serialVersionUID = 8391549772210490073L;

    protected Mercator1SP(ParameterValueGroup parameters) throws ParameterNotFoundException {
        super(parameters);
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    public static class Provider
    extends MapProjection.AbstractProvider {
        private static final long serialVersionUID = -5886510621481710072L;
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Mercator_1SP"), new NamedIdentifier(Citations.EPSG, "Mercator (1SP)"), new NamedIdentifier(Citations.EPSG, "Mercator (1SP) (Spherical)"), new NamedIdentifier(Citations.EPSG, "Mercator (variant A)"), new NamedIdentifier(Citations.EPSG, "9804"), new NamedIdentifier(Citations.GEOTIFF, "CT_Mercator"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(34)), new NamedIdentifier(Citations.PROJ, "merc")}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, LATITUDE_OF_ORIGIN, CENTRAL_MERIDIAN, SCALE_FACTOR, FALSE_EASTING, FALSE_NORTHING});

        public Provider() {
            super(PARAMETERS);
        }

        public Class<CylindricalProjection> getOperationType() {
            return CylindricalProjection.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameters) throws ParameterNotFoundException {
            if (Provider.isSpherical(parameters)) {
                return new Spherical(parameters);
            }
            return new Mercator1SP(parameters);
        }
    }

    private static final class Spherical
    extends Mercator.Spherical {
        private static final long serialVersionUID = 1347778643385433516L;

        Spherical(ParameterValueGroup parameters) throws ParameterNotFoundException {
            super(parameters);
        }

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return Provider.PARAMETERS;
        }
    }
}

