/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.util.HashMap;
import java.util.Map;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.NamedIdentifier;

class EnsembleDefinition {
    static final Map<String, EnsembleDefinition> ENSEMBLE_MAP_BY_NAME = new HashMap<String, EnsembleDefinition>();
    static final Map<String, EnsembleDefinition> ENSEMBLE_MAP_BY_CODE = new HashMap<String, EnsembleDefinition>();
    String name;
    NamedIdentifier nameIdentifier;
    String code;
    String ellipsoidCode;
    String primeMeridianCode;
    String identifierAuthority;
    String datumCode;
    boolean vertical;

    public EnsembleDefinition(String name, NamedIdentifier nameIdentifier, String code, String ellipsoidCode, String primeMeridianCode, String identifierAuthority, String datumCode, boolean vertical) {
        this.name = name;
        this.nameIdentifier = nameIdentifier;
        this.code = code;
        this.ellipsoidCode = ellipsoidCode;
        this.primeMeridianCode = primeMeridianCode;
        this.identifierAuthority = identifierAuthority;
        this.datumCode = datumCode;
        this.vertical = vertical;
    }

    public static boolean hasId(String identifier) {
        return ENSEMBLE_MAP_BY_NAME.containsKey(identifier);
    }

    public static boolean hasCode(String code) {
        return ENSEMBLE_MAP_BY_CODE.containsKey(code);
    }

    public static EnsembleDefinition getEnsemble(String epsg) {
        EnsembleDefinition result = null;
        if (ENSEMBLE_MAP_BY_CODE.containsKey(epsg)) {
            result = ENSEMBLE_MAP_BY_CODE.get(epsg);
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public NamedIdentifier getNameIdentifier() {
        return this.nameIdentifier;
    }

    public String getCode() {
        return this.code;
    }

    public String getEllipsoidCode() {
        return this.ellipsoidCode;
    }

    public String getPrimeMeridianCode() {
        return this.primeMeridianCode;
    }

    public String getIdentifierAuthority() {
        return this.identifierAuthority;
    }

    public String getDatumCode() {
        return this.datumCode;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    static {
        EnsembleDefinition wgs84 = new EnsembleDefinition("World Geodetic System 1984", new NamedIdentifier(Citations.EPSG, "World Geodetic System 1984"), "6326", "7030", "8901", "6326", "1155", false);
        ENSEMBLE_MAP_BY_NAME.put(wgs84.getName(), wgs84);
        ENSEMBLE_MAP_BY_CODE.put(wgs84.getCode(), wgs84);
        EnsembleDefinition etrs89 = new EnsembleDefinition("European Terrestrial Reference System 1989", new NamedIdentifier(Citations.EPSG, "European Terrestrial Reference System 1989"), "6258", "7019", "8901", "6258", "6258", false);
        ENSEMBLE_MAP_BY_NAME.put(etrs89.getName(), etrs89);
        ENSEMBLE_MAP_BY_CODE.put(etrs89.getCode(), etrs89);
        EnsembleDefinition dvr90 = new EnsembleDefinition("Dansk Vertikal Reference 1990", new NamedIdentifier(Citations.EPSG, "Dansk Vertikal Reference 1990"), "1371", null, null, "5206", null, true);
        ENSEMBLE_MAP_BY_NAME.put(dvr90.getName(), dvr90);
        ENSEMBLE_MAP_BY_CODE.put(dvr90.getCode(), dvr90);
    }
}

