/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.Unit;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CRSFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.crs.GeneralDerivedCRS;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ImageCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.AffineCS;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.cs.CSFactory;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.CylindricalCS;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.cs.LinearCS;
import org.geotools.api.referencing.cs.PolarCS;
import org.geotools.api.referencing.cs.SphericalCS;
import org.geotools.api.referencing.cs.TimeCS;
import org.geotools.api.referencing.cs.UserDefinedCS;
import org.geotools.api.referencing.cs.VerticalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.ImageDatum;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.BackingStoreException;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.util.CanonicalSet;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;

public class TransformedAuthorityFactory
extends AuthorityFactoryAdapter {
    private static final DefaultCoordinateSystemAxis[] RENAMEABLE = new DefaultCoordinateSystemAxis[]{DefaultCoordinateSystemAxis.NORTHING, DefaultCoordinateSystemAxis.SOUTHING, DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.WESTING};
    private transient CoordinateOperationFactory opFactory;
    private final CanonicalSet<Object> pool = CanonicalSet.newInstance(Object.class);

    protected TransformedAuthorityFactory(AuthorityFactory factory) {
        super(factory);
    }

    protected TransformedAuthorityFactory(CRSAuthorityFactory crsFactory, CSAuthorityFactory csFactory, DatumAuthorityFactory datumFactory, CoordinateOperationAuthorityFactory opFactory) {
        super(crsFactory, csFactory, datumFactory, opFactory);
    }

    protected TransformedAuthorityFactory(String authority, Hints userHints) throws FactoryRegistryException {
        super(authority, userHints);
    }

    @Override
    public int getPriority() {
        return this.priority + 1;
    }

    @Override
    protected Unit<?> replace(Unit<?> units) throws FactoryException {
        return units;
    }

    protected AxisDirection replace(AxisDirection direction) throws FactoryException {
        return direction;
    }

    @Override
    protected CoordinateSystemAxis replace(CoordinateSystemAxis axis) throws FactoryException {
        boolean directionChanged;
        AxisDirection oldDirection = axis.getDirection();
        AxisDirection newDirection = this.replace(oldDirection);
        Unit<?> oldUnits = axis.getUnit();
        Unit<?> newUnits = this.replace(oldUnits);
        boolean bl = directionChanged = !oldDirection.equals(newDirection);
        if (directionChanged) {
            String name = axis.getName().getCode();
            block0: for (int i = 0; i < RENAMEABLE.length; ++i) {
                if (!RENAMEABLE[i].nameMatches(name)) continue;
                for (i = 0; i < RENAMEABLE.length; ++i) {
                    DefaultCoordinateSystemAxis candidate = RENAMEABLE[i];
                    if (!newDirection.equals(candidate.getDirection())) continue;
                    axis = candidate;
                    oldUnits = axis.getUnit();
                    directionChanged = false;
                    break block0;
                }
                break;
            }
        }
        if (directionChanged || !oldUnits.equals(newUnits)) {
            ReferencingFactoryContainer factories = this.getFactoryContainer(false);
            CSFactory csFactory = factories.getCSFactory();
            Map<String, ?> properties = this.getProperties(axis);
            axis = csFactory.createCoordinateSystemAxis(properties, axis.getAbbreviation(), newDirection, newUnits);
            axis = this.pool.unique(axis);
        }
        return axis;
    }

    @Override
    protected CoordinateSystem replace(CoordinateSystem cs) throws FactoryException {
        int i;
        int dimension = cs.getDimension();
        CoordinateSystemAxis[] orderedAxis = new CoordinateSystemAxis[dimension];
        for (i = 0; i < dimension; ++i) {
            orderedAxis[i] = this.replace(cs.getAxis(i));
        }
        TransformedAuthorityFactory transformedAuthorityFactory = this;
        if (transformedAuthorityFactory instanceof Comparator) {
            Comparator comparator = (Comparator)((Object)transformedAuthorityFactory);
            Arrays.sort(orderedAxis, comparator);
        }
        for (i = 0; i < dimension; ++i) {
            if (orderedAxis[i].equals(cs.getAxis(i))) continue;
            CoordinateSystem modified = this.createCS(cs.getClass(), this.getProperties(cs), orderedAxis);
            assert (Classes.sameInterfaces(cs.getClass(), modified.getClass(), CoordinateSystem.class));
            modified = this.pool.unique(modified);
            return modified;
        }
        return cs;
    }

    @Override
    protected Datum replace(Datum datum) throws FactoryException {
        return super.replace(datum);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    protected CoordinateReferenceSystem replace(CoordinateReferenceSystem crs) throws FactoryException {
        void var7_34;
        boolean sameCS;
        Datum datum;
        Datum oldDatum;
        CoordinateSystem oldCS = crs.getCoordinateSystem();
        CoordinateSystem cs = this.replace(oldCS);
        if (crs instanceof SingleCRS) {
            SingleCRS rS = (SingleCRS)crs;
            oldDatum = rS.getDatum();
            datum = this.replace(oldDatum);
        } else {
            oldDatum = null;
            datum = null;
        }
        boolean bl = sameCS = Utilities.equals(cs, oldCS) && Utilities.equals(datum, oldDatum);
        if (crs instanceof GeneralDerivedCRS) {
            GeneralDerivedCRS derivedCRS = (GeneralDerivedCRS)crs;
            CoordinateReferenceSystem oldBaseCRS = derivedCRS.getBaseCRS();
            CoordinateReferenceSystem baseCRS = this.replace(oldBaseCRS);
            if (sameCS && Utilities.equals(baseCRS, oldBaseCRS)) {
                return crs;
            }
            Map<String, ?> properties = this.getProperties(crs);
            ReferencingFactoryContainer factories = this.getFactoryContainer(true);
            CRSFactory crsFactory = factories.getCRSFactory();
            Conversion fromBase = derivedCRS.getConversionFromBase();
            fromBase = new DefiningConversion(this.getProperties(fromBase), fromBase.getMethod(), fromBase.getParameterValues());
            if (!(crs instanceof ProjectedCRS)) {
                String arg0 = crs.getName().getCode();
                throw new FactoryException(MessageFormat.format("Coordinate reference system \"{0}\" is unsupported.", arg0));
            }
            ProjectedCRS projectedCRS = crsFactory.createProjectedCRS(properties, (GeographicCRS)baseCRS, fromBase, (CartesianCS)cs);
            return (CoordinateReferenceSystem)this.pool.unique(var7_34);
        }
        if (sameCS) {
            return crs;
        }
        Map<String, ?> properties = this.getProperties(crs);
        ReferencingFactoryContainer factories = this.getFactoryContainer(true);
        CRSFactory crsFactory = factories.getCRSFactory();
        if (crs instanceof GeographicCRS) {
            GeographicCRS geographicCRS = crsFactory.createGeographicCRS(properties, (GeodeticDatum)datum, (EllipsoidalCS)cs);
            return (CoordinateReferenceSystem)this.pool.unique(var7_34);
        }
        if (crs instanceof GeocentricCRS) {
            GeodeticDatum gd = (GeodeticDatum)datum;
            if (cs instanceof CartesianCS) {
                CartesianCS cS = (CartesianCS)cs;
                GeocentricCRS geocentricCRS = crsFactory.createGeocentricCRS(properties, gd, cS);
                return (CoordinateReferenceSystem)this.pool.unique(var7_34);
            } else {
                GeocentricCRS geocentricCRS = crsFactory.createGeocentricCRS(properties, gd, (SphericalCS)cs);
            }
            return (CoordinateReferenceSystem)this.pool.unique(var7_34);
        }
        if (crs instanceof VerticalCRS) {
            VerticalCRS verticalCRS = crsFactory.createVerticalCRS(properties, (VerticalDatum)datum, (VerticalCS)cs);
            return (CoordinateReferenceSystem)this.pool.unique(var7_34);
        } else if (crs instanceof TemporalCRS) {
            TemporalCRS temporalCRS = crsFactory.createTemporalCRS(properties, (TemporalDatum)datum, (TimeCS)cs);
            return (CoordinateReferenceSystem)this.pool.unique(var7_34);
        } else if (crs instanceof ImageCRS) {
            ImageCRS imageCRS = crsFactory.createImageCRS(properties, (ImageDatum)datum, (AffineCS)cs);
            return (CoordinateReferenceSystem)this.pool.unique(var7_34);
        } else if (crs instanceof EngineeringCRS) {
            EngineeringCRS engineeringCRS = crsFactory.createEngineeringCRS(properties, (EngineeringDatum)datum, cs);
            return (CoordinateReferenceSystem)this.pool.unique(var7_34);
        } else {
            if (!(crs instanceof CompoundCRS)) {
                String arg0 = crs.getName().getCode();
                throw new FactoryException(MessageFormat.format("Coordinate reference system \"{0}\" is unsupported.", arg0));
            }
            CompoundCRS rS = (CompoundCRS)crs;
            List<CoordinateReferenceSystem> elements = rS.getCoordinateReferenceSystems();
            CoordinateReferenceSystem[] m = new CoordinateReferenceSystem[elements.size()];
            for (int i = 0; i < m.length; ++i) {
                m[i] = this.replace(elements.get(i));
            }
            CompoundCRS compoundCRS = crsFactory.createCompoundCRS(properties, m);
        }
        return (CoordinateReferenceSystem)this.pool.unique(var7_34);
    }

    @Override
    protected CoordinateOperation replace(CoordinateOperation operation) throws FactoryException {
        CoordinateReferenceSystem targetCRS;
        CoordinateReferenceSystem oldSrcCRS = operation.getSourceCRS();
        CoordinateReferenceSystem oldTgtCRS = operation.getTargetCRS();
        CoordinateReferenceSystem sourceCRS = oldSrcCRS != null ? this.replace(oldSrcCRS) : null;
        CoordinateReferenceSystem coordinateReferenceSystem = targetCRS = oldTgtCRS != null ? this.replace(oldTgtCRS) : null;
        if (Utilities.equals(oldSrcCRS, sourceCRS) && Utilities.equals(oldTgtCRS, targetCRS)) {
            return operation;
        }
        if (this.opFactory == null) {
            this.opFactory = this.getCoordinateOperationFactory();
        }
        CoordinateOperation modified = this.opFactory.createOperation(sourceCRS, targetCRS);
        modified = this.pool.unique(modified);
        return modified;
    }

    private CoordinateSystem createCS(Class<? extends CoordinateSystem> type, Map<String, ?> properties, CoordinateSystemAxis ... axis) throws FactoryException {
        int dimension = axis.length;
        ReferencingFactoryContainer factories = this.getFactoryContainer(false);
        CSFactory csFactory = factories.getCSFactory();
        if (CartesianCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 2: {
                    return csFactory.createCartesianCS(properties, axis[0], axis[1]);
                }
                case 3: {
                    return csFactory.createCartesianCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        } else if (EllipsoidalCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 2: {
                    return csFactory.createEllipsoidalCS(properties, axis[0], axis[1]);
                }
                case 3: {
                    return csFactory.createEllipsoidalCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        } else if (SphericalCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 3: {
                    return csFactory.createSphericalCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        } else if (CylindricalCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 3: {
                    return csFactory.createCylindricalCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        } else if (PolarCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 2: {
                    return csFactory.createPolarCS(properties, axis[0], axis[1]);
                }
            }
        } else if (VerticalCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 1: {
                    return csFactory.createVerticalCS(properties, axis[0]);
                }
            }
        } else if (TimeCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 1: {
                    return csFactory.createTimeCS(properties, axis[0]);
                }
            }
        } else if (LinearCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 1: {
                    return csFactory.createLinearCS(properties, axis[0]);
                }
            }
        } else if (UserDefinedCS.class.isAssignableFrom(type)) {
            switch (dimension) {
                case 2: {
                    return csFactory.createUserDefinedCS(properties, axis[0], axis[1]);
                }
                case 3: {
                    return csFactory.createUserDefinedCS(properties, axis[0], axis[1], axis[2]);
                }
            }
        }
        throw new FactoryException(MessageFormat.format("Coordinate system \"{0}\" is unsupported.", type));
    }

    private Map<String, ?> getProperties(IdentifiedObject object) {
        Citation authority = this.getAuthority();
        if (!Utilities.equals(authority, object.getName().getAuthority())) {
            return AbstractIdentifiedObject.getProperties(object, authority);
        }
        return AbstractIdentifiedObject.getProperties(object);
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCode, String targetCode) throws FactoryException {
        Set<CoordinateOperation> operations = super.createFromCoordinateReferenceSystemCodes(sourceCode, targetCode);
        LinkedHashSet<CoordinateOperation> modified = new LinkedHashSet<CoordinateOperation>((int)((float)operations.size() / 0.75f) + 1);
        Iterator<CoordinateOperation> it = operations.iterator();
        while (it.hasNext()) {
            CoordinateOperation operation;
            try {
                operation = it.next();
            }
            catch (BackingStoreException exception) {
                Throwable cause = exception.getCause();
                if (cause instanceof FactoryException) {
                    FactoryException factoryException = (FactoryException)cause;
                    throw factoryException;
                }
                throw exception;
            }
            modified.add(this.replace(operation));
        }
        return modified;
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        this.pool.clear();
        super.dispose();
    }
}

