/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.awt.RenderingHints;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CRSFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.SingleCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.CSFactory;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.datum.DatumFactory;
import org.geotools.api.referencing.datum.VerticalDatumType;
import org.geotools.api.referencing.operation.Conversion;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransformFactory;
import org.geotools.api.referencing.operation.Matrix;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.DefiningConversion;
import org.geotools.util.XArray;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;

public class ReferencingFactoryContainer
extends ReferencingFactory {
    private static FactoryRegistry cache;
    private DatumFactory datumFactory;
    private CSFactory csFactory;
    private CRSFactory crsFactory;
    private MathTransformFactory mtFactory;

    public ReferencingFactoryContainer(Hints userHints) {
        Hints reduced = new Hints(userHints);
        this.datumFactory = (DatumFactory)((Object)ReferencingFactoryContainer.extract(reduced, Hints.DATUM_FACTORY));
        this.csFactory = (CSFactory)((Object)ReferencingFactoryContainer.extract(reduced, Hints.CS_FACTORY));
        this.crsFactory = (CRSFactory)((Object)ReferencingFactoryContainer.extract(reduced, Hints.CRS_FACTORY));
        this.mtFactory = (MathTransformFactory)((Object)ReferencingFactoryContainer.extract(reduced, Hints.MATH_TRANSFORM_FACTORY));
        if (!reduced.isEmpty()) {
            this.setHintsInto(reduced);
            this.addImplementationHints(reduced);
            this.initialize();
            this.hints.clear();
        }
    }

    private static Factory extract(Map<?, ?> reduced, Hints.Key key) {
        Object candidate;
        if (reduced != null && (candidate = reduced.get(key)) instanceof Factory) {
            Factory factory = (Factory)candidate;
            reduced.remove(key);
            return factory;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferencingFactoryContainer instance(Hints hints) {
        Hints completed = GeoTools.getDefaultHints();
        if (hints != null) {
            completed.add(hints);
        }
        Class<ReferencingFactoryFinder> clazz = ReferencingFactoryFinder.class;
        synchronized (ReferencingFactoryFinder.class) {
            if (cache == null) {
                cache = new FactoryCreator(Arrays.asList(ReferencingFactoryContainer.class));
                cache.registerFactory(new ReferencingFactoryContainer(null), ReferencingFactoryContainer.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache.getFactory(ReferencingFactoryContainer.class, null, completed, null);
        }
    }

    private void initialize() {
        this.mtFactory = this.getMathTransformFactory();
        this.datumFactory = this.getDatumFactory();
        this.csFactory = this.getCSFactory();
        this.crsFactory = this.getCRSFactory();
    }

    private void setHintsInto(Map<? super RenderingHints.Key, Object> hints) {
        if (this.crsFactory != null) {
            hints.put(Hints.CRS_FACTORY, this.crsFactory);
        }
        if (this.csFactory != null) {
            hints.put(Hints.CS_FACTORY, this.csFactory);
        }
        if (this.datumFactory != null) {
            hints.put(Hints.DATUM_FACTORY, this.datumFactory);
        }
        if (this.mtFactory != null) {
            hints.put(Hints.MATH_TRANSFORM_FACTORY, this.mtFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        Map map = this.hints;
        synchronized (map) {
            if (this.hints.isEmpty()) {
                this.initialize();
                this.setHintsInto(this.hints);
            }
        }
        return super.getImplementationHints();
    }

    private Hints hints() {
        Hints completed = new Hints(this.hints);
        this.setHintsInto(completed);
        return completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.datumFactory = ReferencingFactoryFinder.getDatumFactory(this.hints());
            }
        }
        return this.datumFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSFactory getCSFactory() {
        if (this.csFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.csFactory = ReferencingFactoryFinder.getCSFactory(this.hints());
            }
        }
        return this.csFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.crsFactory = ReferencingFactoryFinder.getCRSFactory(this.hints());
            }
        }
        return this.crsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(this.hints());
            }
        }
        return this.mtFactory;
    }

    public CoordinateReferenceSystem toGeodetic3D(CompoundCRS crs) throws FactoryException {
        List<SingleCRS> components = DefaultCompoundCRS.getSingleCRS(crs);
        int count = components.size();
        SingleCRS horizontal = null;
        VerticalCRS vertical = null;
        int hi = 0;
        int vi = 0;
        for (int i = 0; i < count; ++i) {
            SingleCRS candidate = components.get(i);
            if (candidate instanceof VerticalCRS) {
                VerticalCRS rS = (VerticalCRS)candidate;
                if (vertical == null && VerticalDatumType.ELLIPSOIDAL.equals((vertical = rS).getDatum().getVerticalDatumType())) {
                    vi = i;
                    continue;
                }
                return crs;
            }
            if (!(candidate instanceof GeographicCRS) && !(candidate instanceof ProjectedCRS)) continue;
            if (horizontal == null && (horizontal = candidate).getCoordinateSystem().getDimension() == 2) {
                hi = i;
                continue;
            }
            return crs;
        }
        if (horizontal != null && vertical != null && Math.abs(vi - hi) == 1) {
            boolean xyFirst = hi < vi;
            SingleCRS single = this.toGeodetic3D(count == 2 ? crs : null, horizontal, vertical, xyFirst);
            if (count == 2) {
                return single;
            }
            int i = xyFirst ? hi : vi;
            components = new ArrayList<SingleCRS>(components);
            components.remove(i);
            components.set(i, single);
            CoordinateReferenceSystem[] c = components.toArray(new SingleCRS[components.size()]);
            return this.crsFactory.createCompoundCRS(AbstractIdentifiedObject.getProperties(crs), c);
        }
        return crs;
    }

    private SingleCRS toGeodetic3D(CompoundCRS crs, SingleCRS horizontal, VerticalCRS vertical, boolean xyFirst) throws FactoryException {
        Map<String, ?> crsName;
        Map<String, ?> csName;
        CoordinateSystemAxis[] axis = new CoordinateSystemAxis[3];
        CoordinateSystem cs = horizontal.getCoordinateSystem();
        axis[xyFirst ? 0 : 1] = cs.getAxis(0);
        axis[xyFirst ? 1 : 2] = cs.getAxis(1);
        axis[xyFirst ? 2 : 0] = vertical.getCoordinateSystem().getAxis(0);
        if (crs != null) {
            csName = AbstractIdentifiedObject.getProperties(crs.getCoordinateSystem());
            crsName = AbstractIdentifiedObject.getProperties(crs);
        } else {
            csName = ReferencingFactoryContainer.getTemporaryName(cs);
            crsName = ReferencingFactoryContainer.getTemporaryName(horizontal);
        }
        CSFactory csFactory = this.getCSFactory();
        CRSFactory crsFactory = this.getCRSFactory();
        if (horizontal instanceof GeographicCRS) {
            GeographicCRS sourceCRS = (GeographicCRS)horizontal;
            EllipsoidalCS targetCS = csFactory.createEllipsoidalCS(csName, axis[0], axis[1], axis[2]);
            return crsFactory.createGeographicCRS(crsName, sourceCRS.getDatum(), targetCS);
        }
        if (horizontal instanceof ProjectedCRS) {
            ProjectedCRS sourceCRS = (ProjectedCRS)horizontal;
            CartesianCS targetCS = csFactory.createCartesianCS(csName, axis[0], axis[1], axis[2]);
            GeographicCRS base2D = sourceCRS.getBaseCRS();
            GeographicCRS base3D = (GeographicCRS)this.toGeodetic3D(null, base2D, vertical, xyFirst);
            Matrix prepend = ReferencingFactoryContainer.toStandard(base2D, false);
            Matrix append = ReferencingFactoryContainer.toStandard(sourceCRS, true);
            Conversion projection = sourceCRS.getConversionFromBase();
            if (!prepend.isIdentity() || !append.isIdentity()) {
                MathTransformFactory mtFactory = this.getMathTransformFactory();
                MathTransform mt = projection.getMathTransform();
                mt = mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform(mtFactory.createAffineTransform(prepend), mt), mtFactory.createAffineTransform(append));
                projection = new DefiningConversion(AbstractCS.getProperties(projection), projection.getMethod(), mt);
            }
            return crsFactory.createProjectedCRS(crsName, base3D, projection, targetCS);
        }
        throw new AssertionError(horizontal);
    }

    private static Matrix toStandard(CoordinateReferenceSystem crs, boolean inverse) {
        CoordinateSystem sourceCS = crs.getCoordinateSystem();
        CoordinateSystem targetCS = AbstractCS.standard(sourceCS);
        if (inverse) {
            return AbstractCS.swapAndScaleAxis(targetCS, sourceCS);
        }
        return AbstractCS.swapAndScaleAxis(sourceCS, targetCS);
    }

    public CoordinateReferenceSystem separate(CoordinateReferenceSystem crs, int[] dimensions) throws FactoryException {
        int length = dimensions.length;
        int crsDimension = crs.getCoordinateSystem().getDimension();
        if (length == 0 || dimensions[0] < 0 || dimensions[length - 1] >= crsDimension || !XArray.isStrictlySorted(dimensions)) {
            throw new IllegalArgumentException(MessageFormat.format("Illegal value for argument \"{0}\".", "dimension"));
        }
        if (length == crsDimension) {
            return crs;
        }
        if (crs instanceof CompoundCRS) {
            CompoundCRS rS = (CompoundCRS)crs;
            int count = 0;
            int lowerDimension = 0;
            int lowerIndex = 0;
            List<CoordinateReferenceSystem> sources = rS.getCoordinateReferenceSystems();
            CoordinateReferenceSystem[] targets = new CoordinateReferenceSystem[sources.size()];
            block0: for (CoordinateReferenceSystem source : sources) {
                int upperDimension = lowerDimension + source.getCoordinateSystem().getDimension();
                if (lowerIndex == dimensions.length) break;
                while (dimensions[lowerIndex] < lowerDimension) {
                    if (++lowerIndex != dimensions.length) continue;
                    break block0;
                }
                int upperIndex = lowerIndex;
                while (dimensions[upperIndex] < upperDimension && ++upperIndex != dimensions.length) {
                }
                if (lowerIndex != upperIndex) {
                    int[] sub = new int[upperIndex - lowerIndex];
                    for (int j = 0; j < sub.length; ++j) {
                        sub[j] = dimensions[j + lowerIndex] - lowerDimension;
                    }
                    targets[count++] = this.separate(source, sub);
                }
                lowerDimension = upperDimension;
                lowerIndex = upperIndex;
            }
            if (count == 1) {
                return targets[0];
            }
            return this.getCRSFactory().createCompoundCRS(ReferencingFactoryContainer.getTemporaryName(crs), XArray.resize(targets, count));
        }
        String arg0 = crs.getName().getCode();
        throw new FactoryException(MessageFormat.format("Can't separate CRS \"{0}\".", arg0));
    }

    private static Map<String, ?> getTemporaryName(IdentifiedObject source) {
        return Collections.singletonMap("name", source.getName().getCode() + " (3D)");
    }
}

