/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.DerivedCRS;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ImageCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.CylindricalCS;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.cs.PolarCS;
import org.geotools.api.referencing.cs.SphericalCS;
import org.geotools.api.referencing.cs.TimeCS;
import org.geotools.api.referencing.cs.VerticalCS;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.ImageDatum;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.util.factory.FactoryNotFoundException;

public class FallbackAuthorityFactory
extends AuthorityFactoryAdapter {
    private final AbstractAuthorityFactory fallback;
    private static int failureCount;

    static boolean chainable(AuthorityFactory primary, AuthorityFactory fallback) {
        return (FallbackAuthorityFactory.interfaceMask(primary) & FallbackAuthorityFactory.interfaceMask(fallback)) != 0;
    }

    protected FallbackAuthorityFactory(AuthorityFactory primary, AuthorityFactory fallback) {
        super(primary, fallback);
        AbstractAuthorityFactory abstractAuthorityFactory;
        FallbackAuthorityFactory.ensureNonNull("fallback", fallback);
        if (fallback instanceof AbstractAuthorityFactory) {
            AbstractAuthorityFactory aaf = (AbstractAuthorityFactory)fallback;
            abstractAuthorityFactory = aaf;
        } else {
            abstractAuthorityFactory = new AuthorityFactoryAdapter(fallback);
        }
        this.fallback = abstractAuthorityFactory;
    }

    public static <T extends AuthorityFactory> T create(Class<T> type, Collection<T> factories) throws FactoryNotFoundException, ClassCastException {
        FallbackAuthorityFactory.ensureNonNull("type", type);
        FallbackAuthorityFactory.ensureNonNull("factories", factories);
        if (factories.isEmpty()) {
            throw new FactoryNotFoundException(MessageFormat.format("No factory of kind \"{0}\" found.", type));
        }
        return (T)((AuthorityFactory)type.cast(FallbackAuthorityFactory.create(false, FallbackAuthorityFactory.interfaceMask(type), factories.iterator())));
    }

    public static AuthorityFactory create(Collection<? extends AuthorityFactory> factories) throws FactoryNotFoundException {
        FallbackAuthorityFactory.ensureNonNull("factories", factories);
        if (factories.isEmpty()) {
            throw new FactoryNotFoundException(MessageFormat.format("No factory of kind \"{0}\" found.", AuthorityFactory.class));
        }
        return FallbackAuthorityFactory.create(false, FallbackAuthorityFactory.interfaceMask(factories), factories.iterator());
    }

    private static AuthorityFactory create(boolean automatic, int interfaceMask, Iterator<? extends AuthorityFactory> factories) throws FactoryNotFoundException {
        AuthorityFactory primary = factories.next();
        if (factories.hasNext()) {
            AuthorityFactory fallback = FallbackAuthorityFactory.create(true, interfaceMask, factories);
            while (fallback != primary) {
                if (!FallbackAuthorityFactory.sameAuthorityCodes(fallback, primary)) {
                    if (automatic) {
                        interfaceMask &= FallbackAuthorityFactory.interfaceMask(primary) | FallbackAuthorityFactory.interfaceMask(fallback);
                    }
                    primary = FallbackAuthorityFactory.create(interfaceMask, primary, fallback);
                    break;
                }
                if (!(fallback instanceof FallbackAuthorityFactory)) break;
                FallbackAuthorityFactory factory = (FallbackAuthorityFactory)fallback;
                fallback = factory.fallback;
            }
        }
        return primary;
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        Collection<? super AuthorityFactory> dep = super.dependencies();
        dep.add(this.fallback);
        return dep;
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        LinkedHashSet<String> codes = new LinkedHashSet<String>(super.getAuthorityCodes(type));
        codes.addAll(this.fallback.getAuthorityCodes(type));
        return codes;
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        try {
            return super.getDescriptionText(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("getDescriptionText", exception);
            try {
                return this.fallback.getDescriptionText(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        try {
            return super.createObject(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createObject", exception);
            try {
                return this.fallback.createObject(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public org.geotools.api.referencing.datum.Datum createDatum(String code) throws FactoryException {
        try {
            return super.createDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createDatum", exception);
            try {
                return this.fallback.createDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        try {
            return super.createEngineeringDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createEngineeringDatum", exception);
            try {
                return this.fallback.createEngineeringDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public ImageDatum createImageDatum(String code) throws FactoryException {
        try {
            return super.createImageDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createImageDatum", exception);
            try {
                return this.fallback.createImageDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        try {
            return super.createVerticalDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createVerticalDatum", exception);
            try {
                return this.fallback.createVerticalDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        try {
            return super.createTemporalDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createTemporalDatum", exception);
            try {
                return this.fallback.createTemporalDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        try {
            return super.createGeodeticDatum(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createGeodeticDatum", exception);
            try {
                return this.fallback.createGeodeticDatum(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        try {
            return super.createEllipsoid(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createEllipsoid", exception);
            try {
                return this.fallback.createEllipsoid(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        try {
            return super.createPrimeMeridian(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createPrimeMeridian", exception);
            try {
                return this.fallback.createPrimeMeridian(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public Extent createExtent(String code) throws FactoryException {
        try {
            return super.createExtent(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createExtent", exception);
            try {
                return this.fallback.createExtent(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        try {
            return super.createCoordinateSystem(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateSystem", exception);
            try {
                return this.fallback.createCoordinateSystem(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        try {
            return super.createCartesianCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCartesianCS", exception);
            try {
                return this.fallback.createCartesianCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        try {
            return super.createPolarCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createPolarCS", exception);
            try {
                return this.fallback.createPolarCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        try {
            return super.createCylindricalCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCylindricalCS", exception);
            try {
                return this.fallback.createCylindricalCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        try {
            return super.createSphericalCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createSphericalCS", exception);
            try {
                return this.fallback.createSphericalCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        try {
            return super.createEllipsoidalCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createEllipsoidalCS", exception);
            try {
                return this.fallback.createEllipsoidalCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        try {
            return super.createVerticalCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createVerticalCS", exception);
            try {
                return this.fallback.createVerticalCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        try {
            return super.createTimeCS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createTimeCS", exception);
            try {
                return this.fallback.createTimeCS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        try {
            return super.createCoordinateSystemAxis(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateSystemAxis", exception);
            try {
                return this.fallback.createCoordinateSystemAxis(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public Unit<?> createUnit(String code) throws FactoryException {
        try {
            return super.createUnit(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createUnit", exception);
            try {
                return this.fallback.createUnit(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        try {
            return super.createCoordinateReferenceSystem(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateReferenceSystem", exception);
            try {
                return this.fallback.createCoordinateReferenceSystem(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        try {
            return super.createCompoundCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCompoundCRS", exception);
            try {
                return this.fallback.createCompoundCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        try {
            return super.createDerivedCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createDerivedCRS", exception);
            try {
                return this.fallback.createDerivedCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        try {
            return super.createEngineeringCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createEngineeringCRS", exception);
            try {
                return this.fallback.createEngineeringCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        try {
            return super.createGeographicCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createGeographicCRS", exception);
            try {
                return this.fallback.createGeographicCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        try {
            return super.createGeocentricCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createGeocentricCRS", exception);
            try {
                return this.fallback.createGeocentricCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public ImageCRS createImageCRS(String code) throws FactoryException {
        try {
            return super.createImageCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createImageCRS", exception);
            try {
                return this.fallback.createImageCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        try {
            return super.createProjectedCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createProjectedCRS", exception);
            try {
                return this.fallback.createProjectedCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        try {
            return super.createTemporalCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createTemporalCRS", exception);
            try {
                return this.fallback.createTemporalCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        try {
            return super.createVerticalCRS(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createVerticalCRS", exception);
            try {
                return this.fallback.createVerticalCRS(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        try {
            return super.createParameterDescriptor(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createParameterDescriptor", exception);
            try {
                return this.fallback.createParameterDescriptor(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public OperationMethod createOperationMethod(String code) throws FactoryException {
        try {
            return super.createOperationMethod(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createOperationMethod", exception);
            try {
                return this.fallback.createOperationMethod(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        try {
            return super.createCoordinateOperation(code);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createCoordinateOperation", exception);
            try {
                return this.fallback.createCoordinateOperation(code);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws FactoryException {
        try {
            return super.createFromCoordinateReferenceSystemCodes(sourceCRS, targetCRS);
        }
        catch (FactoryException exception) {
            FallbackAuthorityFactory.notifyFailure("createFromCoordinateReferenceSystemCodes", exception);
            try {
                return this.fallback.createFromCoordinateReferenceSystemCodes(sourceCRS, targetCRS);
            }
            catch (NoSuchAuthorityCodeException ignore) {
                throw exception;
            }
        }
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new Finder(type);
    }

    private static void notifyFailure(String method, FactoryException exception) {
        ++failureCount;
        if (LOGGER.isLoggable(Level.FINE)) {
            LogRecord record = Loggings.format(Level.FINE, 22, exception);
            record.setSourceClassName(FallbackAuthorityFactory.class.getName());
            record.setSourceMethodName(method);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
    }

    @Override
    protected void notifySuccess(String method, String code, CRSAuthorityFactory factory, CoordinateReferenceSystem crs) {
    }

    static int getFailureCount() {
        return failureCount;
    }

    private static int interfaceMask(Collection<? extends AuthorityFactory> factories) {
        int mask = 0;
        for (AuthorityFactory authorityFactory : factories) {
            mask |= FallbackAuthorityFactory.interfaceMask(authorityFactory);
        }
        return mask;
    }

    private static int interfaceMask(AuthorityFactory factory) {
        return FallbackAuthorityFactory.interfaceMask(factory.getClass());
    }

    private static int interfaceMask(Class<? extends AuthorityFactory> type) {
        int mask = 0;
        if (CoordinateOperationAuthorityFactory.class.isAssignableFrom(type)) {
            mask |= 1;
        }
        if (CSAuthorityFactory.class.isAssignableFrom(type)) {
            mask |= 2;
        }
        if (DatumAuthorityFactory.class.isAssignableFrom(type)) {
            mask |= 4;
        }
        if (CRSAuthorityFactory.class.isAssignableFrom(type)) {
            mask |= 8;
        }
        return mask;
    }

    private static AuthorityFactory create(int mask, AuthorityFactory primary, AuthorityFactory fallback) {
        assert ((mask & ~(FallbackAuthorityFactory.interfaceMask(primary) | FallbackAuthorityFactory.interfaceMask(fallback))) == 0) : mask;
        FallbackAuthorityFactory factory = switch (mask) {
            case 15 -> new All(primary, fallback);
            case 14 -> new CRS_Datum_CS(primary, fallback);
            case 8, 9, 10, 11, 12, 13 -> new CRS(primary, fallback);
            case 4, 5, 6, 7 -> new Datum(primary, fallback);
            case 2, 3 -> new CS(primary, fallback);
            case 1 -> new Operation(primary, fallback);
            case 0 -> new FallbackAuthorityFactory(primary, fallback);
            default -> throw new AssertionError(mask);
        };
        assert ((FallbackAuthorityFactory.interfaceMask(factory) & ~mask) == 0) : mask;
        return factory;
    }

    private final class Finder
    extends AuthorityFactoryAdapter.Finder {
        private transient IdentifiedObjectFinder fallback;

        Finder(Class<? extends IdentifiedObject> type) throws FactoryException {
            super(FallbackAuthorityFactory.this, type);
        }

        private void ensureFallback() throws FactoryException {
            if (this.fallback == null) {
                this.fallback = FallbackAuthorityFactory.this.fallback.getIdentifiedObjectFinder(this.getProxy().getType());
            }
            this.fallback.setFullScanAllowed(this.isFullScanAllowed());
        }

        @Override
        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = this.finder.find(object);
            if (candidate != null) {
                return candidate;
            }
            this.ensureFallback();
            candidate = this.fallback.find(object);
            return candidate;
        }

        @Override
        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            String candidate = this.finder.findIdentifier(object);
            if (candidate != null) {
                return candidate;
            }
            this.ensureFallback();
            candidate = this.fallback.findIdentifier(object);
            return candidate;
        }
    }

    private static final class All
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory,
    CSAuthorityFactory,
    DatumAuthorityFactory,
    CoordinateOperationAuthorityFactory {
        All(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class CRS_Datum_CS
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory,
    CSAuthorityFactory,
    DatumAuthorityFactory {
        CRS_Datum_CS(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class CRS
    extends FallbackAuthorityFactory
    implements CRSAuthorityFactory {
        CRS(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class Datum
    extends FallbackAuthorityFactory
    implements DatumAuthorityFactory {
        Datum(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class CS
    extends FallbackAuthorityFactory
    implements CSAuthorityFactory {
        CS(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }

    private static final class Operation
    extends FallbackAuthorityFactory
    implements CoordinateOperationAuthorityFactory {
        Operation(AuthorityFactory primary, AuthorityFactory fallback) {
            super(primary, fallback);
        }
    }
}

