/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.awt.RenderingHints;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.Unit;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.metadata.extent.Extent;
import org.geotools.api.parameter.ParameterDescriptor;
import org.geotools.api.referencing.AuthorityFactory;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.NoSuchAuthorityCodeException;
import org.geotools.api.referencing.crs.CRSAuthorityFactory;
import org.geotools.api.referencing.crs.CompoundCRS;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.DerivedCRS;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.crs.GeocentricCRS;
import org.geotools.api.referencing.crs.GeographicCRS;
import org.geotools.api.referencing.crs.ImageCRS;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.crs.TemporalCRS;
import org.geotools.api.referencing.crs.VerticalCRS;
import org.geotools.api.referencing.cs.CSAuthorityFactory;
import org.geotools.api.referencing.cs.CartesianCS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.cs.CoordinateSystemAxis;
import org.geotools.api.referencing.cs.CylindricalCS;
import org.geotools.api.referencing.cs.EllipsoidalCS;
import org.geotools.api.referencing.cs.PolarCS;
import org.geotools.api.referencing.cs.SphericalCS;
import org.geotools.api.referencing.cs.TimeCS;
import org.geotools.api.referencing.cs.VerticalCS;
import org.geotools.api.referencing.datum.Datum;
import org.geotools.api.referencing.datum.DatumAuthorityFactory;
import org.geotools.api.referencing.datum.Ellipsoid;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.api.referencing.datum.GeodeticDatum;
import org.geotools.api.referencing.datum.ImageDatum;
import org.geotools.api.referencing.datum.PrimeMeridian;
import org.geotools.api.referencing.datum.TemporalDatum;
import org.geotools.api.referencing.datum.VerticalDatum;
import org.geotools.api.referencing.operation.CoordinateOperation;
import org.geotools.api.referencing.operation.CoordinateOperationAuthorityFactory;
import org.geotools.api.referencing.operation.CoordinateOperationFactory;
import org.geotools.api.referencing.operation.OperationMethod;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DirectAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.util.factory.AbstractFactory;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.Hints;
import org.geotools.util.factory.OptionalFactory;

public class AuthorityFactoryAdapter
extends AbstractAuthorityFactory
implements OptionalFactory {
    private static final Hints.Key[] TYPES = new Hints.Key[]{Hints.CRS_AUTHORITY_FACTORY, Hints.CS_AUTHORITY_FACTORY, Hints.DATUM_AUTHORITY_FACTORY, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY};
    final DatumAuthorityFactory datumFactory;
    final CSAuthorityFactory csFactory;
    final CRSAuthorityFactory crsFactory;
    final CoordinateOperationAuthorityFactory operationFactory;
    private transient ReferencingFactoryContainer factories;

    AuthorityFactoryAdapter(int priority) {
        super(priority);
        this.datumFactory = null;
        this.csFactory = null;
        this.crsFactory = null;
        this.operationFactory = null;
    }

    protected AuthorityFactoryAdapter(AuthorityFactory factory) {
        this(factory, null);
    }

    AuthorityFactoryAdapter(AuthorityFactory factory, AuthorityFactory fallback) {
        this(factory instanceof CRSAuthorityFactory ? (crsaf2 = (CRSAuthorityFactory)factory) : (fallback instanceof CRSAuthorityFactory ? (crsaf = (CRSAuthorityFactory)fallback) : null), factory instanceof CSAuthorityFactory ? (csaf2 = (CSAuthorityFactory)factory) : (fallback instanceof CSAuthorityFactory ? (csaf = (CSAuthorityFactory)fallback) : null), factory instanceof DatumAuthorityFactory ? (daf2 = (DatumAuthorityFactory)factory) : (fallback instanceof DatumAuthorityFactory ? (daf = (DatumAuthorityFactory)fallback) : null), factory instanceof CoordinateOperationAuthorityFactory ? (coaf2 = (CoordinateOperationAuthorityFactory)factory) : (fallback instanceof CoordinateOperationAuthorityFactory ? (coaf = (CoordinateOperationAuthorityFactory)fallback) : null));
        CoordinateOperationAuthorityFactory coaf;
        CoordinateOperationAuthorityFactory coaf2;
        DatumAuthorityFactory daf;
        DatumAuthorityFactory daf2;
        CSAuthorityFactory csaf;
        CSAuthorityFactory csaf2;
        CRSAuthorityFactory crsaf;
        CRSAuthorityFactory crsaf2;
    }

    protected AuthorityFactoryAdapter(CRSAuthorityFactory crsFactory, CSAuthorityFactory csFactory, DatumAuthorityFactory datumFactory, CoordinateOperationAuthorityFactory opFactory) {
        super(Math.max(AuthorityFactoryAdapter.getPriority(datumFactory), Math.max(AuthorityFactoryAdapter.getPriority(csFactory), Math.max(AuthorityFactoryAdapter.getPriority(crsFactory), AuthorityFactoryAdapter.getPriority(opFactory)))));
        if (this instanceof CRSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("crsFactory", crsFactory);
        }
        if (this instanceof CSAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("csFactory", csFactory);
        }
        if (this instanceof DatumAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("datumFactory", datumFactory);
        }
        if (this instanceof CoordinateOperationAuthorityFactory) {
            AuthorityFactoryAdapter.ensureNonNull("opFactory", opFactory);
        }
        this.datumFactory = datumFactory;
        this.store(Hints.DATUM_AUTHORITY_FACTORY, this.datumFactory);
        this.csFactory = csFactory;
        this.store(Hints.CS_AUTHORITY_FACTORY, this.csFactory);
        this.crsFactory = crsFactory;
        this.store(Hints.CRS_AUTHORITY_FACTORY, this.crsFactory);
        this.operationFactory = opFactory;
        this.store(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY, this.operationFactory);
    }

    private static int getPriority(AuthorityFactory factory) {
        int n;
        if (factory instanceof AbstractFactory) {
            AbstractFactory af = (AbstractFactory)((Object)factory);
            n = af.getPriority();
        } else {
            n = 50;
        }
        return n;
    }

    private void store(Hints.Key key, AuthorityFactory factory) {
        if (factory != null && this.hints.put(key, factory) != null) {
            throw new AssertionError(key);
        }
    }

    protected AuthorityFactoryAdapter(String authority, Hints userHints) throws FactoryRegistryException {
        this(ReferencingFactoryFinder.getCRSAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, Hints.CRS_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getCSAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, Hints.CS_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getDatumAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, Hints.DATUM_AUTHORITY_FACTORY)), ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(authority, AuthorityFactoryAdapter.trim(userHints, Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY)));
    }

    private static Hints trim(Hints userHints, Hints.Key keep) {
        Hints reduced = userHints;
        if (userHints != null) {
            for (Hints.Key key : TYPES) {
                if (keep.equals(key)) continue;
                if (reduced == userHints) {
                    if (!userHints.containsKey(key)) continue;
                    reduced = new Hints(userHints);
                }
                reduced.remove(key);
            }
        }
        return reduced;
    }

    private Hints hints() {
        Hints extended = new Hints(this.hints);
        if (this.operationFactory != null) {
            AuthorityFactoryAdapter.addAll(this.operationFactory, extended);
        }
        if (this.datumFactory != null) {
            AuthorityFactoryAdapter.addAll(this.datumFactory, extended);
        }
        if (this.csFactory != null) {
            AuthorityFactoryAdapter.addAll(this.csFactory, extended);
        }
        if (this.crsFactory != null) {
            AuthorityFactoryAdapter.addAll(this.crsFactory, extended);
        }
        extended.putAll((Map<?, ?>)this.hints);
        return extended;
    }

    private static void addAll(AuthorityFactory factory, Hints hints) {
        if (factory instanceof Factory) {
            Factory factory1 = (Factory)((Object)factory);
            hints.putAll(factory1.getImplementationHints());
        }
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        Object factory;
        ArrayList<Object> dep = new ArrayList<Object>(4);
        try {
            factory = this.getAuthorityFactory(null);
        }
        catch (FactoryException e) {
            factory = e;
        }
        dep.add(factory);
        return dep;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory factory) {
        if (!this.isCodeMethodOverriden() && AuthorityFactoryAdapter.sameAuthorityCodes(this.crsFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.csFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.datumFactory, factory) && AuthorityFactoryAdapter.sameAuthorityCodes(this.operationFactory, factory)) {
            return true;
        }
        return super.sameAuthorityCodes(factory);
    }

    static boolean sameAuthorityCodes(AuthorityFactory backingStore, AuthorityFactory factory) {
        AbstractAuthorityFactory authorityFactory;
        if (backingStore instanceof AbstractAuthorityFactory && (authorityFactory = (AbstractAuthorityFactory)backingStore).sameAuthorityCodes(factory)) {
            return true;
        }
        return factory == backingStore || backingStore == null;
    }

    @Override
    public boolean isAvailable() {
        return AuthorityFactoryAdapter.isAvailable(this.crsFactory) && AuthorityFactoryAdapter.isAvailable(this.csFactory) && AuthorityFactoryAdapter.isAvailable(this.datumFactory) && AuthorityFactoryAdapter.isAvailable(this.operationFactory);
    }

    private static boolean isAvailable(AuthorityFactory factory) {
        return !(factory instanceof OptionalFactory) || ((OptionalFactory)((Object)factory)).isAvailable();
    }

    Unit<?> replace(Unit<?> units) throws FactoryException {
        return units;
    }

    CoordinateSystemAxis replace(CoordinateSystemAxis axis) throws FactoryException {
        return axis;
    }

    CoordinateSystem replace(CoordinateSystem cs) throws FactoryException {
        return cs;
    }

    Datum replace(Datum datum) throws FactoryException {
        return datum;
    }

    CoordinateReferenceSystem replace(CoordinateReferenceSystem crs) throws FactoryException {
        return crs;
    }

    CoordinateOperation replace(CoordinateOperation operation) throws FactoryException {
        return operation;
    }

    private IdentifiedObject replaceObject(IdentifiedObject object) throws FactoryException {
        if (object instanceof CoordinateReferenceSystem) {
            CoordinateReferenceSystem system = (CoordinateReferenceSystem)object;
            return this.replace(system);
        }
        if (object instanceof CoordinateSystem) {
            CoordinateSystem system = (CoordinateSystem)object;
            return this.replace(system);
        }
        if (object instanceof CoordinateSystemAxis) {
            CoordinateSystemAxis axis = (CoordinateSystemAxis)object;
            return this.replace(axis);
        }
        if (object instanceof Datum) {
            Datum datum = (Datum)object;
            return this.replace(datum);
        }
        if (object instanceof CoordinateOperation) {
            CoordinateOperation operation = (CoordinateOperation)object;
            return this.replace(operation);
        }
        return object;
    }

    private AbstractAuthorityFactory getGeotoolsFactory(String caller, String code) throws FactoryException {
        AuthorityFactory candidate = this.getAuthorityFactory(code);
        if (candidate instanceof AbstractAuthorityFactory) {
            AbstractAuthorityFactory factory = (AbstractAuthorityFactory)candidate;
            return factory;
        }
        if (caller == null) {
            return null;
        }
        throw new FactoryException(MessageFormat.format("Geotools extension required for \"{0}\" operation.", caller));
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        AbstractAuthorityFactory factory = this.getGeotoolsFactory(null, null);
        return factory != null ? factory.getBackingStoreDescription() : null;
    }

    @Override
    public Citation getVendor() {
        return this.getAuthorityFactory().getVendor();
    }

    @Override
    public Citation getAuthority() {
        return this.getAuthorityFactory().getAuthority();
    }

    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        return this.getAuthorityFactory(null).getAuthorityCodes(type);
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        return this.getAuthorityFactory(code).getDescriptionText(this.toBackingFactoryCode(code));
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        return this.replaceObject(this.getAuthorityFactory(code).createObject(this.toBackingFactoryCode(code)));
    }

    @Override
    public Datum createDatum(String code) throws FactoryException {
        return this.replace(this.getDatumAuthorityFactory(code).createDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public EngineeringDatum createEngineeringDatum(String code) throws FactoryException {
        return (EngineeringDatum)this.replace(this.getDatumAuthorityFactory(code).createEngineeringDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public ImageDatum createImageDatum(String code) throws FactoryException {
        return (ImageDatum)this.replace(this.getDatumAuthorityFactory(code).createImageDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public VerticalDatum createVerticalDatum(String code) throws FactoryException {
        return (VerticalDatum)this.replace(this.getDatumAuthorityFactory(code).createVerticalDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public TemporalDatum createTemporalDatum(String code) throws FactoryException {
        return (TemporalDatum)this.replace(this.getDatumAuthorityFactory(code).createTemporalDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public GeodeticDatum createGeodeticDatum(String code) throws FactoryException {
        return (GeodeticDatum)this.replace(this.getDatumAuthorityFactory(code).createGeodeticDatum(this.toBackingFactoryCode(code)));
    }

    @Override
    public Ellipsoid createEllipsoid(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createEllipsoid(this.toBackingFactoryCode(code));
    }

    @Override
    public PrimeMeridian createPrimeMeridian(String code) throws FactoryException {
        return this.getDatumAuthorityFactory(code).createPrimeMeridian(this.toBackingFactoryCode(code));
    }

    @Override
    public Extent createExtent(String code) throws FactoryException {
        return this.getGeotoolsFactory("createExtent", code).createExtent(this.toBackingFactoryCode(code));
    }

    @Override
    public CoordinateSystem createCoordinateSystem(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createCoordinateSystem(this.toBackingFactoryCode(code)));
    }

    @Override
    public CartesianCS createCartesianCS(String code) throws FactoryException {
        return (CartesianCS)this.replace(this.getCSAuthorityFactory(code).createCartesianCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public PolarCS createPolarCS(String code) throws FactoryException {
        return (PolarCS)this.replace(this.getCSAuthorityFactory(code).createPolarCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public CylindricalCS createCylindricalCS(String code) throws FactoryException {
        return (CylindricalCS)this.replace(this.getCSAuthorityFactory(code).createCylindricalCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public SphericalCS createSphericalCS(String code) throws FactoryException {
        return (SphericalCS)this.replace(this.getCSAuthorityFactory(code).createSphericalCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public EllipsoidalCS createEllipsoidalCS(String code) throws FactoryException {
        return (EllipsoidalCS)this.replace(this.getCSAuthorityFactory(code).createEllipsoidalCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public VerticalCS createVerticalCS(String code) throws FactoryException {
        return (VerticalCS)this.replace(this.getCSAuthorityFactory(code).createVerticalCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public TimeCS createTimeCS(String code) throws FactoryException {
        return (TimeCS)this.replace(this.getCSAuthorityFactory(code).createTimeCS(this.toBackingFactoryCode(code)));
    }

    @Override
    public CoordinateSystemAxis createCoordinateSystemAxis(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createCoordinateSystemAxis(this.toBackingFactoryCode(code)));
    }

    @Override
    public Unit<?> createUnit(String code) throws FactoryException {
        return this.replace(this.getCSAuthorityFactory(code).createUnit(this.toBackingFactoryCode(code)));
    }

    @Override
    public CoordinateReferenceSystem createCoordinateReferenceSystem(String code) throws FactoryException {
        CRSAuthorityFactory factory = this.getCRSAuthorityFactory(code);
        CoordinateReferenceSystem crs = this.replace(factory.createCoordinateReferenceSystem(this.toBackingFactoryCode(code)));
        this.notifySuccess("createCoordinateReferenceSystem", code, factory, crs);
        return crs;
    }

    @Override
    public CompoundCRS createCompoundCRS(String code) throws FactoryException {
        return (CompoundCRS)this.replace(this.getCRSAuthorityFactory(code).createCompoundCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public DerivedCRS createDerivedCRS(String code) throws FactoryException {
        return (DerivedCRS)this.replace(this.getCRSAuthorityFactory(code).createDerivedCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public EngineeringCRS createEngineeringCRS(String code) throws FactoryException {
        return (EngineeringCRS)this.replace(this.getCRSAuthorityFactory(code).createEngineeringCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public GeographicCRS createGeographicCRS(String code) throws FactoryException {
        return (GeographicCRS)this.replace(this.getCRSAuthorityFactory(code).createGeographicCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public GeocentricCRS createGeocentricCRS(String code) throws FactoryException {
        return (GeocentricCRS)this.replace(this.getCRSAuthorityFactory(code).createGeocentricCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public ImageCRS createImageCRS(String code) throws FactoryException {
        return (ImageCRS)this.replace(this.getCRSAuthorityFactory(code).createImageCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public ProjectedCRS createProjectedCRS(String code) throws FactoryException {
        return (ProjectedCRS)this.replace(this.getCRSAuthorityFactory(code).createProjectedCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public TemporalCRS createTemporalCRS(String code) throws FactoryException {
        return (TemporalCRS)this.replace(this.getCRSAuthorityFactory(code).createTemporalCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public VerticalCRS createVerticalCRS(String code) throws FactoryException {
        return (VerticalCRS)this.replace(this.getCRSAuthorityFactory(code).createVerticalCRS(this.toBackingFactoryCode(code)));
    }

    @Override
    public ParameterDescriptor createParameterDescriptor(String code) throws FactoryException {
        return this.getGeotoolsFactory("createParameterDescriptor", code).createParameterDescriptor(this.toBackingFactoryCode(code));
    }

    @Override
    public OperationMethod createOperationMethod(String code) throws FactoryException {
        return this.getGeotoolsFactory("createOperationMethod", code).createOperationMethod(this.toBackingFactoryCode(code));
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws FactoryException {
        return this.replace(this.getCoordinateOperationAuthorityFactory(code).createCoordinateOperation(this.toBackingFactoryCode(code)));
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws FactoryException {
        CoordinateOperationAuthorityFactory check;
        CoordinateOperationAuthorityFactory factory = this.getCoordinateOperationAuthorityFactory(sourceCRS);
        if (factory != (check = this.getCoordinateOperationAuthorityFactory(targetCRS))) {
            LogRecord record = Loggings.format(Level.WARNING, 29, sourceCRS, targetCRS);
            record.setSourceMethodName("createFromCoordinateReferenceSystemCodes");
            record.setSourceClassName(AuthorityFactoryAdapter.class.getName());
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
            return Collections.emptySet();
        }
        return factory.createFromCoordinateReferenceSystemCodes(this.toBackingFactoryCode(sourceCRS), this.toBackingFactoryCode(targetCRS));
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new Finder(type);
    }

    protected void notifySuccess(String method, String code, CRSAuthorityFactory factory, CoordinateReferenceSystem crs) {
        if (crs != null && LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("CRS for code:%s found by factory:%s".formatted(code, factory.getClass().getName()));
        }
    }

    private FactoryException missingFactory(Class category, String code) {
        return new NoSuchAuthorityCodeException(MessageFormat.format("No factory of kind \"{0}\" found.", category), Citations.getIdentifier(this.getAuthority()), this.trimAuthority(code));
    }

    private AuthorityFactory getAuthorityFactory() {
        try {
            return this.getAuthorityFactory(null);
        }
        catch (FactoryException cause) {
            throw new IllegalStateException("Undefined property.", cause);
        }
    }

    <T extends AuthorityFactory> T getAuthorityFactory(Class<T> type, String code) throws FactoryException {
        AuthorityFactory f;
        if (CRSAuthorityFactory.class.equals(type)) {
            f = this.getCRSAuthorityFactory(code);
        } else if (CSAuthorityFactory.class.equals(type)) {
            f = this.getCSAuthorityFactory(code);
        } else if (DatumAuthorityFactory.class.equals(type)) {
            f = this.getDatumAuthorityFactory(code);
        } else if (CoordinateOperationAuthorityFactory.class.equals(type)) {
            f = this.getCoordinateOperationAuthorityFactory(code);
        } else {
            throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "type", type));
        }
        return (T)((AuthorityFactory)type.cast(f));
    }

    protected AuthorityFactory getAuthorityFactory(String code) throws FactoryException {
        if (this.crsFactory != null) {
            return this.crsFactory;
        }
        if (this.csFactory != null) {
            return this.csFactory;
        }
        if (this.datumFactory != null) {
            return this.datumFactory;
        }
        if (this.operationFactory != null) {
            return this.operationFactory;
        }
        throw this.missingFactory(AuthorityFactory.class, code);
    }

    protected DatumAuthorityFactory getDatumAuthorityFactory(String code) throws FactoryException {
        if (this.datumFactory == null) {
            throw this.missingFactory(DatumAuthorityFactory.class, code);
        }
        return this.datumFactory;
    }

    protected CSAuthorityFactory getCSAuthorityFactory(String code) throws FactoryException {
        if (this.csFactory == null) {
            throw this.missingFactory(CSAuthorityFactory.class, code);
        }
        return this.csFactory;
    }

    protected CRSAuthorityFactory getCRSAuthorityFactory(String code) throws FactoryException {
        if (this.crsFactory == null) {
            throw this.missingFactory(CRSAuthorityFactory.class, code);
        }
        return this.crsFactory;
    }

    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String code) throws FactoryException {
        if (this.operationFactory == null) {
            throw this.missingFactory(CoordinateOperationAuthorityFactory.class, code);
        }
        return this.operationFactory;
    }

    final CoordinateOperationFactory getCoordinateOperationFactory() throws FactoryException {
        Factory factory;
        Map<RenderingHints.Key, ?> hints;
        Object candidate;
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.operationFactory;
        if (coordinateOperationAuthorityFactory instanceof Factory && (candidate = (hints = (factory = (Factory)((Object)coordinateOperationAuthorityFactory)).getImplementationHints()).get(Hints.COORDINATE_OPERATION_FACTORY)) instanceof CoordinateOperationFactory) {
            CoordinateOperationFactory coordinateOperationFactory = (CoordinateOperationFactory)candidate;
            return coordinateOperationFactory;
        }
        return ReferencingFactoryFinder.getCoordinateOperationFactory(this.hints());
    }

    final ReferencingFactoryContainer getFactoryContainer(boolean crs) {
        AuthorityFactory factory = crs ? this.crsFactory : this.csFactory;
        if (factory instanceof DirectAuthorityFactory) {
            DirectAuthorityFactory authorityFactory = (DirectAuthorityFactory)factory;
            return authorityFactory.factories;
        }
        if (this.factories == null) {
            this.factories = ReferencingFactoryContainer.instance(this.hints());
        }
        return this.factories;
    }

    protected String toBackingFactoryCode(String code) throws FactoryException {
        return code;
    }

    final boolean isCodeMethodOverriden() {
        Class[] arguments = new Class[]{String.class};
        Class<?> type = this.getClass();
        while (!AuthorityFactoryAdapter.class.equals(type)) {
            block4: {
                try {
                    type.getDeclaredMethod("toBackingFactoryCode", arguments);
                }
                catch (NoSuchMethodException e) {
                    break block4;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    @Override
    public void dispose() throws FactoryException {
        super.dispose();
        this.disposeAbstractAuthorityFactory(this.datumFactory);
        this.disposeAbstractAuthorityFactory(this.csFactory);
        this.disposeAbstractAuthorityFactory(this.crsFactory);
        this.disposeAbstractAuthorityFactory(this.operationFactory);
    }

    private void disposeAbstractAuthorityFactory(Object factory) throws FactoryException {
        if (factory instanceof AbstractAuthorityFactory) {
            AbstractAuthorityFactory authorityFactory = (AbstractAuthorityFactory)factory;
            authorityFactory.dispose();
        }
    }

    class Finder
    extends IdentifiedObjectFinder.Adapter {
        protected Finder(Class<? extends IdentifiedObject> type) throws FactoryException {
            super(AuthorityFactoryAdapter.this.getGeotoolsFactory("getIdentifiedObjectFinder", null).getIdentifiedObjectFinder(type));
        }

        @Override
        protected IdentifiedObject deriveEquivalent(IdentifiedObject candidate, IdentifiedObject model) throws FactoryException {
            IdentifiedObject modified = AuthorityFactoryAdapter.this.replaceObject(candidate);
            if (modified != candidate && CRS.equalsIgnoreMetadata(modified, model)) {
                return modified;
            }
            return super.deriveEquivalent(candidate, model);
        }
    }
}

