/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.Collections;
import java.util.Map;
import org.geotools.api.referencing.crs.EngineeringCRS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.referencing.datum.EngineeringDatum;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractSingleCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.datum.DefaultEngineeringDatum;
import org.geotools.referencing.wkt.Formatter;

public class DefaultEngineeringCRS
extends AbstractSingleCRS
implements EngineeringCRS {
    private static final long serialVersionUID = 6695541732063382701L;
    protected boolean wildcard;
    public static final DefaultEngineeringCRS CARTESIAN_2D = new DefaultEngineeringCRS(15, DefaultCartesianCS.GENERIC_2D, false);
    public static final DefaultEngineeringCRS CARTESIAN_3D = new DefaultEngineeringCRS(16, DefaultCartesianCS.GENERIC_3D, false);
    public static final DefaultEngineeringCRS GENERIC_2D = new DefaultEngineeringCRS(75, DefaultCartesianCS.GENERIC_2D, true);
    public static final DefaultEngineeringCRS GENERIC_3D = new DefaultEngineeringCRS(76, DefaultCartesianCS.GENERIC_3D, true);

    DefaultEngineeringCRS(int key, CoordinateSystem cs, boolean wildcard) {
        this(DefaultEngineeringCRS.name(key), (EngineeringDatum)DefaultEngineeringDatum.UNKNOWN, cs);
        this.wildcard = wildcard;
    }

    public DefaultEngineeringCRS(EngineeringCRS crs) {
        super(crs);
        if (crs instanceof DefaultEngineeringCRS) {
            DefaultEngineeringCRS rS = (DefaultEngineeringCRS)crs;
            this.wildcard = rS.wildcard;
        }
    }

    public DefaultEngineeringCRS(String name, EngineeringDatum datum, CoordinateSystem cs) {
        this(Collections.singletonMap("name", name), datum, cs);
    }

    public DefaultEngineeringCRS(Map<String, ?> properties, EngineeringDatum datum, CoordinateSystem cs) {
        super(properties, datum, cs);
    }

    public DefaultEngineeringCRS(Map<String, ?> properties, EngineeringDatum datum, CoordinateSystem cs, boolean wildcard) {
        super(properties, datum, cs);
        this.wildcard = wildcard;
    }

    @Override
    public EngineeringDatum getDatum() {
        return (EngineeringDatum)super.getDatum();
    }

    @Override
    public int calculateHashCode() {
        return 0x16710CAD ^ super.calculateHashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        this.formatDefaultWKT(formatter);
        return "LOCAL_CS";
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            if (compareMetadata) {
                return true;
            }
            DefaultEngineeringCRS that = (DefaultEngineeringCRS)object;
            return this.wildcard == that.wildcard;
        }
        return false;
    }

    public boolean isWildcard() {
        return this.wildcard;
    }
}

