/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.crs;

import java.util.HashMap;
import java.util.Map;
import javax.measure.Unit;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.api.util.InternationalString;
import org.geotools.measure.Measure;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.AbstractReferenceSystem;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.util.CRSUtilities;
import org.geotools.referencing.wkt.Formatter;
import org.geotools.util.UnsupportedImplementationException;

public abstract class AbstractCRS
extends AbstractReferenceSystem
implements CoordinateReferenceSystem {
    private static final long serialVersionUID = -7433284548909530047L;
    protected final CoordinateSystem coordinateSystem;
    private volatile int hashCode;

    public AbstractCRS(CoordinateReferenceSystem crs) {
        super(crs);
        this.coordinateSystem = crs.getCoordinateSystem();
    }

    public AbstractCRS(Map<String, ?> properties, CoordinateSystem cs) {
        super(properties);
        AbstractCRS.ensureNonNull("cs", cs);
        this.coordinateSystem = cs;
    }

    static Map<String, ?> name(int key) {
        HashMap<String, CharSequence> properties = new HashMap<String, CharSequence>(4);
        InternationalString name = Vocabulary.formatInternational(key);
        properties.put("name", name.toString());
        properties.put("alias", name);
        return properties;
    }

    @Override
    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    final Unit<?> getUnit() {
        return CRSUtilities.getUnit(this.coordinateSystem);
    }

    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        CoordinateSystem coordinateSystem = this.coordinateSystem;
        if (coordinateSystem instanceof AbstractCS) {
            AbstractCS cS = (AbstractCS)coordinateSystem;
            return cS.distance(coord1, coord2);
        }
        throw new UnsupportedImplementationException(this.coordinateSystem.getClass());
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractCRS that = (AbstractCRS)object;
            return AbstractCRS.equals(this.coordinateSystem, that.coordinateSystem, compareMetadata);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = this.calculateHashCode();
        }
        return result;
    }

    protected int calculateHashCode() {
        return 0x3D90441 ^ this.coordinateSystem.hashCode();
    }

    @Override
    protected String formatWKT(Formatter formatter) {
        this.formatDefaultWKT(formatter);
        return super.formatWKT(formatter);
    }

    void formatDefaultWKT(Formatter formatter) {
        Unit<?> unit = this.getUnit();
        formatter.append(unit);
        int dimension = this.coordinateSystem.getDimension();
        for (int i = 0; i < dimension; ++i) {
            formatter.append(this.coordinateSystem.getAxis(i));
        }
        if (unit == null) {
            formatter.setInvalidWKT(CoordinateReferenceSystem.class);
        }
    }
}

