/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.nature;

public final class SeaWater {
    public static final double STANDARD_CONDUCTIVITY = 42.914;
    private static final double[] EOS80_A = new double[]{-28.263737, 0.06793952, -0.00909529, 1.001685E-4, -1.120083E-6, 6.536332E-9};
    private static final double[] EOS80_B = new double[]{0.824493, -0.0040899, 7.6438E-5, -8.2467E-7, 5.3875E-9};
    private static final double[] EOS80_C = new double[]{-0.00572466, 1.0227E-4, -1.6546E-6};
    private static final double EOS80_D = 4.8314E-4;
    private static final double[] EOS80_E = new double[]{-1930.06, 148.4206, -2.327105, 0.01360477, -5.155288E-5};
    private static final double[] EOS80_F = new double[]{54.6746, -0.603459, 0.0109987, -6.167E-5};
    private static final double[] EOS80_G = new double[]{0.07944, 0.016483, -5.3009E-4};
    private static final double[] EOS80_H = new double[]{-0.1194975, 0.00143713, 1.16092E-4, -5.77905E-7};
    private static final double[] EOS80_I = new double[]{0.0022838, -1.0981E-5, -1.6078E-6};
    private static final double EOS80_J = 1.91075E-4;
    private static final double[] EOS80_K = new double[]{3.47718E-5, -6.12293E-6, 5.2787E-8};
    private static final double[] EOS80_M = new double[]{-9.9348E-7, 2.0816E-8, 9.1697E-10};
    private static final double[] EOS80_N = new double[]{21582.27, 3.359406, 5.03217E-5};
    private static final double RHO_35_0_0 = 1028.1063;
    private static final double DR_35_0_0 = 28.106331;
    private static final double[] EOS80_At = new double[]{999.842594, 0.06793952, -0.00909529, 1.001685E-4, -1.120083E-6, 6.536332E-9};
    private static final double[] EOS80_Et = new double[]{19652.21, 148.4206, -2.327105, 0.01360477, -5.155288E-5};
    private static final double[] EOS80_Ht = new double[]{3.239908, 0.00143713, 1.16092E-4, -5.77905E-7};
    private static final double[] EOS80_Kt = new double[]{8.50935E-5, -6.12293E-6, 5.2787E-8};
    private static final double[] PSS78_A = new double[]{0.008, -0.1692, 25.3851, 14.0941, -7.0261, 2.7081};
    private static final double[] PSS78_B = new double[]{5.0E-4, -0.0056, -0.0066, -0.0375, 0.0636, -0.0144};
    private static final double[] PSS78_C = new double[]{0.6766097, 0.0200564, 1.104259E-4, -6.9698E-7, 1.0031E-9};
    private static final double[] PSS78_D = new double[]{0.03426, 4.464E-4, 0.4215, -0.003107};
    private static final double[] PSS78_E = new double[]{2.07E-5, -6.37E-10, 3.989E-15};
    private static final double[] PSS78_G = new double[]{-0.1692, 50.7702, 42.2823, -28.1044, 13.5405};
    private static final double[] PSS78_H = new double[]{-0.0188, -0.1125, 0.2544, -0.072};
    private static final double PSS78_K = 0.0162;
    private static final double[] PSS78_AR = new double[]{7.737, -9.819, 8.663, -2.625};
    private static final double[] PSS78_AT = new double[]{0.03473, 0.003188, -4.655E-5};
    private static final double[] PSS78_CR = new double[]{-0.1001, 0.0482, -6.682E-4};
    private static final double[] HEAT_AA = new double[]{-7.643575, 0.1072763, -0.00138385};
    private static final double[] HEAT_BB = new double[]{0.1770383, -0.00407718, 5.148E-5};
    private static final double[] HEAT_CC = new double[]{4217.4, -3.720283, 0.1412855, -0.002654387, 2.093236E-5};
    private static final double[] HEAT_A = new double[]{-0.49592, 0.0145747, -3.13885E-4, 2.0357E-6, 1.7168E-8};
    private static final double[] HEAT_B = new double[]{2.4931E-4, -1.08645E-5, 2.87533E-7, -4.0027E-9, 2.2956E-11};
    private static final double[] HEAT_C = new double[]{-5.422E-8, 2.638E-9, -6.5637E-11, 6.136E-13};
    private static final double[] HEAT_D = new double[]{0.0049247, -1.28315E-4, 9.802E-7, 2.5941E-8, -2.9179E-10};
    private static final double[] HEAT_E = new double[]{-1.2331E-4, -1.517E-6, 3.122E-8};
    private static final double[] HEAT_F = new double[]{-2.9558E-6, 1.17054E-7, -2.3905E-9, 1.8448E-11};
    private static final double HEAT_G = 9.971E-8;
    private static final double[] HEAT_H = new double[]{5.54E-10, -1.7682E-11, 3.513E-13};
    private static final double HEAT_J = -1.43E-12;
    private static final double[] GRAD_A = new double[]{3.5803E-5, 8.5258E-6, -6.836E-8, 6.6228E-10};
    private static final double[] GRAD_B = new double[]{1.8932E-6, -4.2393E-8};
    private static final double[] GRAD_C = new double[]{1.8741E-8, -6.7795E-10, 8.733E-12, -5.4481E-14};
    private static final double[] GRAD_D = new double[]{-1.1351E-10, 2.7759E-12};
    private static final double[] GRAD_E = new double[]{-4.6206E-13, 1.8676E-14, -2.1687E-16};
    private static final double[] DEPTH_C = new double[]{9.72659, -2.2512E-5, 2.279E-10, -1.82E-15};
    private static final double[] SOUND_A0 = new double[]{1.389, -0.01262, 7.164E-5, 2.006E-6, -3.21E-8};
    private static final double[] SOUND_A1 = new double[]{9.4742E-5, -1.258E-5, -6.4885E-8, 1.0507E-8, -2.0122E-10};
    private static final double[] SOUND_A2 = new double[]{-3.9064E-7, 9.1041E-9, -1.6002E-10, 7.988E-12};
    private static final double[] SOUND_A3 = new double[]{1.1E-10, 6.649E-12, -3.389E-13};
    private static final double[] SOUND_B0 = new double[]{-0.01922, -4.42E-5};
    private static final double[] SOUND_B1 = new double[]{7.3637E-5, 1.7945E-7};
    private static final double[] SOUND_C0 = new double[]{1402.388, 5.03711, -0.0580852, 3.342E-4, -1.478E-6, 3.1464E-9};
    private static final double[] SOUND_C1 = new double[]{0.153563, 6.8982E-4, -8.1788E-6, 1.3621E-7, -6.1185E-10};
    private static final double[] SOUND_C2 = new double[]{3.126E-5, -1.7107E-6, 2.5974E-8, -2.5335E-10, 1.0405E-12};
    private static final double[] SOUND_C3 = new double[]{-9.7729E-9, 3.8504E-10, -2.3643E-12};
    private static final double SOUND_D0 = 0.001727;
    private static final double SOUND_D1 = -7.9836E-6;
    private static final double[] O2_AT = new double[]{-135.29996, 157228.8, -6.637149E7, 1.243678E10, -8.621061E11};
    private static final double[] O2_AS = new double[]{0.020573, -12.142, 2363.0, 1.0};

    private SeaWater() {
    }

    public static double density(double S, double T2, double P) {
        double RHO_0_T_0 = SeaWater.polynome(T2, EOS80_At);
        double SR = Math.sqrt(S);
        double RHO_S_T_0 = (4.8314E-4 * S + SeaWater.polynome(T2, EOS80_C) * SR + SeaWater.polynome(T2, EOS80_B)) * S + RHO_0_T_0;
        double K_S_T_0 = (SeaWater.polynome(T2, EOS80_F) + SeaWater.polynome(T2, EOS80_G) * SR) * S + SeaWater.polynome(T2, EOS80_Et);
        double K_S_T_P = K_S_T_0 + ((1.91075E-4 * SR + SeaWater.polynome(T2, EOS80_I)) * S + SeaWater.polynome(T2, EOS80_Ht) + (SeaWater.polynome(T2, EOS80_Kt) + SeaWater.polynome(T2, EOS80_M) * S) * (P /= 10.0)) * P;
        return RHO_S_T_0 / (1.0 - P / K_S_T_P);
    }

    public static double densitySigmaT(double S, double T2, double P) {
        P /= 10.0;
        double SR = Math.sqrt(S);
        double RHO = (4.8314E-4 * S + SeaWater.polynome(T2, EOS80_C) * SR + SeaWater.polynome(T2, EOS80_B)) * S + SeaWater.polynome(T2, EOS80_A);
        double V_35_0_0 = 9.726620681149411E-4;
        double SVAN_S_T_0 = -RHO * 9.726620681149411E-4 / (RHO + 1028.1063);
        if (P <= 0.0) {
            return RHO + 28.106331;
        }
        double K0 = (SeaWater.polynome(T2, EOS80_F) + SeaWater.polynome(T2, EOS80_G) * SR) * S + SeaWater.polynome(T2, EOS80_E);
        double DK = K0 + ((1.91075E-4 * SR + SeaWater.polynome(T2, EOS80_I)) * S + SeaWater.polynome(T2, EOS80_H) + (SeaWater.polynome(T2, EOS80_K) + SeaWater.polynome(T2, EOS80_M) * S) * P) * P;
        double K_35_0_P = SeaWater.polynome(P, EOS80_N);
        double V_S_T_0 = SVAN_S_T_0 + 9.726620681149411E-4;
        double SVANS = SVAN_S_T_0 * (1.0 - P / K_35_0_P) + V_S_T_0 * P * DK / (K_35_0_P * (K_35_0_P + DK));
        double V_35_0_P = 9.726620681149411E-4 * (1.0 - P / K_35_0_P);
        double DR_35_0_P = P / (K_35_0_P * V_35_0_P);
        double DVAN = SVANS / (V_35_0_P * (V_35_0_P + SVANS));
        return 28.106331 + DR_35_0_P - DVAN;
    }

    public static double volume(double S, double T2, double P) {
        P /= 10.0;
        double SR = Math.sqrt(S);
        double RHO = (4.8314E-4 * S + SeaWater.polynome(T2, EOS80_C) * SR + SeaWater.polynome(T2, EOS80_B)) * S + SeaWater.polynome(T2, EOS80_A);
        double V_35_0_0 = 9.726620681149411E-4;
        double SVAN_S_T_0 = -RHO * 9.726620681149411E-4 / (RHO + 1028.1063);
        if (P <= 0.0) {
            return SVAN_S_T_0 + 9.726620681149411E-4;
        }
        double K0 = (SeaWater.polynome(T2, EOS80_F) + SeaWater.polynome(T2, EOS80_G) * SR) * S + SeaWater.polynome(T2, EOS80_E);
        double DK = K0 + ((1.91075E-4 * SR + SeaWater.polynome(T2, EOS80_I)) * S + SeaWater.polynome(T2, EOS80_H) + (SeaWater.polynome(T2, EOS80_K) + SeaWater.polynome(T2, EOS80_M) * S) * P) * P;
        double K_35_0_P = SeaWater.polynome(P, EOS80_N);
        double V_S_T_0 = SVAN_S_T_0 + 9.726620681149411E-4;
        return (SVAN_S_T_0 + 9.726620681149411E-4) * (1.0 - P / K_35_0_P) + V_S_T_0 * P * DK / (K_35_0_P * (K_35_0_P + DK));
    }

    public static double volumeAnomaly(double S, double T2, double P) {
        P /= 10.0;
        double SR = Math.sqrt(S);
        double RHO = (4.8314E-4 * S + SeaWater.polynome(T2, EOS80_C) * SR + SeaWater.polynome(T2, EOS80_B)) * S + SeaWater.polynome(T2, EOS80_A);
        double V_35_0_0 = 9.726620681149411E-4;
        double SVAN_S_T_0 = -RHO * 9.726620681149411E-4 / (RHO + 1028.1063);
        if (P <= 0.0) {
            return SVAN_S_T_0;
        }
        double K0 = (SeaWater.polynome(T2, EOS80_F) + SeaWater.polynome(T2, EOS80_G) * SR) * S + SeaWater.polynome(T2, EOS80_E);
        double DK = K0 + ((1.91075E-4 * SR + SeaWater.polynome(T2, EOS80_I)) * S + SeaWater.polynome(T2, EOS80_H) + (SeaWater.polynome(T2, EOS80_K) + SeaWater.polynome(T2, EOS80_M) * S) * P) * P;
        double K_35_0_P = SeaWater.polynome(P, EOS80_N);
        double V_S_T_0 = SVAN_S_T_0 + 9.726620681149411E-4;
        return SVAN_S_T_0 * (1.0 - P / K_35_0_P) + V_S_T_0 * P * DK / (K_35_0_P * (K_35_0_P + DK));
    }

    private static double sal(double RT, double XT) {
        return SeaWater.polynome(RT, PSS78_A) + XT / (1.0 + 0.0162 * XT) * SeaWater.polynome(RT, PSS78_B);
    }

    private static double dsal(double RT, double XT) {
        return SeaWater.polynome(RT, PSS78_G) + XT / (1.0 + 0.0162 * XT) * SeaWater.polynome(RT, PSS78_H);
    }

    public static double salinity(double C, double T2, double P) {
        if (!((C /= 42.914) < 5.0E-4)) {
            double xr1 = (PSS78_D[1] * T2 + PSS78_D[0]) * T2 + 1.0 + (PSS78_D[3] * T2 + PSS78_D[2]) * C;
            double XR = Math.sqrt(C / (SeaWater.polynome(T2, PSS78_C) * (1.0 + SeaWater.polynome(P, PSS78_E) * P / xr1)));
            double S = SeaWater.sal(XR, T2 - 15.0);
            if (!(S >= 42.0)) {
                return S;
            }
            double r1 = PSS78_CR[0] + PSS78_CR[1] * C + PSS78_CR[2] * T2;
            return 35.0 * C + C * (C - 1.0) * (SeaWater.polynome(C, PSS78_AR) + T2 * (SeaWater.polynome(T2, PSS78_AT) + C * r1));
        }
        return 0.0;
    }

    public static double conductivity(double S, double T2, double P) {
        if (!(S < 0.02)) {
            double XT = T2 - 15.0;
            double RT = Math.sqrt(S / 35.0);
            double SI2 = SeaWater.sal(RT, XT);
            for (int n = 0; n < 10 && !(Math.abs((SI2 = SeaWater.sal(RT += (S - SI2) / SeaWater.dsal(RT, XT), XT)) - S) < 1.0E-4); ++n) {
            }
            double RTT = SeaWater.polynome(T2, PSS78_C) * (RT * RT);
            double AT = PSS78_D[3] * T2 + PSS78_D[2];
            double BT = (PSS78_D[1] * T2 + PSS78_D[0]) * T2 + 1.0;
            double CP = RTT * (BT + SeaWater.polynome(P, PSS78_E) * P);
            double cnd = 0.5 * (Math.sqrt(Math.abs((BT -= RTT * AT) * BT + 4.0 * AT * CP)) - BT) / AT;
            return cnd * 42.914;
        }
        return 0.0;
    }

    public static double specificHeat(double S, double T2, double P) {
        double SR = Math.sqrt(S);
        return SeaWater.polynome(T2, HEAT_CC) + (SeaWater.polynome(T2, HEAT_BB) * SR + SeaWater.polynome(T2, HEAT_AA)) * S + ((SeaWater.polynome(T2, HEAT_C) * (P /= 10.0) + SeaWater.polynome(T2, HEAT_B)) * P + SeaWater.polynome(T2, HEAT_A)) * P + (((-1.43E-12 * SR + SeaWater.polynome(T2, HEAT_H)) * S * P + (9.971E-8 * SR + SeaWater.polynome(T2, HEAT_F)) * S) * P + (SeaWater.polynome(T2, HEAT_E) * SR + SeaWater.polynome(T2, HEAT_D)) * S) * P;
    }

    public static double fusionTemperature(double S, double P) {
        return (-0.0575 + 0.001710523 * Math.sqrt(S) + -2.154996E-4 * S) * S + -7.53E-4 * P;
    }

    public static double adiabeticTemperatureGradient(double S, double T2, double P) {
        return SeaWater.polynome(T2, GRAD_A) + SeaWater.polynome(T2, GRAD_B) * (S -= 35.0) + (SeaWater.polynome(T2, GRAD_C) + SeaWater.polynome(T2, GRAD_D) * S + SeaWater.polynome(T2, GRAD_E) * P) * P;
    }

    public static double depth(double P, double lat) {
        lat = Math.sin(lat);
        lat *= lat;
        lat = 9.780318 * (1.0 + 0.0052788 * lat + 2.36E-5 * (lat * lat));
        return SeaWater.polynome(P, DEPTH_C) * P / (lat + 1.092E-6 * P);
    }

    public static double soundVelocity(double S, double T2, double P) {
        double CW = ((SeaWater.polynome(T2, SOUND_C3) * P + SeaWater.polynome(T2, SOUND_C2)) * P + SeaWater.polynome(T2, SOUND_C1)) * P + SeaWater.polynome(T2, SOUND_C0);
        double A = ((SeaWater.polynome(T2, SOUND_A3) * P + SeaWater.polynome(T2, SOUND_A2)) * P + SeaWater.polynome(T2, SOUND_A1)) * P + SeaWater.polynome(T2, SOUND_A0);
        double B = SeaWater.polynome(T2, SOUND_B0) + SeaWater.polynome(T2, SOUND_B1) * P;
        double D = 0.001727 + -7.9836E-6 * P;
        return CW + (D * S + B * Math.sqrt(S) + A) * S;
    }

    public static double saturationO2(double S, double T2) {
        return Math.exp(SeaWater.polynome_neg(T2 += 273.15, O2_AT) + S * SeaWater.polynome_neg(T2, O2_AS));
    }

    private static double polynome(double x, double[] c) {
        int n = c.length - 1;
        double y = c[n];
        while (n > 0) {
            y = y * x + c[--n];
        }
        return y;
    }

    private static double polynome_neg(double x, double[] c) {
        int n = c.length - 1;
        double y = c[n];
        while (n > 0) {
            y = y / x + c[--n];
        }
        return y;
    }
}

