/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.util.Collection;
import java.util.Date;
import org.geotools.api.metadata.Identifier;
import org.geotools.api.metadata.citation.Citation;
import org.geotools.api.metadata.citation.PresentationForm;
import org.geotools.api.metadata.citation.ResponsibleParty;
import org.geotools.api.util.InternationalString;
import org.geotools.metadata.iso.IdentifierImpl;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.util.SimpleInternationalString;

public class CitationImpl
extends MetadataEntity
implements Citation {
    private static final long serialVersionUID = -4415559967618358778L;
    private InternationalString title;
    private Collection<InternationalString> alternateTitles;
    private InternationalString edition;
    private long editionDate = Long.MIN_VALUE;
    private Collection<Identifier> identifiers;
    private Collection<ResponsibleParty> citedResponsibleParties;
    private Collection<PresentationForm> presentationForm;
    private InternationalString otherCitationDetails;
    private InternationalString collectiveTitle;
    private String ISBN;
    private String ISSN;

    public CitationImpl() {
    }

    public CitationImpl(Citation source) {
        super(source);
    }

    public CitationImpl(CharSequence title) {
        InternationalString string;
        InternationalString t = title instanceof InternationalString ? (string = (InternationalString)title) : new SimpleInternationalString(title.toString());
        this.setTitle(t);
    }

    public CitationImpl(ResponsibleParty party) {
        String name;
        InternationalString title = party.getOrganisationName();
        if (title == null && (title = party.getPositionName()) == null && (name = party.getIndividualName()) != null) {
            title = new SimpleInternationalString(name);
        }
        this.setTitle(title);
        this.getCitedResponsibleParties().add(party);
    }

    final void addAuthority(String identifier, boolean asTitle) {
        if (asTitle) {
            this.getAlternateTitles().add(new SimpleInternationalString(identifier));
        }
        this.getIdentifiers().add(new IdentifierImpl(identifier));
    }

    @Override
    public InternationalString getTitle() {
        return this.title;
    }

    public void setTitle(InternationalString newValue) {
        this.checkWritePermission();
        this.title = newValue;
    }

    public Collection<InternationalString> getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return this.alternateTitles;
    }

    public void setAlternateTitles(Collection<? extends InternationalString> newValues) {
        this.alternateTitles = this.copyCollection(newValues, this.alternateTitles, InternationalString.class);
    }

    @Override
    public InternationalString getEdition() {
        return this.edition;
    }

    public void setEdition(InternationalString newValue) {
        this.checkWritePermission();
        this.edition = newValue;
    }

    @Override
    public Date getEditionDate() {
        return this.editionDate != Long.MIN_VALUE ? new Date(this.editionDate) : null;
    }

    public void setEditionDate(Date newValue) {
        this.checkWritePermission();
        this.editionDate = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public Collection<Identifier> getIdentifiers() {
        this.identifiers = this.nonNullCollection(this.identifiers, Identifier.class);
        return this.identifiers;
    }

    public void setIdentifiers(Collection<? extends Identifier> newValues) {
        this.identifiers = this.copyCollection(newValues, this.identifiers, Identifier.class);
    }

    public Collection<ResponsibleParty> getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return this.citedResponsibleParties;
    }

    public void setCitedResponsibleParties(Collection<? extends ResponsibleParty> newValues) {
        this.citedResponsibleParties = this.copyCollection(newValues, this.citedResponsibleParties, ResponsibleParty.class);
    }

    @Override
    public Collection<PresentationForm> getPresentationForm() {
        this.presentationForm = this.nonNullCollection(this.presentationForm, PresentationForm.class);
        return this.presentationForm;
    }

    public void setPresentationForm(Collection<? extends PresentationForm> newValues) {
        this.presentationForm = this.copyCollection(newValues, this.presentationForm, PresentationForm.class);
    }

    @Override
    public InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public void setOtherCitationDetails(InternationalString newValue) {
        this.checkWritePermission();
        this.otherCitationDetails = newValue;
    }

    @Override
    public InternationalString getCollectiveTitle() {
        return this.collectiveTitle;
    }

    public void setCollectiveTitle(InternationalString newValue) {
        this.checkWritePermission();
        this.collectiveTitle = newValue;
    }

    @Override
    public String getISBN() {
        return this.ISBN;
    }

    public void setISBN(String newValue) {
        this.checkWritePermission();
        this.ISBN = newValue;
    }

    @Override
    public String getISSN() {
        return this.ISSN;
    }

    public void setISSN(String newValue) {
        this.checkWritePermission();
        this.ISSN = newValue;
    }
}

