/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.util.List;
import java.util.stream.Collectors;
import org.geotools.http.HTTPBehavior;
import org.geotools.util.factory.Hints;

public class HTTPFactoryException
extends RuntimeException {
    private static final long serialVersionUID = 3038706500613959333L;

    public HTTPFactoryException(String message, Hints hints, List<Class<? extends HTTPBehavior>> behaviors) {
        super(HTTPFactoryException.createMessage(message, hints, behaviors));
    }

    private static String createMessage(String message, Hints hints, List<Class<? extends HTTPBehavior>> behaviors) {
        if (hints.containsKey(Hints.HTTP_CLIENT_FACTORY) || hints.containsKey(Hints.HTTP_CLIENT)) {
            message = "%s\nHTTP_CLIENT_FACTORY(%s) HTTP_CLIENT(%s)".formatted(message, hints.get(Hints.HTTP_CLIENT_FACTORY), hints.get(Hints.HTTP_CLIENT));
        }
        if (!behaviors.isEmpty()) {
            message = "%s\nBehaviors:%s".formatted(message, behaviors.stream().map(behavior -> behavior.getSimpleName()).collect(Collectors.joining(",")));
        }
        return message;
    }
}

