/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.geotools.http.DefaultHTTPClientFactory;
import org.geotools.http.HTTPBehavior;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFactory;
import org.geotools.http.HTTPFactoryException;
import org.geotools.http.HTTPProxy;
import org.geotools.util.factory.FactoryCreator;
import org.geotools.util.factory.FactoryFinder;
import org.geotools.util.factory.FactoryRegistry;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;

public class HTTPClientFinder
extends FactoryFinder {
    private static volatile FactoryRegistry registry;

    private HTTPClientFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(HTTPClientFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(HTTPClientFactory.class));
        }
        return registry;
    }

    public static HTTPClient createClient() {
        Hints hints = GeoTools.getDefaultHints();
        return HTTPClientFinder.lookupClient(hints, new LinkedList<Class<? extends HTTPBehavior>>());
    }

    @SafeVarargs
    public static HTTPClient createClient(Class<? extends HTTPBehavior> ... behaviors) {
        Hints hints = GeoTools.getDefaultHints();
        ArrayList<Class<? extends HTTPBehavior>> list = new ArrayList<Class<? extends HTTPBehavior>>();
        for (Class<? extends HTTPBehavior> behavior : behaviors) {
            list.add(behavior);
        }
        return HTTPClientFinder.lookupClient(hints, list);
    }

    public static HTTPClient createClient(Hints hints) {
        Hints merged = HTTPClientFinder.mergeSystemHints(hints);
        return HTTPClientFinder.lookupClient(merged, new LinkedList<Class<? extends HTTPBehavior>>());
    }

    private static synchronized HTTPClient lookupClient(Hints hints, List<Class<? extends HTTPBehavior>> behaviors) {
        if (hints == null) {
            throw new IllegalArgumentException("hints can't be null.");
        }
        if (behaviors == null) {
            throw new IllegalArgumentException("behaviors can't be null.");
        }
        if (System.getProperty("http.proxyHost") != null) {
            behaviors.add(HTTPProxy.class);
        }
        return HTTPClientFinder.getServiceRegistry().getFactories(HTTPClientFactory.class, null, null).filter(fact -> HTTPClientFinder.matchHttpFactoryHints(fact, hints)).filter(fact -> HTTPClientFinder.matchHttpClientHintsBehaviors(fact, hints, behaviors)).filter(fact -> HTTPClientFinder.matchDefault(fact, hints, behaviors)).findFirst().orElseThrow(() -> new HTTPFactoryException("Couldn't create HTTP client.", hints, behaviors)).createClient(hints, behaviors);
    }

    public static synchronized void reset() {
        FactoryRegistry copy = registry;
        registry = null;
        if (copy != null) {
            copy.deregisterAll();
        }
    }

    private static boolean matchHttpFactoryHints(HTTPClientFactory fact, Hints hints) {
        boolean bl;
        if (!hints.containsKey(Hints.HTTP_CLIENT_FACTORY)) {
            return true;
        }
        Object val = hints.get(Hints.HTTP_CLIENT_FACTORY);
        if (val instanceof String) {
            String s = (String)val;
            bl = fact.getClass().getName().equalsIgnoreCase(s);
        } else {
            bl = fact.getClass() == (Class)val;
        }
        return bl;
    }

    private static boolean matchHttpClientHintsBehaviors(HTTPClientFactory fact, Hints hints, List<Class<? extends HTTPBehavior>> behaviors) {
        return fact.canProcess(hints, behaviors);
    }

    private static boolean matchDefault(HTTPClientFactory fact, Hints hints, List<Class<? extends HTTPBehavior>> behaviors) {
        if (hints.containsKey(Hints.HTTP_CLIENT) || hints.containsKey(Hints.HTTP_CLIENT_FACTORY) || !behaviors.isEmpty()) {
            return true;
        }
        return fact.getClass() == DefaultHTTPClientFactory.class;
    }
}

