/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.List;
import org.geotools.geometry.jts.CircularRing;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurve;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CompoundRing;
import org.geotools.geometry.jts.CurvePolygon;
import org.geotools.geometry.jts.MultiCurve;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.util.Assert;

public class WKTWriter2
extends WKTWriter {
    private int outputDimension = 2;
    private DecimalFormat formatter;
    private boolean isFormatted = false;
    private boolean useFormatting = false;
    private int coordsPerLine = -1;
    private String indentTabStr = "  ";

    public static String toPoint(Coordinate p0) {
        return "POINT ( " + p0.x + " " + p0.y + " )";
    }

    public static String toLineString(CoordinateSequence seq) {
        StringBuffer buf = new StringBuffer();
        buf.append("LINESTRING ");
        if (seq.size() == 0) {
            buf.append(" EMPTY");
        } else {
            buf.append("(");
            for (int i = 0; i < seq.size(); ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(seq.getX(i) + " " + seq.getY(i));
            }
            buf.append(")");
        }
        return buf.toString();
    }

    public static String toLineString(Coordinate p0, Coordinate p1) {
        return "LINESTRING ( " + p0.x + " " + p0.y + ", " + p1.x + " " + p1.y + " )";
    }

    private static DecimalFormat createFormatter(PrecisionModel precisionModel) {
        int decimalPlaces = precisionModel.getMaximumSignificantDigits();
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        symbols.setMinusSign('-');
        String fmtString = "0" + (decimalPlaces > 0 ? "." : "") + WKTWriter2.stringOfChar('#', decimalPlaces);
        return new DecimalFormat(fmtString, symbols);
    }

    public static String stringOfChar(char ch, int count) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < count; ++i) {
            buf.append(ch);
        }
        return buf.toString();
    }

    public WKTWriter2() {
    }

    public WKTWriter2(int outputDimension) {
        this.outputDimension = outputDimension;
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Invalid output dimension (must be 2 or 3)");
        }
    }

    @Override
    public void setFormatted(boolean isFormatted) {
        this.isFormatted = isFormatted;
    }

    @Override
    public void setMaxCoordinatesPerLine(int coordsPerLine) {
        this.coordsPerLine = coordsPerLine;
    }

    @Override
    public void setTab(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Tab count must be positive");
        }
        this.indentTabStr = WKTWriter2.stringOfChar(' ', size);
    }

    @Override
    public String write(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, this.isFormatted, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    @Override
    public void write(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, false, writer);
    }

    @Override
    public String writeFormatted(Geometry geometry) {
        StringWriter sw = new StringWriter();
        try {
            this.writeFormatted(geometry, true, sw);
        }
        catch (IOException ex) {
            Assert.shouldNeverReachHere();
        }
        return ((Object)sw).toString();
    }

    @Override
    public void writeFormatted(Geometry geometry, Writer writer) throws IOException {
        this.writeFormatted(geometry, true, writer);
    }

    private void writeFormatted(Geometry geometry, boolean useFormatting, Writer writer) throws IOException {
        this.useFormatting = useFormatting;
        this.formatter = WKTWriter2.createFormatter(geometry.getPrecisionModel());
        this.appendGeometryTaggedText(geometry, 0, writer);
    }

    private void appendGeometryTaggedText(Geometry geometry, int level, Writer writer) throws IOException {
        this.indent(level, writer);
        if (geometry instanceof Point) {
            Point point = (Point)geometry;
            this.appendPointTaggedText(point.getCoordinate(), level, writer, point.getPrecisionModel());
        } else if (geometry instanceof CircularString) {
            CircularString string2 = (CircularString)geometry;
            this.appendCircularStringTaggedText(string2, level, writer);
        } else if (geometry instanceof CircularRing) {
            CircularRing ring1 = (CircularRing)geometry;
            this.appendCircularStringTaggedText(ring1, level, writer);
        } else if (geometry instanceof CompoundCurve) {
            CompoundCurvedGeometry cast = (CompoundCurvedGeometry)((Object)geometry);
            this.appendCompoundCurveTaggedText(cast, level, writer);
        } else if (geometry instanceof CompoundRing) {
            CompoundCurvedGeometry cast = (CompoundCurvedGeometry)((Object)geometry);
            this.appendCompoundCurveTaggedText(cast, level, writer);
        } else if (geometry instanceof LinearRing) {
            LinearRing ring = (LinearRing)geometry;
            this.appendLinearRingTaggedText(ring, level, writer);
        } else if (geometry instanceof LineString) {
            LineString string1 = (LineString)geometry;
            this.appendLineStringTaggedText(string1, level, writer);
        } else if (geometry instanceof CurvePolygon) {
            CurvePolygon polygon2 = (CurvePolygon)geometry;
            this.appendCurvePolygonTaggedText(polygon2, level, writer);
        } else if (geometry instanceof Polygon) {
            Polygon polygon1 = (Polygon)geometry;
            this.appendPolygonTaggedText(polygon1, level, writer);
        } else if (geometry instanceof MultiPoint) {
            MultiPoint point = (MultiPoint)geometry;
            this.appendMultiPointTaggedText(point, level, writer);
        } else if (geometry instanceof MultiCurve) {
            MultiCurve curve = (MultiCurve)geometry;
            this.appendMultiCurveTaggedText(curve, level, writer);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString string = (MultiLineString)geometry;
            this.appendMultiLineStringTaggedText(string, level, writer);
        } else if (geometry instanceof MultiSurface) {
            MultiSurface surface = (MultiSurface)geometry;
            this.appendMultiSurfaceTaggedText(surface, level, writer);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon polygon = (MultiPolygon)geometry;
            this.appendMultiPolygonTaggedText(polygon, level, writer);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            this.appendGeometryCollectionTaggedText(collection, level, writer);
        } else {
            Assert.shouldNeverReachHere("Unsupported Geometry implementation:" + String.valueOf(geometry.getClass()));
        }
    }

    private void appendPointTaggedText(Coordinate coordinate, int level, Writer writer, PrecisionModel precisionModel) throws IOException {
        writer.write("POINT ");
        this.appendPointText(coordinate, level, writer, precisionModel);
    }

    private void appendCircularStringTaggedText(SingleCurvedGeometry circularString, int level, Writer writer) throws IOException {
        writer.write("CIRCULARSTRING ");
        this.appendControlPointText(circularString, level, false, writer);
    }

    private void appendLineStringTaggedText(LineString lineString, int level, Writer writer) throws IOException {
        writer.write("LINESTRING ");
        this.appendLineStringText(lineString, level, false, writer);
    }

    private void appendLinearRingTaggedText(LinearRing linearRing, int level, Writer writer) throws IOException {
        writer.write("LINEARRING ");
        this.appendLineStringText(linearRing, level, false, writer);
    }

    private void appendPolygonTaggedText(Polygon polygon, int level, Writer writer) throws IOException {
        writer.write("POLYGON ");
        this.appendPolygonText(polygon, level, false, writer);
    }

    private void appendMultiPointTaggedText(MultiPoint multipoint, int level, Writer writer) throws IOException {
        writer.write("MULTIPOINT ");
        this.appendMultiPointText(multipoint, level, writer);
    }

    private void appendMultiLineStringTaggedText(MultiLineString multiLineString, int level, Writer writer) throws IOException {
        writer.write("MULTILINESTRING ");
        this.appendMultiLineStringText(multiLineString, level, false, writer);
    }

    private void appendMultiPolygonTaggedText(MultiPolygon multiPolygon, int level, Writer writer) throws IOException {
        writer.write("MULTIPOLYGON ");
        this.appendMultiPolygonText(multiPolygon, level, writer);
    }

    private void appendGeometryCollectionTaggedText(GeometryCollection geometryCollection, int level, Writer writer) throws IOException {
        writer.write("GEOMETRYCOLLECTION ");
        this.appendGeometryCollectionText(geometryCollection, level, writer);
    }

    private void appendPointText(Coordinate coordinate, int level, Writer writer, PrecisionModel precisionModel) throws IOException {
        if (coordinate == null) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            this.appendCoordinate(coordinate, writer);
            writer.write(")");
        }
    }

    private void appendControlPoint(double x, double y, Writer writer) throws IOException {
        writer.write(this.writeNumber(x) + " " + this.writeNumber(y));
    }

    private void appendCoordinate(Coordinate coordinate, Writer writer) throws IOException {
        writer.write(this.writeNumber(coordinate.x) + " " + this.writeNumber(coordinate.y));
        if (this.outputDimension >= 3 && !Double.isNaN(coordinate.getZ())) {
            writer.write(" ");
            writer.write(this.writeNumber(coordinate.getZ()));
        }
    }

    private String writeNumber(double d) {
        return this.formatter.format(d);
    }

    private void appendControlPointText(SingleCurvedGeometry cg, int level, boolean doIndent, Writer writer) throws IOException {
        if (((Geometry)((Object)cg)).isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (doIndent) {
                this.indent(level, writer);
            }
            writer.write("(");
            double[] controlPoints = cg.getControlPoints();
            for (int i = 0; i < controlPoints.length; i += 2) {
                if (i > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i % this.coordsPerLine == 0) {
                        this.indent(level + 1, writer);
                    }
                }
                this.appendControlPoint(controlPoints[i], controlPoints[i + 1], writer);
            }
            writer.write(")");
        }
    }

    private void appendLineStringText(LineString lineString, int level, boolean doIndent, Writer writer) throws IOException {
        if (lineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (doIndent) {
                this.indent(level, writer);
            }
            writer.write("(");
            for (int i = 0; i < lineString.getNumPoints(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    if (this.coordsPerLine > 0 && i % this.coordsPerLine == 0) {
                        this.indent(level + 1, writer);
                    }
                }
                this.appendCoordinate(lineString.getCoordinateN(i), writer);
            }
            writer.write(")");
        }
    }

    private void appendCurvePolygonTaggedText(CurvePolygon polygon, int level, Writer writer) throws IOException {
        writer.write("CURVEPOLYGON ");
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            this.appendPotentialCurveText(polygon.getExteriorRing(), level, false, writer);
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                writer.write(", ");
                this.appendPotentialCurveText(polygon.getInteriorRingN(i), level + 1, true, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiCurveTaggedText(MultiCurve mc, int level, Writer writer) throws IOException {
        writer.write("MULTICURVE ");
        if (mc.isEmpty()) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            for (int i = 0; i < mc.getNumGeometries(); ++i) {
                this.appendPotentialCurveText((LineString)mc.getGeometryN(i), level + 1, true, writer);
                if (i >= mc.getNumGeometries() - 1) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
    }

    private void appendMultiSurfaceTaggedText(MultiSurface ms, int level, Writer writer) throws IOException {
        writer.write("MULTISURFACE ");
        if (ms.isEmpty()) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            for (int i = 0; i < ms.getNumGeometries(); ++i) {
                this.appendPotentialCurvePolygonText((Polygon)ms.getGeometryN(i), level + 1, true, writer);
                if (i >= ms.getNumGeometries() - 1) continue;
                writer.write(", ");
            }
            writer.write(")");
        }
    }

    private void appendPolygonText(Polygon polygon, int level, boolean indentFirst, Writer writer) throws IOException {
        if (polygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            if (indentFirst) {
                this.indent(level, writer);
            }
            writer.write("(");
            this.appendLineStringText(polygon.getExteriorRing(), level, false, writer);
            for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                writer.write(", ");
                this.appendLineStringText(polygon.getInteriorRingN(i), level + 1, true, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPointText(MultiPoint multiPoint, int level, Writer writer) throws IOException {
        if (multiPoint.isEmpty()) {
            writer.write("EMPTY");
        } else {
            writer.write("(");
            for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    this.indentCoords(i, level + 1, writer);
                }
                writer.write("(");
                this.appendCoordinate(multiPoint.getGeometryN(i).getCoordinate(), writer);
                writer.write(")");
            }
            writer.write(")");
        }
    }

    private void appendCompoundCurveTaggedText(CompoundCurvedGeometry<LineString> multiLineString, int level, Writer writer) throws IOException {
        writer.write("COMPOUNDCURVE ");
        if (((Geometry)((Object)multiLineString)).isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            List<LineString> components = multiLineString.getComponents();
            for (int i = 0; i < components.size(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                LineString component = components.get(i);
                this.appendPotentialCurveText(component, level2, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendPotentialCurveText(LineString component, int level, boolean doIndent, Writer writer) throws IOException {
        if (component instanceof SingleCurvedGeometry) {
            SingleCurvedGeometry cast = (SingleCurvedGeometry)((Object)component);
            this.appendCircularStringTaggedText(cast, level, writer);
        } else if (component instanceof CompoundCurvedGeometry) {
            CompoundCurvedGeometry cast = (CompoundCurvedGeometry)((Object)component);
            this.appendCompoundCurveTaggedText(cast, level, writer);
        } else {
            this.appendLineStringText(component, level, doIndent, writer);
        }
    }

    private void appendPotentialCurvePolygonText(Polygon component, int level, boolean doIndent, Writer writer) throws IOException {
        if (component instanceof CurvePolygon) {
            CurvePolygon polygon = (CurvePolygon)component;
            this.appendCurvePolygonTaggedText(polygon, level, writer);
        } else {
            this.appendPolygonText(component, level, doIndent, writer);
        }
    }

    private void appendMultiLineStringText(MultiLineString multiLineString, int level, boolean indentFirst, Writer writer) throws IOException {
        if (multiLineString.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = indentFirst;
            writer.write("(");
            for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendLineStringText((LineString)multiLineString.getGeometryN(i), level2, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendMultiPolygonText(MultiPolygon multiPolygon, int level, Writer writer) throws IOException {
        if (multiPolygon.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            boolean doIndent = false;
            writer.write("(");
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                    doIndent = true;
                }
                this.appendPolygonText((Polygon)multiPolygon.getGeometryN(i), level2, doIndent, writer);
            }
            writer.write(")");
        }
    }

    private void appendGeometryCollectionText(GeometryCollection geometryCollection, int level, Writer writer) throws IOException {
        if (geometryCollection.isEmpty()) {
            writer.write("EMPTY");
        } else {
            int level2 = level;
            writer.write("(");
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                if (i > 0) {
                    writer.write(", ");
                    level2 = level + 1;
                }
                this.appendGeometryTaggedText(geometryCollection.getGeometryN(i), level2, writer);
            }
            writer.write(")");
        }
    }

    private void indentCoords(int coordIndex, int level, Writer writer) throws IOException {
        if (this.coordsPerLine <= 0 || coordIndex % this.coordsPerLine != 0) {
            return;
        }
        this.indent(level, writer);
    }

    private void indent(int level, Writer writer) throws IOException {
        if (!this.useFormatting || level <= 0) {
            return;
        }
        writer.write("\n");
        for (int i = 0; i < level; ++i) {
            writer.write(this.indentTabStr);
        }
    }
}

