/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.ArrayList;
import java.util.List;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.CircularString;
import org.geotools.geometry.jts.CompoundCurvedGeometry;
import org.geotools.geometry.jts.CurvedGeometry;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;

public class CompoundCurve
extends LineString
implements CompoundCurvedGeometry<LineString> {
    private static final long serialVersionUID = -5796254063449438787L;
    List<LineString> components;
    LineString linearized;
    double tolerance;

    public CompoundCurve(List<LineString> components, GeometryFactory factory, double tolerance) {
        super(CircularString.FAKE_STRING_2D, factory);
        this.tolerance = tolerance;
        this.components = new ArrayList<LineString>();
        for (LineString ls : components) {
            if (ls instanceof CompoundCurve) {
                CompoundCurve cc = (CompoundCurve)ls;
                this.components.addAll(cc.components);
                continue;
            }
            this.components.add(ls);
        }
        if (components.size() > 1) {
            LineString prev = components.get(0);
            for (int i = 1; i < components.size(); ++i) {
                Coordinate startPoint;
                LineString curr = components.get(i);
                Coordinate endPoint = prev.getCoordinateN(prev.getNumPoints() - 1);
                if (!endPoint.equals(startPoint = curr.getCoordinateN(0))) {
                    throw new IllegalArgumentException("Found two elements that are not connected, " + String.valueOf(prev) + " and " + String.valueOf(curr));
                }
                prev = curr;
            }
        }
    }

    @Override
    public int getCoordinatesDimension() {
        if (this.components.isEmpty()) {
            return 2;
        }
        int dimension = Integer.MAX_VALUE;
        for (LineString component : this.components) {
            int curr;
            if (component instanceof CurvedGeometry) {
                CurvedGeometry geometry = (CurvedGeometry)((Object)component);
                curr = geometry.getCoordinatesDimension();
            } else {
                curr = component.getCoordinateSequence().getDimension();
            }
            dimension = Math.min(curr, dimension);
        }
        return dimension;
    }

    @Override
    public LineString linearize() {
        return this.linearize(this.tolerance);
    }

    @Override
    public LineString linearize(double tolerance) {
        boolean isDefaultTolerance = CircularArc.equals(tolerance, this.tolerance);
        if (this.linearized != null && isDefaultTolerance) {
            return this.linearized;
        }
        CoordinateSequence cs = this.getLinearizedCoordinateSequence(tolerance);
        LineString result = new LineString(cs, this.factory);
        if (isDefaultTolerance) {
            this.linearized = result;
        }
        return result;
    }

    protected CoordinateSequence getLinearizedCoordinateSequence(double tolerance) {
        GrowableOrdinateArray gar = new GrowableOrdinateArray();
        for (LineString component : this.components) {
            CoordinateSequence cs;
            if (gar.size() > 0) {
                gar.setSize(gar.size() - 2);
            }
            if (component instanceof SingleCurvedGeometry) {
                SingleCurvedGeometry curved = (SingleCurvedGeometry)((Object)component);
                cs = curved.getLinearizedCoordinateSequence(tolerance);
                gar.addAll(cs);
                continue;
            }
            cs = component.getCoordinateSequence();
            for (int i = 0; i < cs.size(); ++i) {
                gar.add(cs.getX(i), cs.getY(i));
            }
        }
        CoordinateSequence cs = gar.toCoordinateSequence(this.getFactory());
        return cs;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public List<LineString> getComponents() {
        return this.components;
    }

    @Override
    public boolean isClosed() {
        LineString firstComponent = this.components.get(0);
        LineString lastComponent = this.components.get(this.components.size() - 1);
        return firstComponent.getStartPoint().equals(lastComponent.getEndPoint());
    }

    @Override
    public int getDimension() {
        return super.getDimension();
    }

    @Override
    public int getBoundaryDimension() {
        return super.getDimension();
    }

    @Override
    public boolean isEmpty() {
        for (LineString ls : this.components) {
            if (ls.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getGeometryType() {
        return "CompoundCurve";
    }

    @Override
    public CompoundCurve reverse() {
        return (CompoundCurve)super.reverse();
    }

    @Override
    public CompoundCurve reverseInternal() {
        ArrayList<LineString> reversedComponents = new ArrayList<LineString>(this.components.size());
        for (LineString ls : this.components) {
            LineString reversed = ls.reverse();
            reversedComponents.add(0, reversed);
        }
        return new CompoundCurve(reversedComponents, this.getFactory(), this.tolerance);
    }

    @Override
    public Point getInteriorPoint() {
        return this.components.get(this.components.size() / 2).getInteriorPoint();
    }

    @Override
    public Geometry getEnvelope() {
        return super.getEnvelope();
    }

    @Override
    public Envelope getEnvelopeInternal() {
        return super.getEnvelopeInternal();
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        Envelope result = new Envelope();
        for (LineString ls : this.components) {
            result.expandToInclude(ls.getEnvelopeInternal());
        }
        return result;
    }

    @Override
    public int getNumGeometries() {
        return this.components.size();
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this.components.get(n);
    }

    @Override
    public void setUserData(Object userData) {
        super.setUserData(userData);
    }

    @Override
    public int getSRID() {
        return super.getSRID();
    }

    @Override
    public void setSRID(int SRID) {
        super.setSRID(SRID);
    }

    @Override
    public GeometryFactory getFactory() {
        return super.getFactory();
    }

    @Override
    public Object getUserData() {
        return super.getUserData();
    }

    @Override
    public PrecisionModel getPrecisionModel() {
        return super.getPrecisionModel();
    }

    @Override
    public boolean equalsExact(Geometry other) {
        return this.equalsExact(other, 0.0);
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (other instanceof CompoundCurve) {
            CompoundCurve ccOther = (CompoundCurve)other;
            if (ccOther.components.size() != this.components.size()) {
                return false;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                LineString ls2;
                LineString ls1 = this.components.get(i);
                if (ls1.equalsExact(ls2 = ccOther.components.get(i), tolerance)) continue;
                return false;
            }
            return true;
        }
        return this.linearize(tolerance).equalsExact(other, tolerance);
    }

    @Override
    public boolean equals(Geometry other) {
        if (other instanceof CompoundCurve) {
            CompoundCurve ccOther = (CompoundCurve)other;
            if (ccOther.components.size() != this.components.size()) {
                return false;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                LineString ls2;
                LineString ls1 = this.components.get(i);
                if (ls1.equals(ls2 = ccOther.components.get(i))) continue;
                return false;
            }
            return true;
        }
        return this.linearize().equals(other);
    }

    @Override
    public boolean equalsTopo(Geometry other) {
        if (other instanceof CompoundCurve) {
            CompoundCurve ccOther = (CompoundCurve)other;
            if (ccOther.components.size() != this.components.size()) {
                return false;
            }
            for (int i = 0; i < this.components.size(); ++i) {
                LineString ls2;
                LineString ls1 = this.components.get(i);
                if (ls1.equalsTopo(ls2 = ccOther.components.get(i))) continue;
                return false;
            }
            return true;
        }
        return this.linearize().equalsTopo(other);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Geometry) {
            Geometry geometry = (Geometry)o;
            return this.equals(geometry);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return this.toCurvedText();
    }

    @Override
    public String toCurvedText() {
        StringBuilder sb = new StringBuilder("COMPOUNDCURVE ");
        if (this.components.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            for (int k = 0; k < this.components.size(); ++k) {
                LineString component = this.components.get(k);
                if (component instanceof SingleCurvedGeometry) {
                    SingleCurvedGeometry curved = (SingleCurvedGeometry)((Object)component);
                    sb.append(curved.toCurvedText());
                } else {
                    sb.append("(");
                    CoordinateSequence cs = component.getCoordinateSequence();
                    for (int i = 0; i < cs.size(); ++i) {
                        sb.append(cs.getX(i) + " " + cs.getY(i));
                        if (i >= cs.size() - 1) continue;
                        sb.append(", ");
                    }
                    sb.append(")");
                }
                if (k >= this.components.size() - 1) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public boolean equalsNorm(Geometry g) {
        return super.equalsNorm(g);
    }

    @Override
    public boolean isRectangle() {
        return this.linearize().isRectangle();
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.linearize().getCoordinates();
    }

    @Override
    public CoordinateSequence getCoordinateSequence() {
        return this.linearize().getCoordinateSequence();
    }

    @Override
    public Coordinate getCoordinateN(int n) {
        return this.linearize().getCoordinateN(n);
    }

    @Override
    public Coordinate getCoordinate() {
        return this.linearize().getCoordinate();
    }

    @Override
    public int getNumPoints() {
        return this.linearize().getNumPoints();
    }

    @Override
    public Point getPointN(int n) {
        return this.linearize().getPointN(n);
    }

    @Override
    public Point getStartPoint() {
        return this.linearize().getStartPoint();
    }

    @Override
    public Point getEndPoint() {
        return this.linearize().getEndPoint();
    }

    @Override
    public boolean isRing() {
        return this.linearize().isRing();
    }

    @Override
    public double getLength() {
        return this.linearize().getLength();
    }

    @Override
    public Geometry getBoundary() {
        return this.linearize().getBoundary();
    }

    @Override
    public boolean isCoordinate(Coordinate pt) {
        return this.linearize().isCoordinate(pt);
    }

    @Override
    public void apply(CoordinateFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(GeometryFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public CompoundCurve copyInternal() {
        return new CompoundCurve(this.components, this.factory, this.tolerance);
    }

    @Override
    public void normalize() {
        this.linearize().normalize();
    }

    @Override
    public boolean isSimple() {
        return this.linearize().isSimple();
    }

    @Override
    public boolean isValid() {
        return this.linearize().isValid();
    }

    @Override
    public double distance(Geometry g) {
        return this.linearize().distance(g);
    }

    @Override
    public boolean isWithinDistance(Geometry geom, double distance) {
        return this.linearize().isWithinDistance(geom, distance);
    }

    @Override
    public double getArea() {
        return this.linearize().getArea();
    }

    @Override
    public Point getCentroid() {
        return this.linearize().getCentroid();
    }

    @Override
    public void geometryChanged() {
        this.linearize().geometryChanged();
    }

    @Override
    public boolean disjoint(Geometry g) {
        return this.linearize().disjoint(g);
    }

    @Override
    public boolean touches(Geometry g) {
        return this.linearize().touches(g);
    }

    @Override
    public boolean intersects(Geometry g) {
        return this.linearize().intersects(g);
    }

    @Override
    public boolean crosses(Geometry g) {
        return this.linearize().crosses(g);
    }

    @Override
    public boolean within(Geometry g) {
        return this.linearize().within(g);
    }

    @Override
    public boolean contains(Geometry g) {
        return this.linearize().contains(g);
    }

    @Override
    public boolean overlaps(Geometry g) {
        return this.linearize().overlaps(g);
    }

    @Override
    public boolean covers(Geometry g) {
        return this.linearize().covers(g);
    }

    @Override
    public boolean coveredBy(Geometry g) {
        return this.linearize().coveredBy(g);
    }

    @Override
    public boolean relate(Geometry g, String intersectionPattern) {
        return this.linearize().relate(g, intersectionPattern);
    }

    @Override
    public IntersectionMatrix relate(Geometry g) {
        return this.linearize().relate(g);
    }

    @Override
    public Geometry buffer(double distance) {
        return this.linearize().buffer(distance);
    }

    @Override
    public Geometry buffer(double distance, int quadrantSegments) {
        return this.linearize().buffer(distance, quadrantSegments);
    }

    @Override
    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return this.linearize().buffer(distance, quadrantSegments, endCapStyle);
    }

    @Override
    public Geometry convexHull() {
        return this.linearize().convexHull();
    }

    @Override
    public Geometry intersection(Geometry other) {
        return this.linearize().intersection(other);
    }

    @Override
    public Geometry union(Geometry other) {
        return this.linearize().union(other);
    }

    @Override
    public Geometry difference(Geometry other) {
        return this.linearize().difference(other);
    }

    @Override
    public Geometry symDifference(Geometry other) {
        return this.linearize().symDifference(other);
    }

    @Override
    public Geometry union() {
        return this.linearize().union();
    }

    @Override
    public Geometry norm() {
        return this.linearize().norm();
    }

    @Override
    public int compareTo(Object o) {
        return this.linearize().compareTo(o);
    }

    @Override
    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        return this.linearize().compareTo(o, comp);
    }

    @Override
    public String toText() {
        return this.linearize().toText();
    }
}

