/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.util.Arrays;
import org.geotools.geometry.jts.CircularArc;
import org.geotools.geometry.jts.GrowableOrdinateArray;
import org.geotools.geometry.jts.SingleCurvedGeometry;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class CircularString
extends LineString
implements SingleCurvedGeometry<LineString> {
    private static final long serialVersionUID = -5796254063449438787L;
    static final CoordinateSequence FAKE_STRING_2D = new CoordinateArraySequence(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(1.0, 1.0)});
    double[] controlPoints;
    double tolerance;
    LineString linearized;

    public CircularString(CoordinateSequence points, GeometryFactory factory, double tolerance) {
        super(FAKE_STRING_2D, factory);
        this.tolerance = tolerance;
        int pointCount = points.size();
        this.controlPoints = new double[pointCount * 2];
        for (int i = 0; i < pointCount; ++i) {
            this.controlPoints[i * 2] = points.getX(i);
            this.controlPoints[i * 2 + 1] = points.getY(i);
            if (points.getDimension() <= 2 || Double.isNaN(points.getZ(i))) continue;
            throw new IllegalArgumentException("Circular strings are restricted to 2 dimensions at the moment. Contributions to get ND support welcomed!");
        }
        this.init(this.controlPoints, tolerance);
    }

    public CircularString(double[] controlPoints, GeometryFactory factory, double tolerance) {
        super(FAKE_STRING_2D, factory);
        this.init(controlPoints, tolerance);
    }

    private void init(double[] controlPoints, double tolerance) {
        int length = controlPoints.length;
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Invalid number of ordinates, must be even, but it is " + length + " instead");
        }
        int pointCount = length / 2;
        if (pointCount != 0 && pointCount < 3 || pointCount > 3 && pointCount % 2 == 0) {
            throw new IllegalArgumentException("Invalid number of points, a circular string is always made of an odd number of points, with a mininum of 3, and adding 2 for each extra circular arc in the sequence. Found: " + pointCount);
        }
        this.controlPoints = controlPoints;
        this.tolerance = tolerance;
    }

    @Override
    public double[] getControlPoints() {
        return this.controlPoints;
    }

    @Override
    public double getTolerance() {
        return this.tolerance;
    }

    @Override
    public int getNumArcs() {
        return (this.controlPoints.length - 6) / 4 + 1;
    }

    @Override
    public CircularArc getArcN(int arcIndex) {
        int baseIdx = arcIndex * 4;
        double[] arcControlPoints = new double[6];
        System.arraycopy(this.controlPoints, baseIdx, arcControlPoints, 0, 6);
        CircularArc arc = new CircularArc(arcControlPoints);
        return arc;
    }

    @Override
    public LineString linearize() {
        return this.linearize(this.tolerance);
    }

    @Override
    public LineString linearize(double tolerance) {
        boolean isDefaultTolerance = CircularArc.equals(tolerance, this.tolerance);
        if (this.linearized != null && isDefaultTolerance) {
            return this.linearized;
        }
        CoordinateSequence cs = this.getLinearizedCoordinateSequence(tolerance);
        LineString result = new LineString(cs, this.factory);
        if (isDefaultTolerance) {
            this.linearized = result;
        }
        return result;
    }

    @Override
    public CoordinateSequence getLinearizedCoordinateSequence(final double tolerance) {
        boolean isDefaultTolerance = CircularArc.equals(tolerance, this.tolerance);
        if (this.linearized != null && isDefaultTolerance) {
            return this.linearized.getCoordinateSequence();
        }
        final GrowableOrdinateArray gar = new GrowableOrdinateArray();
        new ArcScan(){

            @Override
            protected void visitArc(CircularArc arc) {
                if (gar.size() > 0) {
                    gar.setSize(gar.size() - 2);
                }
                arc.linearize(tolerance, gar);
            }
        };
        CoordinateSequence cs = gar.toCoordinateSequence(this.getFactory());
        return cs;
    }

    @Override
    public boolean isClosed() {
        return this.controlPoints[0] == this.controlPoints[this.controlPoints.length - 2] && this.controlPoints[1] == this.controlPoints[this.controlPoints.length - 1];
    }

    @Override
    public int getDimension() {
        return super.getDimension();
    }

    @Override
    public int getBoundaryDimension() {
        return super.getDimension();
    }

    @Override
    public boolean isEmpty() {
        return this.controlPoints.length == 0;
    }

    @Override
    public String getGeometryType() {
        return "CircularString";
    }

    @Override
    public CircularString reverse() {
        return (CircularString)super.reverse();
    }

    @Override
    protected CircularString reverseInternal() {
        double[] reversed = new double[this.controlPoints.length];
        System.arraycopy(this.controlPoints, 0, reversed, 0, this.controlPoints.length);
        GrowableOrdinateArray array = new GrowableOrdinateArray();
        array.addAll(this.controlPoints);
        array.reverseOrdinates(0, array.size() - 1);
        return new CircularString(array.getData(), this.getFactory(), this.tolerance);
    }

    @Override
    public Point getInteriorPoint() {
        int idx = this.controlPoints.length / 2;
        return new Point(new CoordinateArraySequence(new Coordinate[]{new Coordinate(this.controlPoints[idx], this.controlPoints[idx + 1])}), this.getFactory());
    }

    @Override
    public Geometry getEnvelope() {
        return super.getEnvelope();
    }

    @Override
    public Envelope getEnvelopeInternal() {
        return super.getEnvelopeInternal();
    }

    @Override
    protected Envelope computeEnvelopeInternal() {
        final Envelope result = new Envelope();
        new ArcScan(){

            @Override
            protected void visitArc(CircularArc arc) {
                arc.expandEnvelope(result);
            }
        };
        return result;
    }

    @Override
    public int getNumGeometries() {
        return 1;
    }

    @Override
    public Geometry getGeometryN(int n) {
        return this;
    }

    @Override
    public void setUserData(Object userData) {
        super.setUserData(userData);
    }

    @Override
    public int getSRID() {
        return super.getSRID();
    }

    @Override
    public void setSRID(int SRID) {
        super.setSRID(SRID);
    }

    @Override
    public GeometryFactory getFactory() {
        return super.getFactory();
    }

    @Override
    public Object getUserData() {
        return super.getUserData();
    }

    @Override
    public PrecisionModel getPrecisionModel() {
        return super.getPrecisionModel();
    }

    @Override
    public boolean isRectangle() {
        return false;
    }

    @Override
    public boolean equalsExact(Geometry other) {
        return this.equalsExact(other, 0.0);
    }

    @Override
    public boolean equalsExact(Geometry other, double tolerance) {
        if (other instanceof CircularString) {
            CircularString csOther = (CircularString)other;
            if (Arrays.equals(this.controlPoints, csOther.controlPoints)) {
                return true;
            }
        }
        return this.linearize(tolerance).equalsExact(other, tolerance);
    }

    @Override
    public boolean equals(Geometry other) {
        if (other instanceof CircularString) {
            CircularString csOther = (CircularString)other;
            if (Arrays.equals(this.controlPoints, csOther.controlPoints)) {
                return true;
            }
        }
        return this.linearize().equals(other);
    }

    @Override
    public boolean equalsTopo(Geometry other) {
        if (other instanceof CircularString) {
            CircularString csOther = (CircularString)other;
            if (Arrays.equals(this.controlPoints, csOther.controlPoints)) {
                return true;
            }
        }
        return this.linearize().equalsTopo(other);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof Geometry) {
            Geometry geometry = (Geometry)o;
            return this.equals(geometry);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String toString() {
        return this.toCurvedText();
    }

    @Override
    public String toCurvedText() {
        StringBuilder sb = new StringBuilder("CIRCULARSTRING ");
        if (this.isEmpty()) {
            sb.append("EMPTY");
        } else {
            sb.append("(");
            int i = 0;
            while (i < this.controlPoints.length) {
                sb.append(this.controlPoints[i++] + " " + this.controlPoints[i++]);
                if (i >= this.controlPoints.length) continue;
                sb.append(", ");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    public boolean equalsNorm(Geometry g) {
        return super.equalsNorm(g);
    }

    @Override
    public Point getPointN(int n) {
        if (n == 0) {
            return this.getStartPoint();
        }
        return this.linearize().getPointN(n);
    }

    @Override
    public Point getStartPoint() {
        return new Point(new CoordinateArraySequence(new Coordinate[]{new Coordinate(this.controlPoints[0], this.controlPoints[1])}), this.getFactory());
    }

    @Override
    public Point getEndPoint() {
        return new Point(new CoordinateArraySequence(new Coordinate[]{new Coordinate(this.controlPoints[this.controlPoints.length - 2], this.controlPoints[this.controlPoints.length - 1])}), this.getFactory());
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.linearize().getCoordinates();
    }

    @Override
    public CoordinateSequence getCoordinateSequence() {
        return this.linearize().getCoordinateSequence();
    }

    @Override
    public Coordinate getCoordinateN(int n) {
        return this.linearize().getCoordinateN(n);
    }

    @Override
    public Coordinate getCoordinate() {
        return this.linearize().getCoordinate();
    }

    @Override
    public int getNumPoints() {
        return this.linearize().getNumPoints();
    }

    @Override
    public boolean isRing() {
        return this.linearize().isRing();
    }

    @Override
    public double getLength() {
        return this.linearize().getLength();
    }

    @Override
    public Geometry getBoundary() {
        return this.linearize().getBoundary();
    }

    @Override
    public boolean isCoordinate(Coordinate pt) {
        return this.linearize().isCoordinate(pt);
    }

    @Override
    public void apply(CoordinateFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(CoordinateSequenceFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(GeometryFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    public void apply(GeometryComponentFilter filter) {
        this.linearize().apply(filter);
    }

    @Override
    protected CircularString copyInternal() {
        return new CircularString(this.controlPoints, this.factory, this.tolerance);
    }

    @Override
    public void normalize() {
        this.linearize().normalize();
    }

    @Override
    public boolean isSimple() {
        return this.linearize().isSimple();
    }

    @Override
    public boolean isValid() {
        return this.linearize().isValid();
    }

    @Override
    public double distance(Geometry g) {
        return this.linearize().distance(g);
    }

    @Override
    public boolean isWithinDistance(Geometry geom, double distance) {
        return this.linearize().isWithinDistance(geom, distance);
    }

    @Override
    public double getArea() {
        return this.linearize().getArea();
    }

    @Override
    public Point getCentroid() {
        return this.linearize().getCentroid();
    }

    @Override
    public void geometryChanged() {
        this.linearize().geometryChanged();
    }

    @Override
    public boolean disjoint(Geometry g) {
        return this.linearize().disjoint(g);
    }

    @Override
    public boolean touches(Geometry g) {
        return this.linearize().touches(g);
    }

    @Override
    public boolean intersects(Geometry g) {
        return this.linearize().intersects(g);
    }

    @Override
    public boolean crosses(Geometry g) {
        return this.linearize().crosses(g);
    }

    @Override
    public boolean within(Geometry g) {
        return this.linearize().within(g);
    }

    @Override
    public boolean contains(Geometry g) {
        return this.linearize().contains(g);
    }

    @Override
    public boolean overlaps(Geometry g) {
        return this.linearize().overlaps(g);
    }

    @Override
    public boolean covers(Geometry g) {
        return this.linearize().covers(g);
    }

    @Override
    public boolean coveredBy(Geometry g) {
        return this.linearize().coveredBy(g);
    }

    @Override
    public boolean relate(Geometry g, String intersectionPattern) {
        return this.linearize().relate(g, intersectionPattern);
    }

    @Override
    public IntersectionMatrix relate(Geometry g) {
        return this.linearize().relate(g);
    }

    @Override
    public Geometry buffer(double distance) {
        return this.linearize().buffer(distance);
    }

    @Override
    public Geometry buffer(double distance, int quadrantSegments) {
        return this.linearize().buffer(distance, quadrantSegments);
    }

    @Override
    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return this.linearize().buffer(distance, quadrantSegments, endCapStyle);
    }

    @Override
    public Geometry convexHull() {
        return this.linearize().convexHull();
    }

    @Override
    public Geometry intersection(Geometry other) {
        return this.linearize().intersection(other);
    }

    @Override
    public Geometry union(Geometry other) {
        return this.linearize().union(other);
    }

    @Override
    public Geometry difference(Geometry other) {
        return this.linearize().difference(other);
    }

    @Override
    public Geometry symDifference(Geometry other) {
        return this.linearize().symDifference(other);
    }

    @Override
    public Geometry union() {
        return this.linearize().union();
    }

    @Override
    public Geometry norm() {
        return this.linearize().norm();
    }

    @Override
    public int compareTo(Object o) {
        return this.linearize().compareTo(o);
    }

    @Override
    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        return this.linearize().compareTo(o, comp);
    }

    @Override
    public String toText() {
        return this.linearize().toText();
    }

    @Override
    public int getCoordinatesDimension() {
        return 2;
    }

    abstract class ArcScan {
        public ArcScan() {
            if (CircularString.this.controlPoints.length == 3) {
                CircularArc arc = new CircularArc(CircularString.this.controlPoints);
                this.visitArc(arc);
            } else {
                double[] arcControlPoints = new double[6];
                CircularArc arc = new CircularArc(arcControlPoints);
                for (int i = 0; i <= CircularString.this.controlPoints.length - 6; i += 4) {
                    System.arraycopy(CircularString.this.controlPoints, i, arcControlPoints, 0, 6);
                    arc.reset();
                    this.visitArc(arc);
                }
            }
        }

        protected abstract void visitArc(CircularArc var1);
    }
}

