/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.geometry.MismatchedReferenceSystemException;
import org.geotools.api.geometry.Position;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.Cloneable;
import org.geotools.geometry.AbstractBounds;
import org.geotools.geometry.AbstractPosition;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.Position2D;
import org.geotools.referencing.CRS;
import org.geotools.util.Utilities;

public class Envelope2DArchived
extends Rectangle2D.Double
implements BoundingBox,
Bounds,
Cloneable {
    private static final long serialVersionUID = -3319231220761419350L;
    private CoordinateReferenceSystem crs;

    public Envelope2DArchived() {
        this.width = -1.0;
        this.height = -1.0;
    }

    public Envelope2DArchived(CoordinateReferenceSystem crs) {
        this();
        this.setCoordinateReferenceSystem(crs);
    }

    public Envelope2DArchived(Bounds envelope) {
        super(envelope.getMinimum(0), envelope.getMinimum(1), envelope.getSpan(0), envelope.getSpan(1));
        int dimension = envelope.getDimension();
        if (dimension != 2) {
            throw new MismatchedDimensionException(MessageFormat.format("Can't wrap a {0} dimensional object into a 2 dimensional one.", dimension));
        }
        this.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
    }

    public Envelope2DArchived(CoordinateReferenceSystem crs, Rectangle2D rect) {
        super(rect.getX(), rect.getY(), rect.getWidth(), rect.getHeight());
        this.setCoordinateReferenceSystem(crs);
    }

    public Envelope2DArchived(CoordinateReferenceSystem crs, double x, double y, double width, double height) {
        super(x, y, width, height);
        this.setCoordinateReferenceSystem(crs);
    }

    public Envelope2DArchived(Position2D minDP, Position2D maxDP) throws MismatchedReferenceSystemException {
        super(Math.min(minDP.x, maxDP.x), Math.min(minDP.y, maxDP.y), Math.abs(maxDP.x - minDP.x), Math.abs(maxDP.y - minDP.y));
        this.setCoordinateReferenceSystem(AbstractBounds.getCoordinateReferenceSystem(minDP, maxDP));
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        AbstractPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    @Override
    public final int getDimension() {
        return 2;
    }

    @Override
    public Position getLowerCorner() {
        return new Position2D(this.crs, this.getMinX(), this.getMinY());
    }

    @Override
    public Position getUpperCorner() {
        return new Position2D(this.crs, this.getMaxX(), this.getMaxY());
    }

    private static IndexOutOfBoundsException indexOutOfBounds(int dimension) {
        return new IndexOutOfBoundsException(MessageFormat.format("Index {0} is out of bounds.", dimension));
    }

    @Override
    public final double getMinimum(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw Envelope2DArchived.indexOutOfBounds(dimension);
    }

    @Override
    public final double getMaximum(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw Envelope2DArchived.indexOutOfBounds(dimension);
    }

    @Override
    public final double getMedian(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.getCenterX();
            }
            case 1: {
                return this.getCenterY();
            }
        }
        throw Envelope2DArchived.indexOutOfBounds(dimension);
    }

    @Override
    public final double getSpan(int dimension) throws IndexOutOfBoundsException {
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw Envelope2DArchived.indexOutOfBounds(dimension);
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() ^ 0x6F2121AA;
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem coordinateReferenceSystem;
            if (object instanceof Envelope2DArchived) {
                Envelope2DArchived eda = (Envelope2DArchived)object;
                coordinateReferenceSystem = eda.crs;
            } else {
                coordinateReferenceSystem = null;
            }
            CoordinateReferenceSystem otherCRS = coordinateReferenceSystem;
            return Utilities.equals(this.crs, otherCRS);
        }
        return false;
    }

    public boolean boundsEquals(Bounds that, int xDim, int yDim, double eps) {
        eps *= 0.5 * (this.width + this.height);
        for (int i = 0; i < 4; ++i) {
            double valueND;
            double value2D;
            int dimND;
            int dim2D = i & 1;
            int n = dimND = dim2D == 0 ? xDim : yDim;
            if ((i & 2) == 0) {
                value2D = this.getMinimum(dim2D);
                valueND = that.getMinimum(dimND);
            } else {
                value2D = this.getMaximum(dim2D);
                valueND = that.getMaximum(dimND);
            }
            if (Math.abs(value2D - valueND) <= eps) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return AbstractBounds.toString(this);
    }

    @Override
    public void setBounds(BoundingBox bounds) {
        this.crs = bounds.getCoordinateReferenceSystem();
        this.x = bounds.getMinX();
        this.y = bounds.getMinY();
        this.width = bounds.getWidth();
        this.height = bounds.getHeight();
    }

    @Override
    public void include(BoundingBox bounds) {
        if (this.crs == null) {
            this.crs = bounds.getCoordinateReferenceSystem();
        } else {
            this.ensureCompatibleReferenceSystem(bounds);
        }
        if (bounds.isEmpty()) {
            return;
        }
        if (this.isNull()) {
            this.setBounds(bounds);
        } else {
            if (bounds.getMinX() < this.getMinX()) {
                this.width += this.getMinX() - bounds.getMinX();
                this.x = bounds.getMinX();
            }
            if (bounds.getMaxX() > this.getMaxX()) {
                this.width += bounds.getMaxX() - this.getMaxX();
            }
            if (bounds.getMinY() < this.getMinY()) {
                this.height += this.getMinY() - bounds.getMinY();
                this.y = bounds.getMinY();
            }
            if (bounds.getMaxY() > this.getMaxY()) {
                this.height += bounds.getMaxY() - this.getMaxY();
            }
        }
    }

    @Override
    public void include(double x, double y) {
        if (this.isNull()) {
            this.x = x;
            this.y = y;
            this.width = 0.0;
            this.height = 0.0;
        } else {
            if (x < this.getMinX()) {
                this.width += this.getMinX() - x;
                this.x = x;
            }
            if (x > this.getMaxX()) {
                this.width += x - this.getMaxX();
            }
            if (y < this.getMinY()) {
                this.height += this.getMinY() - y;
                this.y = y;
            }
            if (y > this.getMaxY()) {
                this.height += y - this.getMaxY();
            }
        }
    }

    @Override
    public boolean intersects(BoundingBox bounds) {
        this.ensureCompatibleReferenceSystem(bounds);
        if (this.isNull() || bounds.isEmpty()) {
            return false;
        }
        return !(bounds.getMinX() > this.getMaxX() || bounds.getMaxX() < this.getMinX() || bounds.getMinY() > this.getMaxY() || bounds.getMaxY() < this.getMinY());
    }

    @Override
    public boolean contains(BoundingBox bounds) {
        this.ensureCompatibleReferenceSystem(bounds);
        if (this.isEmpty() || bounds.isEmpty()) {
            return false;
        }
        return bounds.getMinX() >= this.getMinX() && bounds.getMaxX() <= this.getMaxX() && bounds.getMinY() >= this.getMinY() && bounds.getMaxY() <= this.getMaxY();
    }

    @Override
    public boolean contains(Position location) {
        this.ensureCompatibleReferenceSystem(location);
        if (this.isEmpty()) {
            return false;
        }
        return location.getOrdinate(0) >= this.getMinX() && location.getOrdinate(0) <= this.getMaxX() && location.getOrdinate(1) >= this.getMinY() && location.getOrdinate(1) <= this.getMaxY();
    }

    @Override
    public BoundingBox toBounds(CoordinateReferenceSystem targetCRS) throws TransformException {
        GeneralBounds transformed = new GeneralBounds(this);
        transformed = CRS.transform(transformed, targetCRS);
        return new Envelope2DArchived(transformed);
    }

    private void ensureCompatibleReferenceSystem(BoundingBox bbox) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem other;
        if (this.crs != null && (other = bbox.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(this.crs, other)) {
            throw new MismatchedReferenceSystemException("The coordinate reference system must be the same for all objects.");
        }
    }

    private void ensureCompatibleReferenceSystem(Position location) {
        CoordinateReferenceSystem other;
        if (this.crs != null && (other = location.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(this.crs, other)) {
            throw new MismatchedReferenceSystemException("The coordinate reference system must be the same for all objects.");
        }
    }

    private boolean isNull() {
        return this.getMinX() == 0.0 && this.getMinY() == 0.0 && this.getWidth() < 0.0 && this.getHeight() < 0.0;
    }
}

