/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.util.Range;

public class MultiRange<T extends Comparable<? super T>> {
    TreeSet<Range<T>> ranges = new TreeSet(new RangeComparator());

    public MultiRange(Range<T> range) {
        this.ranges.add(range);
    }

    public MultiRange(MultiRange<T> other) {
        this.ranges.addAll(other.ranges);
    }

    public MultiRange(List<Range<T>> ranges) {
        this.ranges.addAll(ranges);
    }

    public MultiRange(Class<T> binding, T exclusion) {
        this.ranges.add(new Range<Object>((Class<Object>)binding, null, false, exclusion, false));
        this.ranges.add(new Range<Object>((Class<Object>)binding, exclusion, false, null, false));
    }

    public MultiRange<T> merge(MultiRange<T> other) {
        MultiRange<T> result = new MultiRange<T>(this);
        for (Range<T> r : other.ranges) {
            result.addRange(r);
        }
        return result;
    }

    public void addRange(Range<T> range) {
        if (range.isEmpty()) {
            return;
        }
        List<Range<T>> overlapping = this.getOverlappingRanges(range);
        if (overlapping != null && !overlapping.isEmpty()) {
            this.ranges.removeAll(overlapping);
            Range<T> combined = range;
            for (Range<T> r : overlapping) {
                Range<T> union = combined.union(r);
                combined = union;
            }
            this.ranges.add(combined);
        } else {
            this.ranges.add(range);
        }
    }

    public MultiRange<T> intersect(MultiRange<T> other) {
        ArrayList<Range<T>> intersections = new ArrayList<Range<T>>();
        for (Range<T> r1 : this.ranges) {
            for (Range<T> r2 : other.ranges) {
                if (!r1.intersects(r2)) continue;
                Range<T> intersection = r1.intersect(r2);
                intersections.add(intersection);
            }
        }
        return new MultiRange<T>(intersections);
    }

    public void removeRange(Range<T> range) {
        List<Range<T>> overlapping = this.getOverlappingRanges(range);
        if (overlapping != null) {
            this.ranges.removeAll(overlapping);
            ArrayList<Range<T>> removed = new ArrayList<Range<T>>();
            for (Range<Object> r : overlapping) {
                Range<T>[] difference;
                for (Range<T> d : difference = r.subtract(range)) {
                    if (d.isEmpty()) continue;
                    removed.add(d);
                }
            }
            for (Range<Object> r : removed) {
                this.ranges.add(r);
            }
        }
    }

    private List<Range<T>> getOverlappingRanges(Range<T> range) {
        ArrayList<Range<T>> overlapping = new ArrayList<Range<T>>();
        for (Range<T> r : this.ranges) {
            if (!r.intersects(range) && !this.contiguous(r, range)) continue;
            overlapping.add(r);
        }
        return overlapping;
    }

    private boolean contiguous(Range r1, Range<T> r2) {
        if (r1.getMinValue() != null && r2.getMaxValue() != null && (r1.isMinIncluded() || r2.isMaxIncluded())) {
            return r1.getMinValue().equals(r2.getMaxValue());
        }
        if (r1.getMaxValue() != null && r2.getMinValue() != null && (r1.isMaxIncluded() || r2.isMinIncluded())) {
            return r1.getMaxValue().equals(r2.getMinValue());
        }
        return false;
    }

    public Filter toFilter(FilterFactory ff, Expression variable) {
        if (this.ranges.isEmpty()) {
            return Filter.EXCLUDE;
        }
        if (this.ranges.size() == 1 && this.ranges.first().getMinValue() == null && this.ranges.first().getMaxValue() == null) {
            return Filter.INCLUDE;
        }
        ArrayList<Range<T>> rangeList = new ArrayList<Range<T>>(this.ranges);
        ArrayList<Filter> filters = new ArrayList<Filter>();
        int rangeCount = rangeList.size();
        int i = 0;
        while (i < rangeCount) {
            Range next;
            Range range = (Range)rangeList.get(i);
            ++i;
            ArrayList exclusions = new ArrayList();
            Range curr = range;
            while (i < rangeCount && (next = (Range)rangeList.get(i)).getMinValue().equals(curr.getMaxValue())) {
                if (!next.isMinIncluded() && !curr.isMaxIncluded()) {
                    exclusions.add(curr.getMaxValue());
                }
                ++i;
                curr = next;
            }
            if (curr == range) {
                filters.add(this.toFilter(ff, variable, range));
                continue;
            }
            Range union = new Range(range.getElementClass(), range.getMinValue(), range.isMinIncluded(), curr.getMaxValue(), curr.isMaxIncluded());
            Filter filter = this.toFilter(ff, variable, union);
            if (exclusions.isEmpty()) {
                filters.add(filter);
                continue;
            }
            ArrayList<Filter> exclusionFilters = new ArrayList<Filter>();
            if (!Filter.INCLUDE.equals(filter)) {
                exclusionFilters.add(filter);
            }
            for (Comparable exclusion : exclusions) {
                PropertyIsNotEqualTo ne = ff.notEqual(variable, ff.literal(exclusion));
                exclusionFilters.add(ne);
            }
            filter = exclusionFilters.size() == 1 ? (Filter)exclusionFilters.get(0) : ff.and(exclusionFilters);
            filters.add(filter);
        }
        if (filters.isEmpty()) {
            return Filter.EXCLUDE;
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return ff.or(filters);
    }

    private Filter toFilter(FilterFactory ff, Expression variable, Range<T> range) {
        if (range.getMinValue() == null && range.getMaxValue() == null) {
            return Filter.INCLUDE;
        }
        if (range.isMinIncluded() && range.isMaxIncluded()) {
            if (range.getMinValue().equals(range.getMaxValue())) {
                return ff.equals(variable, ff.literal(range.getMinValue()));
            }
            return ff.between(variable, ff.literal(range.getMinValue()), ff.literal(range.getMaxValue()));
        }
        if (range.getMinValue() == null) {
            return this.toLessFilter(ff, variable, range);
        }
        if (range.getMaxValue() == null) {
            return this.toGreaterFilter(ff, variable, range);
        }
        Filter less = this.toLessFilter(ff, variable, range);
        Filter greater = this.toGreaterFilter(ff, variable, range);
        return ff.and(greater, less);
    }

    private Filter toGreaterFilter(FilterFactory ff, Expression variable, Range<T> range) {
        if (range.isMinIncluded()) {
            return ff.greaterOrEqual(variable, ff.literal(range.getMinValue()));
        }
        return ff.greater(variable, ff.literal(range.getMinValue()));
    }

    private Filter toLessFilter(FilterFactory ff, Expression variable, Range<T> range) {
        if (range.isMaxIncluded()) {
            return ff.lessOrEqual(variable, ff.literal(range.getMaxValue()));
        }
        return ff.less(variable, ff.literal(range.getMaxValue()));
    }

    public String toString() {
        return "MultiRange [ranges=" + String.valueOf(this.ranges) + "]";
    }

    static final class RangeComparator<T extends Comparable<? super T>>
    implements Comparator<Range<T>> {
        RangeComparator() {
        }

        @Override
        public int compare(Range<T> o1, Range<T> o2) {
            if (o1 == null) {
                return o2 != null ? -1 : 0;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.getMinValue() == null) {
                return o2.getMinValue() == null ? 0 : -1;
            }
            if (o2.getMinValue() == null) {
                return 1;
            }
            return o1.getMinValue().compareTo(o2.getMinValue());
        }
    }
}

