/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Add;
import org.geotools.api.filter.expression.BinaryExpression;
import org.geotools.api.filter.expression.Divide;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Function;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.Multiply;
import org.geotools.api.filter.expression.NilExpression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.expression.Subtract;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.Capabilities;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.util.logging.Logging;

public class CapabilitiesFilterSplitter
implements FilterVisitor,
ExpressionVisitor {
    private static final Logger LOGGER = Logging.getLogger(CapabilitiesFilterSplitter.class);
    private Stack postStack = new Stack();
    private Stack preStack = new Stack();
    private Set changedStack = new HashSet();
    private Capabilities fcs = null;
    private FeatureType parent = null;
    private Filter original = null;
    private ClientTransactionAccessor transactionAccessor;
    private FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);

    public CapabilitiesFilterSplitter(Capabilities fcs, FeatureType parent, ClientTransactionAccessor transactionAccessor) {
        this.fcs = fcs;
        this.parent = parent;
        this.transactionAccessor = transactionAccessor;
    }

    public Filter getFilterPost() {
        if (!this.changedStack.isEmpty()) {
            return this.original;
        }
        if (this.postStack.size() > 1) {
            LOGGER.warning("Too many post stack items after run: " + this.postStack.size());
        }
        IncludeFilter f = this.postStack.isEmpty() ? Filter.INCLUDE : (Filter)this.postStack.peek();
        return f;
    }

    public Filter getFilterPre() {
        Filter deleteFilter;
        Filter f;
        if (this.preStack.isEmpty()) {
            return Filter.INCLUDE;
        }
        if (this.preStack.size() > 1) {
            LOGGER.warning("Too many pre stack items after run: " + this.preStack.size());
        }
        Filter filter = f = this.preStack.isEmpty() ? Filter.INCLUDE : (Filter)this.preStack.peek();
        if (this.transactionAccessor != null && f != null && f != Filter.EXCLUDE && (deleteFilter = this.transactionAccessor.getDeleteFilter()) != null) {
            f = deleteFilter == Filter.EXCLUDE ? Filter.EXCLUDE : this.ff.and(f, this.ff.not(deleteFilter));
        }
        if (this.changedStack.isEmpty()) {
            return f;
        }
        Iterator iter = this.changedStack.iterator();
        Filter updateFilter = (Filter)iter.next();
        while (iter.hasNext()) {
            Filter next = (Filter)iter.next();
            if (next == Filter.INCLUDE) {
                updateFilter = next;
                break;
            }
            updateFilter = this.ff.or(updateFilter, next);
        }
        if (updateFilter == Filter.INCLUDE || f == Filter.INCLUDE) {
            return Filter.INCLUDE;
        }
        return this.ff.or(f, updateFilter);
    }

    public void visit(IncludeFilter filter) {
    }

    public void visit(ExcludeFilter filter) {
        if (this.fcs.supports(Filter.EXCLUDE)) {
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object extradata) {
        if (this.original == null) {
            this.original = filter;
        }
        if (this.fcs.supports(filter)) {
            int i = this.postStack.size();
            Expression lowerBound = filter.getLowerBoundary();
            Expression expr = filter.getExpression();
            Expression upperBound = filter.getUpperBoundary();
            if (lowerBound == null || upperBound == null || expr == null) {
                this.postStack.push(filter);
                return null;
            }
            lowerBound.accept(this, null);
            if (i < this.postStack.size()) {
                this.postStack.pop();
                this.postStack.push(filter);
                return null;
            }
            expr.accept(this, null);
            if (i < this.postStack.size()) {
                this.preStack.pop();
                this.postStack.pop();
                this.postStack.push(filter);
                return null;
            }
            upperBound.accept(this, null);
            if (i < this.postStack.size()) {
                this.postStack.pop();
                this.preStack.pop();
                this.preStack.pop();
                this.postStack.push(filter);
                return null;
            }
            this.preStack.pop();
            this.preStack.pop();
            this.preStack.pop();
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
        return null;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator(filter);
        return null;
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object notUsed) {
        this.visitBinaryComparisonOperator(filter);
        return null;
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator(filter);
        return null;
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object notUsed) {
        this.visitBinaryComparisonOperator(filter);
        return null;
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator(filter);
        return null;
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object notUsed) {
        this.visitBinaryComparisonOperator(filter);
        return null;
    }

    private void visitBinaryOperator(Filter filter, Expression leftValue, Expression rightValue) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(filter)) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(filter);
            return;
        }
        leftValue.accept(this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        rightValue.accept(this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
    }

    private void visitBinaryComparisonOperator(BinaryComparisonOperator filter) {
        this.visitBinaryOperator(filter, filter.getExpression1(), filter.getExpression2());
    }

    @Override
    public Object visit(BBOX filter, Object notUsed) {
        if (!this.fcs.supports(filter)) {
            this.postStack.push(filter);
        } else {
            this.preStack.push(filter);
        }
        return null;
    }

    @Override
    public Object visit(Beyond filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(Contains filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(Crosses filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(Disjoint filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(DWithin filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(Equals filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(Intersects filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(Overlaps filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(Touches filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    @Override
    public Object visit(Within filter, Object notUsed) {
        this.visitBinarySpatialOperator(filter);
        return null;
    }

    private void visitBinarySpatialOperator(BinarySpatialOperator filter) {
        Class[] spatialOps;
        if (this.original == null) {
            this.original = filter;
        }
        for (Class spatialOp : spatialOps = new Class[]{Beyond.class, Contains.class, Crosses.class, Disjoint.class, DWithin.class, Equals.class, Intersects.class, Overlaps.class, Touches.class, Within.class}) {
            if (!spatialOp.isAssignableFrom(filter.getClass())) continue;
            if (this.fcs.supports(filter)) break;
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        Expression leftGeometry = filter.getExpression1();
        Expression rightGeometry = filter.getExpression2();
        if (leftGeometry == null || rightGeometry == null) {
            this.postStack.push(filter);
            return;
        }
        leftGeometry.accept(this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        rightGeometry.accept(this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
    }

    @Override
    public Object visit(PropertyIsLike filter, Object notUsed) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(filter)) {
            this.postStack.push(filter);
            return null;
        }
        int i = this.postStack.size();
        filter.getExpression().accept(this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return null;
        }
        this.preStack.pop();
        this.preStack.push(filter);
        return null;
    }

    @Override
    public Object visit(And filter, Object notUsed) {
        this.visitLogicOperator(filter);
        return null;
    }

    @Override
    public Object visit(Not filter, Object notUsed) {
        this.visitLogicOperator(filter);
        return null;
    }

    @Override
    public Object visit(Or filter, Object notUsed) {
        this.visitLogicOperator(filter);
        return null;
    }

    private void visitLogicOperator(Filter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(filter)) {
            if (filter instanceof And) {
                And and = (And)filter;
                Iterator<Filter> it = and.getChildren().iterator();
                Filter supportedChild = null;
                ArrayList<Filter> otherChildren = new ArrayList<Filter>();
                while (it.hasNext()) {
                    Filter child = it.next();
                    if (supportedChild == null && this.fcs.supports(child)) {
                        supportedChild = child;
                        continue;
                    }
                    otherChildren.add(child);
                }
                if (supportedChild == null) {
                    this.postStack.push(filter);
                    return;
                }
                this.preStack.push(supportedChild);
                if (otherChildren.size() == 1) {
                    this.postStack.push(otherChildren.get(0));
                } else {
                    this.postStack.push(this.ff.and(otherChildren));
                }
                return;
            }
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        int j = this.preStack.size();
        if (filter instanceof Not) {
            Not not = (Not)filter;
            if (not.getFilter() != null) {
                Filter next = not.getFilter();
                next.accept(this, null);
                if (i < this.postStack.size()) {
                    this.popToSize(this.postStack, i);
                    this.popToSize(this.preStack, j);
                    this.postStack.push(filter);
                } else {
                    this.popToSize(this.preStack, j);
                    this.preStack.push(filter);
                }
            }
        } else if (filter instanceof Or) {
            Or or = (Or)filter;
            try {
                Filter orReplacement = this.translateOr(or);
                orReplacement.accept(this, null);
            }
            catch (IllegalFilterException e) {
                this.popToSize(this.preStack, j);
                this.postStack.push(filter);
                return;
            }
            if (this.postStack.size() > i) {
                this.popToSize(this.postStack, i);
                this.postStack.push(filter);
                return;
            }
            this.preStack.pop();
            this.preStack.push(filter);
        } else {
            for (Filter next : ((And)filter).getChildren()) {
                next.accept(this, null);
            }
            if (i < this.postStack.size()) {
                if (filter instanceof And) {
                    Filter f = (Filter)this.postStack.pop();
                    while (this.postStack.size() > i) {
                        f = this.ff.and(f, (Filter)this.postStack.pop());
                    }
                    this.postStack.push(f);
                    if (j < this.preStack.size()) {
                        f = (Filter)this.preStack.pop();
                        while (this.preStack.size() > j) {
                            f = this.ff.and(f, (Filter)this.preStack.pop());
                        }
                        this.preStack.push(f);
                    }
                } else {
                    LOGGER.warning("LogicFilter found which is not 'and, or, not");
                    this.popToSize(this.postStack, i);
                    this.popToSize(this.preStack, j);
                    this.postStack.push(filter);
                }
            } else {
                this.popToSize(this.preStack, j);
                this.preStack.push(filter);
            }
        }
    }

    private void popToSize(Stack stack, int j) {
        while (j < stack.size()) {
            stack.pop();
        }
    }

    @Override
    public Object visitNullFilter(Object notUsed) {
        return null;
    }

    @Override
    public Object visit(IncludeFilter filter, Object notUsed) {
        return null;
    }

    @Override
    public Object visit(ExcludeFilter filter, Object notUsed) {
        if (this.fcs.supports(Filter.EXCLUDE)) {
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
        return null;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object notUsed) {
        return this.visitNullNil(filter, filter.getExpression());
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.visitNullNil(filter, filter.getExpression());
    }

    Object visitNullNil(Filter filter, Expression e) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(filter)) {
            this.postStack.push(filter);
            return null;
        }
        int i = this.postStack.size();
        ((PropertyIsNull)filter).getExpression().accept(this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return null;
        }
        this.preStack.pop();
        this.preStack.push(filter);
        return null;
    }

    @Override
    public Object visit(Id filter, Object notUsed) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(filter)) {
            this.postStack.push(filter);
        } else {
            this.preStack.push(filter);
        }
        return null;
    }

    @Override
    public Object visit(PropertyName expression, Object notUsed) {
        if (this.parent != null && expression.evaluate(this.parent) == null) {
            throw new IllegalArgumentException("Property '" + expression.getPropertyName() + "' could not be found in " + String.valueOf(this.parent.getName()));
        }
        if (this.transactionAccessor != null) {
            Filter updateFilter = this.transactionAccessor.getUpdateFilter(expression.getPropertyName());
            if (updateFilter != null) {
                if (updateFilter == Filter.EXCLUDE) {
                    this.postStack.push(expression);
                } else {
                    this.changedStack.add(updateFilter);
                    this.preStack.push(updateFilter);
                }
            } else {
                this.preStack.push(expression);
            }
        } else {
            this.preStack.push(expression);
        }
        return null;
    }

    @Override
    public Object visit(Literal expression, Object notUsed) {
        this.preStack.push(expression);
        return null;
    }

    @Override
    public Object visit(Add filter, Object notUsed) {
        this.visitMathExpression(filter);
        return null;
    }

    @Override
    public Object visit(Divide filter, Object notUsed) {
        this.visitMathExpression(filter);
        return null;
    }

    @Override
    public Object visit(Multiply filter, Object notUsed) {
        this.visitMathExpression(filter);
        return null;
    }

    @Override
    public Object visit(Subtract filter, Object notUsed) {
        this.visitMathExpression(filter);
        return null;
    }

    private void visitMathExpression(BinaryExpression expression) {
        if (!this.fcs.fullySupports(expression)) {
            this.postStack.push(expression);
            return;
        }
        int i = this.postStack.size();
        Expression leftValue = expression.getExpression1();
        Expression rightValue = expression.getExpression2();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(expression);
            return;
        }
        leftValue.accept(this, null);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        rightValue.accept(this, null);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(expression);
    }

    @Override
    public Object visit(Function function, Object notUsed) {
        if (!this.fcs.fullySupports(function)) {
            this.postStack.push(function);
            return null;
        }
        if (function.getName() == null) {
            this.postStack.push(function);
            return null;
        }
        int postSize = this.postStack.size();
        int preSize = this.preStack.size();
        List<Expression> parameters = function.getParameters();
        for (Expression param : parameters) {
            param.accept(this, null);
            if (postSize >= this.postStack.size()) continue;
            while (preSize < this.preStack.size()) {
                this.preStack.pop();
            }
            this.postStack.pop();
            this.postStack.push(function);
            return null;
        }
        while (preSize < this.preStack.size()) {
            this.preStack.pop();
        }
        this.preStack.push(function);
        return null;
    }

    @Override
    public Object visit(NilExpression nilExpression, Object notUsed) {
        this.postStack.push(nilExpression);
        return null;
    }

    private Filter translateOr(Or filter) throws IllegalFilterException {
        if (filter == null) {
            return null;
        }
        Iterator<Filter> i = filter.getChildren().iterator();
        ArrayList<Filter> translated = new ArrayList<Filter>();
        while (i.hasNext()) {
            Filter f = i.next();
            if (f instanceof Not) {
                Not logic = (Not)f;
                Filter next = logic.getFilter();
                translated.add(next);
                continue;
            }
            translated.add(this.ff.not(f));
        }
        And and = this.ff.and(translated);
        return this.ff.not(and);
    }

    @Override
    public Object visit(After after, Object extraData) {
        return this.visit((BinaryTemporalOperator)after, extraData);
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visit((BinaryTemporalOperator)anyInteracts, extraData);
    }

    @Override
    public Object visit(Before before, Object extraData) {
        return this.visit((BinaryTemporalOperator)before, extraData);
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        return this.visit((BinaryTemporalOperator)begins, extraData);
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)begunBy, extraData);
    }

    @Override
    public Object visit(During during, Object extraData) {
        return this.visit((BinaryTemporalOperator)during, extraData);
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)endedBy, extraData);
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        return this.visit((BinaryTemporalOperator)ends, extraData);
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        return this.visit((BinaryTemporalOperator)meets, extraData);
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)metBy, extraData);
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)overlappedBy, extraData);
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        return this.visit((BinaryTemporalOperator)equals, extraData);
    }

    @Override
    public Object visit(TOverlaps contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        this.visitBinaryOperator(filter, filter.getExpression1(), filter.getExpression2());
        return null;
    }

    @Override
    public Object visit(NativeFilter filter, Object extraData) {
        this.preStack.push(filter);
        return null;
    }
}

