/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import org.geotools.api.filter.And;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.ExcludeFilter;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Id;
import org.geotools.api.filter.IncludeFilter;
import org.geotools.api.filter.NativeFilter;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.Or;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.PropertyIsGreaterThan;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThan;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNil;
import org.geotools.api.filter.PropertyIsNotEqualTo;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.Contains;
import org.geotools.api.filter.spatial.Crosses;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.Disjoint;
import org.geotools.api.filter.spatial.Equals;
import org.geotools.api.filter.spatial.Intersects;
import org.geotools.api.filter.spatial.Overlaps;
import org.geotools.api.filter.spatial.Touches;
import org.geotools.api.filter.spatial.Within;
import org.geotools.api.filter.temporal.After;
import org.geotools.api.filter.temporal.AnyInteracts;
import org.geotools.api.filter.temporal.Before;
import org.geotools.api.filter.temporal.Begins;
import org.geotools.api.filter.temporal.BegunBy;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.filter.temporal.EndedBy;
import org.geotools.api.filter.temporal.Ends;
import org.geotools.api.filter.temporal.Meets;
import org.geotools.api.filter.temporal.MetBy;
import org.geotools.api.filter.temporal.OverlappedBy;
import org.geotools.api.filter.temporal.TContains;
import org.geotools.api.filter.temporal.TEquals;
import org.geotools.api.filter.temporal.TOverlaps;
import org.geotools.filter.visitor.NullExpressionVisitor;

public class AbstractFilterVisitor
implements FilterVisitor {
    private ExpressionVisitor expressionVisitor;

    public AbstractFilterVisitor() {
        this(new NullExpressionVisitor());
    }

    public AbstractFilterVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public Object visit(IncludeFilter filter, Object data) {
        return data;
    }

    @Override
    public Object visit(ExcludeFilter filter, Object data) {
        return data;
    }

    @Override
    public Object visitNullFilter(Object data) {
        return null;
    }

    @Override
    public Object visit(PropertyIsBetween filter, Object data) {
        if (filter.getLowerBoundary() != null) {
            filter.getLowerBoundary().accept(this.expressionVisitor, data);
        }
        if (filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, data);
        }
        if (filter.getUpperBoundary() != null) {
            filter.getUpperBoundary().accept(this.expressionVisitor, data);
        }
        return filter;
    }

    protected Object visit(BinaryComparisonOperator filter, Object data) {
        if (this.expressionVisitor != null) {
            if (filter.getExpression1() != null) {
                filter.getExpression1().accept(this.expressionVisitor, data);
            }
            if (filter.getExpression2() != null) {
                filter.getExpression2().accept(this.expressionVisitor, data);
            }
        }
        return filter;
    }

    @Override
    public Object visit(PropertyIsEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsNotEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsLessThan filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsLessThanOrEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsGreaterThan filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsGreaterThanOrEqualTo filter, Object data) {
        return this.visit((BinaryComparisonOperator)filter, data);
    }

    @Override
    public Object visit(BBOX filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    protected Object visit(BinarySpatialOperator filter, Object data) {
        if (this.expressionVisitor != null) {
            if (filter.getExpression1() != null) {
                filter.getExpression1().accept(this.expressionVisitor, data);
            }
            if (filter.getExpression2() != null) {
                filter.getExpression2().accept(this.expressionVisitor, data);
            }
        }
        return filter;
    }

    @Override
    public Object visit(Beyond filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Contains filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Crosses filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Disjoint filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(DWithin filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Equals filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Intersects filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Overlaps filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Touches filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(Within filter, Object data) {
        return this.visit((BinarySpatialOperator)filter, data);
    }

    @Override
    public Object visit(PropertyIsLike filter, Object data) {
        if (this.expressionVisitor != null && filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, null);
        }
        return filter;
    }

    protected Object visit(BinaryLogicOperator filter, Object data) {
        if (filter.getChildren() != null) {
            for (Filter child : filter.getChildren()) {
                child.accept(this, data);
            }
        }
        return filter;
    }

    @Override
    public Object visit(And filter, Object data) {
        return this.visit((BinaryLogicOperator)filter, data);
    }

    @Override
    public Object visit(Or filter, Object data) {
        return this.visit((BinaryLogicOperator)filter, data);
    }

    @Override
    public Object visit(Not filter, Object data) {
        if (filter.getFilter() != null) {
            filter.getFilter().accept(this, data);
        }
        return filter;
    }

    @Override
    public Object visit(PropertyIsNull filter, Object data) {
        if (this.expressionVisitor != null && filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, data);
        }
        return filter;
    }

    @Override
    public Object visit(PropertyIsNil filter, Object extraData) {
        if (this.expressionVisitor != null && filter.getExpression() != null) {
            filter.getExpression().accept(this.expressionVisitor, extraData);
        }
        return filter;
    }

    @Override
    public Object visit(Id filter, Object data) {
        return filter;
    }

    @Override
    public Object visit(After after, Object extraData) {
        return this.visit((BinaryTemporalOperator)after, extraData);
    }

    @Override
    public Object visit(AnyInteracts anyInteracts, Object extraData) {
        return this.visit((BinaryTemporalOperator)anyInteracts, extraData);
    }

    @Override
    public Object visit(Before before, Object extraData) {
        return this.visit((BinaryTemporalOperator)before, extraData);
    }

    @Override
    public Object visit(Begins begins, Object extraData) {
        return this.visit((BinaryTemporalOperator)begins, extraData);
    }

    @Override
    public Object visit(BegunBy begunBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)begunBy, extraData);
    }

    @Override
    public Object visit(During during, Object extraData) {
        return this.visit((BinaryTemporalOperator)during, extraData);
    }

    @Override
    public Object visit(EndedBy endedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)endedBy, extraData);
    }

    @Override
    public Object visit(Ends ends, Object extraData) {
        return this.visit((BinaryTemporalOperator)ends, extraData);
    }

    @Override
    public Object visit(Meets meets, Object extraData) {
        return this.visit((BinaryTemporalOperator)meets, extraData);
    }

    @Override
    public Object visit(MetBy metBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)metBy, extraData);
    }

    @Override
    public Object visit(OverlappedBy overlappedBy, Object extraData) {
        return this.visit((BinaryTemporalOperator)overlappedBy, extraData);
    }

    @Override
    public Object visit(TContains contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    @Override
    public Object visit(TEquals equals, Object extraData) {
        return this.visit((BinaryTemporalOperator)equals, extraData);
    }

    @Override
    public Object visit(TOverlaps contains, Object extraData) {
        return this.visit((BinaryTemporalOperator)contains, extraData);
    }

    protected Object visit(BinaryTemporalOperator filter, Object data) {
        if (this.expressionVisitor != null) {
            if (filter.getExpression1() != null) {
                filter.getExpression1().accept(this.expressionVisitor, data);
            }
            if (filter.getExpression2() != null) {
                filter.getExpression2().accept(this.expressionVisitor, data);
            }
        }
        return filter;
    }

    public String toString() {
        String name = this.getClass().getSimpleName();
        return "AbstractFilterVisitor " + name + " [expressionVisitor=" + String.valueOf(this.expressionVisitor) + "]";
    }

    @Override
    public Object visit(NativeFilter filter, Object extraData) {
        return filter;
    }
}

