/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX3D;
import org.geotools.api.geometry.BoundingBox3D;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.util.Converters;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class BBOX3DImpl
implements BBOX3D {
    PropertyName property;
    ReferencedEnvelope3D envelope;
    FilterFactory factory;

    public BBOX3DImpl(PropertyName propertyName, ReferencedEnvelope3D env, FilterFactory factory) {
        this.property = propertyName;
        this.envelope = env;
        this.factory = factory;
    }

    public PropertyName getProperty() {
        return this.property;
    }

    public String getPropertyName() {
        return this.property.getPropertyName();
    }

    @Override
    public BoundingBox3D getBounds() {
        return this.envelope;
    }

    @Override
    public Expression getExpression1() {
        return this.property;
    }

    @Override
    public Expression getExpression2() {
        return this.factory.literal(this.envelope);
    }

    @Override
    public Object accept(FilterVisitor visitor, Object context) {
        return visitor.visit(this, context);
    }

    public ReferencedEnvelope3D get3DEnvelope(Geometry geom) {
        Coordinate[] coordinates = geom.getCoordinates();
        ReferencedEnvelope3D env = new ReferencedEnvelope3D();
        for (Coordinate coordinate : coordinates) {
            env.expandToInclude(coordinate);
        }
        return env;
    }

    @Override
    public boolean evaluate(Object feature) {
        Geometry other = Converters.convert(this.property.evaluate(feature), Geometry.class);
        if (other == null) {
            return false;
        }
        return this.get3DEnvelope(other).intersects(this.envelope);
    }

    public boolean isMatchingCase() {
        return false;
    }

    public boolean contains(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    public boolean evaluate(SimpleFeature feature) {
        return this.evaluate((Object)feature);
    }

    @Override
    public MultiValuedFilter.MatchAction getMatchAction() {
        return MultiValuedFilter.MatchAction.ANY;
    }

    public String toString() {
        return "BBOX3D [property=" + String.valueOf(this.property) + ", envelope=" + String.valueOf(this.envelope) + "]";
    }
}

