/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Arrays;
import java.util.logging.Level;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.RangedClassifier;

public class StandardDeviationFunction
extends ClassificationFunction {
    public static FunctionName NAME = new FunctionNameImpl("StandardDeviation", RangedClassifier.class, FunctionNameImpl.parameter("value", Double.class), FunctionNameImpl.parameter("classes", Integer.class), FunctionNameImpl.parameter("percentages", Boolean.class, 0, 1));

    public StandardDeviationFunction() {
        super(NAME);
    }

    private Object calculate(SimpleFeatureCollection featureCollection) {
        try {
            int classNum = this.getClasses();
            StandardDeviationVisitor sdVisit = new StandardDeviationVisitor(this.getParameters().get(0));
            featureCollection.accepts(sdVisit, this.progress);
            if (this.progress != null && this.progress.isCanceled()) {
                return null;
            }
            CalcResult calcResult = sdVisit.getResult();
            if (calcResult == null) {
                return null;
            }
            double standardDeviation = calcResult.toDouble();
            if (standardDeviation == 0.0) {
                return new RangedClassifier(new Comparable[]{Double.valueOf(sdVisit.getMean())}, new Comparable[]{Double.valueOf(sdVisit.getMean())});
            }
            Comparable[] min = new Double[classNum];
            Comparable[] max = new Double[classNum];
            for (int i = 0; i < classNum; ++i) {
                min[i] = this.getMin(i, classNum, sdVisit.getMean(), standardDeviation);
                max[i] = this.getMax(i, classNum, sdVisit.getMean(), standardDeviation);
            }
            RangedClassifier classifier = new RangedClassifier(min, max);
            if (this.percentages()) {
                double[] percentages = this.getPercentages(featureCollection, classifier, this.getParameters().get(0), standardDeviation);
                classifier.setPercentages(percentages);
            }
            return classifier;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "StandardDeviationFunction calculate failed", e);
            return null;
        }
    }

    @Override
    public Object evaluate(Object feature) {
        if (!(feature instanceof FeatureCollection)) {
            return null;
        }
        return this.calculate((SimpleFeatureCollection)feature);
    }

    private Double getMin(int index, int numClasses, double average, double standardDeviation) {
        if (index <= 0 || index >= numClasses) {
            return null;
        }
        return average - ((double)numClasses / 2.0 - (double)index) * standardDeviation;
    }

    private Double getMax(int index, int numClasses, double average, double standardDeviation) {
        if (index < 0 || index >= numClasses - 1) {
            return null;
        }
        return average - ((double)numClasses / 2.0 - 1.0 - (double)index) * standardDeviation;
    }

    private double[] getPercentages(FeatureCollection features, RangedClassifier classifier, Expression attr, double standardDeviation) throws IOException {
        int classSize = classifier.getSize();
        Object firstMax = classifier.getMax(0);
        int totalSize = features.size();
        PropertyIsGreaterThanOrEqualTo greaterThanOrEqualTo = FF.greaterOrEqual(attr, FF.literal(firstMax));
        FeatureCollection subCollection = features.subCollection(greaterThanOrEqualTo);
        int sizeFirstClass = totalSize - subCollection.size();
        double[] percentages = new double[classSize];
        percentages[0] = (double)sizeFirstClass / (double)totalSize * 100.0;
        double min = ((Number)classifier.getMin(1)).doubleValue();
        percentages = this.computeGroupByPercentages(subCollection, percentages, totalSize, min, standardDeviation);
        this.computeLastPercentage(percentages);
        return percentages;
    }

    private void computeLastPercentage(double[] percentages) {
        double sum = Arrays.stream(percentages).sum();
        percentages[percentages.length - 1] = 100.0 - sum;
    }

    @Override
    protected void computePercentage(double[] percentages, double classMembers, double totalSize, int index) {
        if (++index < percentages.length - 1) {
            percentages[index] = classMembers / totalSize * 100.0;
        }
    }

    protected boolean percentages() {
        boolean percentages = false;
        if (this.getParameters().size() > 2) {
            Literal literal = (Literal)this.getParameters().get(2);
            percentages = (Boolean)literal.getValue();
        }
        return percentages;
    }
}

