/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;

public class PropertyExistsFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("PropertyExists", FunctionNameImpl.parameter("exists", Boolean.class), FunctionNameImpl.parameter("propertyName", Object.class));

    public PropertyExistsFunction() {
        super(NAME);
    }

    private String getPropertyName() {
        Expression expr = this.getParameters().get(0);
        return this.getPropertyName(expr);
    }

    private String getPropertyName(Expression expr) {
        String propertyName;
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            propertyName = String.valueOf(literal.getValue());
        } else if (expr instanceof PropertyName) {
            PropertyName propertyName1 = (PropertyName)expr;
            propertyName = propertyName1.getPropertyName();
        } else {
            throw new IllegalStateException("Not a property name expression: " + String.valueOf(expr));
        }
        return propertyName;
    }

    public Object evaluate(SimpleFeature feature) {
        String propName = this.getPropertyName();
        AttributeDescriptor attributeType = feature.getFeatureType().getDescriptor(propName);
        return attributeType != null;
    }

    @Override
    public Object evaluate(Object bean) {
        if (bean instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)bean;
            return this.evaluate(feature);
        }
        String propName = this.getPropertyName();
        try {
            Class<?> type = bean.getClass();
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                if (!descriptor.getName().equals(propName)) continue;
                if (descriptor.getReadMethod() != null) {
                    return true;
                }
                return false;
            }
        }
        catch (IntrospectionException introspectionException) {
            // empty catch block
        }
        return false;
    }
}

