/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.api.filter.capability.FunctionName;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.LineString;

public class FilterFunction_endAngle
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("endAngle", Double.class, FunctionNameImpl.parameter("linestring", LineString.class));

    public FilterFunction_endAngle() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        LineString ls;
        try {
            ls = this.getExpression(0).evaluate(feature, LineString.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function endPoint argument #0 - expected type Geometry");
        }
        if (ls == null || ls.getNumPoints() == 1) {
            return null;
        }
        CoordinateSequence cs = ls.getCoordinateSequence();
        double dx = cs.getX(cs.size() - 1) - cs.getX(cs.size() - 2);
        double dy = cs.getY(cs.size() - 1) - cs.getY(cs.size() - 2);
        return -Math.toDegrees(Math.atan2(dy, dx));
    }
}

