/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Date;
import java.util.logging.Logger;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.BinaryComparisonAbstract;
import org.geotools.filter.IsEqualsToImpl;
import org.geotools.filter.IsGreaterThanImpl;
import org.geotools.filter.IsGreaterThanOrEqualToImpl;
import org.geotools.filter.IsLessThenImpl;
import org.geotools.filter.IsNilImpl;
import org.geotools.filter.IsNotEqualToImpl;
import org.geotools.filter.IsNullImpl;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public abstract class CompareFilterImpl
extends BinaryComparisonAbstract {
    static final Logger LOGGER = Logging.getLogger(CompareFilterImpl.class);

    protected CompareFilterImpl(Expression e1, Expression e2) {
        this(e1, e2, true);
    }

    protected CompareFilterImpl(Expression e1, Expression e2, boolean matchCase) {
        super(e1, e2, matchCase);
    }

    @Override
    public void setExpression1(Expression leftValue) {
        this.expression1 = leftValue;
    }

    @Override
    public void setExpression2(Expression rightValue) {
        this.expression2 = rightValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int compare(Comparable leftObj, Comparable rightObj) {
        double right;
        if (leftObj == null) throw new NullPointerException("Left and right objects are meant to be non null)");
        if (rightObj == null) {
            throw new NullPointerException("Left and right objects are meant to be non null)");
        }
        if (!(leftObj instanceof Number) || !(rightObj instanceof Number)) {
            if (leftObj.getClass() != rightObj.getClass()) {
                if (leftObj instanceof Date || rightObj instanceof Date) {
                    Date leftConverted = null;
                    Date rightConverted = null;
                    if (!(leftObj instanceof Date)) {
                        leftConverted = Converters.convert(leftObj, Date.class);
                    }
                    if (!(rightObj instanceof Date)) {
                        rightConverted = Converters.convert(rightObj, Date.class);
                    }
                    if (leftConverted != null && rightConverted != null) {
                        leftObj = leftConverted;
                        rightObj = rightConverted;
                        return leftObj.compareTo(rightObj);
                    }
                    leftObj = leftObj.toString();
                    rightObj = rightObj.toString();
                    return leftObj.compareTo(rightObj);
                }
                if (leftObj instanceof Number) {
                    Number number1 = (Number)leftObj;
                    if (rightObj.getClass() == String.class) {
                        try {
                            rightObj = Double.parseDouble((String)rightObj);
                            leftObj = number1.doubleValue();
                            return leftObj.compareTo(rightObj);
                        }
                        catch (Exception e) {
                            leftObj = leftObj.toString();
                            rightObj = rightObj.toString();
                            return leftObj.compareTo(rightObj);
                        }
                    }
                }
                if (leftObj.getClass() == String.class && rightObj instanceof Number) {
                    Number number = (Number)rightObj;
                    try {
                        leftObj = Double.parseDouble((String)leftObj);
                        rightObj = number.doubleValue();
                        return leftObj.compareTo(rightObj);
                    }
                    catch (Exception e) {
                        leftObj = leftObj.toString();
                        rightObj = rightObj.toString();
                        return leftObj.compareTo(rightObj);
                    }
                }
                leftObj = leftObj.toString();
                rightObj = rightObj.toString();
                return leftObj.compareTo(rightObj);
            }
            if (!(leftObj instanceof String)) return leftObj.compareTo(rightObj);
            String string = (String)leftObj;
            if (!(rightObj instanceof String)) return leftObj.compareTo(rightObj);
            String string1 = (String)rightObj;
            try {
                leftObj = Double.parseDouble(string);
                rightObj = Double.parseDouble(string1);
                return leftObj.compareTo(rightObj);
            }
            catch (Exception e) {
                leftObj = leftObj.toString();
                rightObj = rightObj.toString();
            }
            return leftObj.compareTo(rightObj);
        }
        double left = ((Number)leftObj).doubleValue();
        if (left > (right = ((Number)rightObj).doubleValue())) {
            return 1;
        }
        if (left != right) return -1;
        return 0;
    }

    public String toString() {
        if (this instanceof IsNullImpl) {
            return "[ " + String.valueOf(this.expression1) + " IS NULL ]";
        }
        if (this instanceof IsNilImpl) {
            return "[ " + String.valueOf(this.expression1) + " IS NIL ]";
        }
        String operator2 = null;
        if (this instanceof IsEqualsToImpl) {
            operator2 = " = ";
        } else if (this instanceof IsLessThenImpl) {
            operator2 = " < ";
        } else if (this instanceof IsGreaterThanImpl) {
            operator2 = " > ";
        } else if (this instanceof PropertyIsLessThanOrEqualTo) {
            operator2 = " <= ";
        } else if (this instanceof IsGreaterThanOrEqualToImpl) {
            operator2 = " >= ";
        } else if (this instanceof IsNotEqualToImpl) {
            operator2 = " != ";
        }
        return "[ " + String.valueOf(this.expression1) + operator2 + String.valueOf(this.expression2) + " ]";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            CompareFilterImpl cFilter = (CompareFilterImpl)obj;
            Expression cfe1 = cFilter.getExpression1();
            Expression cfe2 = cFilter.getExpression2();
            return (this.expression1 == cfe1 || this.expression1 != null && this.expression1.equals(cfe1)) && (this.expression2 == cfe2 || this.expression2 != null && this.expression2.equals(cfe2));
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getClass().hashCode();
        result = 37 * result + (this.expression1 == null ? 0 : this.expression1.hashCode());
        result = 37 * result + (this.expression2 == null ? 0 : this.expression2.hashCode());
        return result;
    }

    @Override
    public abstract Object accept(FilterVisitor var1, Object var2);
}

