/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.api.filter.MultiValuedFilter;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.spatial.Beyond;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.filter.GeometryFilterImpl;

public abstract class CartesianDistanceFilter
extends GeometryFilterImpl
implements DistanceBufferOperator {
    private double distance;
    private String units;

    protected CartesianDistanceFilter(Expression e1, Expression e2) {
        super(e1, e2);
    }

    protected CartesianDistanceFilter(Expression e1, Expression e2, MultiValuedFilter.MatchAction matchAction) {
        super(e1, e2, matchAction);
    }

    public void setDistance(double distance) {
        this.distance = distance;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public String getDistanceUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    @Override
    public String toString() {
        String operator2 = null;
        if (this instanceof Beyond) {
            operator2 = " beyond ";
        } else if (this instanceof DWithin) {
            operator2 = " dwithin ";
        }
        String distStr = ", distance: " + this.distance;
        Expression leftGeometry = this.getExpression1();
        Expression rightGeometry = this.getExpression2();
        if (leftGeometry == null && rightGeometry == null) {
            return "[ null" + operator2 + "null" + distStr + " ]";
        }
        if (leftGeometry == null) {
            return "[ null" + operator2 + rightGeometry.toString() + distStr + " ]";
        }
        if (rightGeometry == null) {
            return "[ " + leftGeometry.toString() + operator2 + "null" + distStr + " ]";
        }
        return "[ " + leftGeometry.toString() + operator2 + rightGeometry.toString() + distStr + " ]";
    }

    @Override
    public boolean equals(Object oFilter) {
        return super.equals(oFilter) && this.distance == ((CartesianDistanceFilter)oFilter).distance;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long bits = Double.doubleToLongBits(this.distance);
        result = 37 * result + (int)(bits ^ bits >>> 32);
        return result;
    }
}

