/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

public class AreaFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("Area", FunctionNameImpl.parameter("area", Double.class), FunctionNameImpl.parameter("geometry", Geometry.class));

    public AreaFunction() {
        super(NAME);
    }

    @Override
    public Object evaluate(Object feature) {
        Expression geom = this.getParameters().get(0);
        Geometry g = (Geometry)geom.evaluate(feature);
        return this.getArea(g);
    }

    protected double getArea(GeometryCollection geometryCollection1) {
        double area = 0.0;
        int numberOfGeometries1 = geometryCollection1.getNumGeometries();
        for (int i = 0; i < numberOfGeometries1; ++i) {
            area += this.getArea(geometryCollection1.getGeometryN(i));
        }
        return area;
    }

    protected double getPerimeter(GeometryCollection geometryCollection) {
        double perimeter = 0.0;
        int numberOfGeometries = geometryCollection.getNumGeometries();
        for (int i = 0; i < numberOfGeometries; ++i) {
            perimeter += this.getPerimeter(geometryCollection.getGeometryN(i));
        }
        return perimeter;
    }

    public double getArea(Geometry geometry) {
        double area = 0.0;
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            area += this.getArea(collection);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon polygon1 = (MultiPolygon)geometry;
            area += this.getArea(polygon1);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            area += this.getArea(polygon);
        } else {
            area += 0.0;
        }
        return area;
    }

    public double getPerimeter(Geometry geometry) {
        double perimeter = 0.0;
        if (geometry instanceof GeometryCollection) {
            GeometryCollection collection = (GeometryCollection)geometry;
            perimeter += this.getPerimeter(collection);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon polygon1 = (MultiPolygon)geometry;
            perimeter += this.getPerimeter(polygon1);
        } else if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            perimeter += this.getPerimeter(polygon);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString string1 = (MultiLineString)geometry;
            perimeter += this.getPerimeter(string1);
        } else if (geometry instanceof LineString) {
            LineString string = (LineString)geometry;
            perimeter += this.getPerimeter(string);
        } else {
            perimeter += 0.0;
        }
        return perimeter;
    }

    protected double getArea(MultiPolygon multiPolygon) {
        double area = 0.0;
        int numberOfGeometries = multiPolygon.getNumGeometries();
        for (int i = 0; i < numberOfGeometries; ++i) {
            area += this.getArea(multiPolygon.getGeometryN(i));
        }
        return area;
    }

    protected double getperimeter(MultiPolygon multiPolygon) {
        double perimeter = 0.0;
        int numberOfGeometries = multiPolygon.getNumGeometries();
        for (int i = 0; i < numberOfGeometries; ++i) {
            perimeter += this.getPerimeter(multiPolygon.getGeometryN(i));
        }
        return perimeter;
    }

    protected double getArea(Polygon polygon) {
        double area = 0.0;
        double interiorArea = 0.0;
        Coordinate[] exteriorRingCoordinates = polygon.getExteriorRing().getCoordinates();
        int numberOfExteriorRingCoordinates = exteriorRingCoordinates.length;
        double minx = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (Coordinate exteriorRingCoordinate : exteriorRingCoordinates) {
            minx = Math.min(minx, exteriorRingCoordinate.x);
            maxx = Math.max(maxx, exteriorRingCoordinate.x);
            miny = Math.min(miny, exteriorRingCoordinate.y);
            maxy = Math.max(maxy, exteriorRingCoordinate.y);
        }
        for (int i = 0; i < numberOfExteriorRingCoordinates - 1; ++i) {
            area += (exteriorRingCoordinates[i + 1].x - minx - (exteriorRingCoordinates[i].x - minx)) * ((exteriorRingCoordinates[i + 1].y - miny + (exteriorRingCoordinates[i].y - miny)) / 2.0);
        }
        area = Math.abs(area);
        int numberOfInteriorRings = polygon.getNumInteriorRing();
        for (int i = 0; i < numberOfInteriorRings; ++i) {
            int j;
            interiorArea = 0.0;
            Coordinate[] interiorRingCoordinates = polygon.getInteriorRingN(i).getCoordinates();
            int numberOfInteriorRingCoordinates = interiorRingCoordinates.length;
            minx = Double.POSITIVE_INFINITY;
            maxx = Double.NEGATIVE_INFINITY;
            miny = Double.POSITIVE_INFINITY;
            maxy = Double.NEGATIVE_INFINITY;
            for (j = 0; j < numberOfInteriorRingCoordinates; ++j) {
                minx = Math.min(minx, interiorRingCoordinates[j].x);
                maxx = Math.max(maxx, interiorRingCoordinates[j].x);
                miny = Math.min(miny, interiorRingCoordinates[j].y);
                maxy = Math.max(maxy, interiorRingCoordinates[j].y);
            }
            for (j = 0; j < numberOfInteriorRingCoordinates - 1; ++j) {
                interiorArea += (interiorRingCoordinates[j + 1].x - minx - (interiorRingCoordinates[j].x - minx)) * ((interiorRingCoordinates[j + 1].y - miny + (interiorRingCoordinates[j].y - miny)) / 2.0);
            }
            area -= Math.abs(interiorArea);
        }
        return area;
    }

    protected double getPerimeter(Polygon polygon) {
        double perimeter = 0.0;
        LinearRing lineString = polygon.getExteriorRing();
        perimeter += this.getPerimeter(lineString);
        int numberOfHoles = polygon.getNumInteriorRing();
        for (int i = 0; i < numberOfHoles; ++i) {
            perimeter += this.getPerimeter(polygon.getInteriorRingN(i));
        }
        return perimeter;
    }

    protected double getPerimeter(MultiLineString multiLineString) {
        double perimeter = 0.0;
        int numberOfGeometries = multiLineString.getNumGeometries();
        for (int i = 0; i < numberOfGeometries; ++i) {
            perimeter += this.getPerimeter(multiLineString.getGeometryN(i));
        }
        return perimeter;
    }

    protected double getPerimeter(LineString lineString) {
        double perimeter = 0.0;
        int numberOfPoints = lineString.getNumPoints();
        Coordinate[] coordinates = lineString.getCoordinates();
        for (int i = 0; i < numberOfPoints - 1; ++i) {
            perimeter += coordinates[i].distance(coordinates[i + 1]);
        }
        return perimeter;
    }
}

