/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.CalcUtil;
import org.geotools.feature.visitor.FeatureAttributeVisitor;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.filter.IllegalFilterException;

public class MedianVisitor
implements FeatureCalc,
FeatureAttributeVisitor {
    private Expression expr;
    private List<Comparable> list = new ArrayList<Comparable>();
    private Object median = null;

    public MedianVisitor(String attributeTypeName) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(attributeTypeName);
    }

    public MedianVisitor(int attributeTypeIndex, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attributeTypeIndex).getLocalName());
    }

    public MedianVisitor(String attrName, SimpleFeatureType type) throws IllegalFilterException {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr = factory.property(type.getDescriptor(attrName).getLocalName());
    }

    public MedianVisitor(Expression expr) throws IllegalFilterException {
        this.expr = expr;
    }

    public void init(SimpleFeatureCollection collection) {
    }

    @Override
    public List<Expression> getExpressions() {
        return Arrays.asList(this.expr);
    }

    @Override
    public Optional<List<Class>> getResultType(List<Class> inputTypes) {
        return CalcUtil.reflectInputTypes(1, inputTypes);
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    @Override
    public void visit(Feature feature) {
        Object result = this.expr.evaluate(feature);
        if (result == null) {
            return;
        }
        if (!(result instanceof Comparable)) {
            throw new IllegalStateException("Expression is not comparable!");
        }
        Comparable value = (Comparable)result;
        this.list.add(value);
    }

    public Expression getExpression() {
        return this.expr;
    }

    public Object getMedian() {
        if (this.median != null) {
            return this.median;
        }
        Object newMedian = MedianVisitor.findMedian(this.list);
        if (newMedian == null) {
            throw new IllegalStateException("Must visit before median value is ready!");
        }
        return newMedian;
    }

    public void reset() {
        this.list.clear();
        this.median = null;
    }

    @Override
    public CalcResult getResult() {
        if (this.median != null) {
            return new MedianResult(this.median);
        }
        if (this.list.isEmpty()) {
            return CalcResult.NULL_RESULT;
        }
        return new MedianResult(this.list);
    }

    public void setValue(List<Comparable> list) {
        this.reset();
        this.list = list;
    }

    public void setValue(Comparable median) {
        this.reset();
        this.median = median;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Object findMedian(List<Comparable> list) {
        if (list.isEmpty()) {
            return null;
        }
        Collections.sort(list);
        int index = list.size() / 2;
        if (list.size() % 2 != 0) return list.get(index);
        Comparable input1 = list.get(index - 1);
        Comparable input2 = list.get(index);
        if (input1 instanceof Number) {
            Number num1 = (Number)((Object)input1);
            if (input2 instanceof Number) {
                Number num2 = (Number)((Object)input2);
                Number[] numbers = new Number[]{num1, num2};
                return CalcUtil.average(numbers);
            }
        }
        ArrayList<Comparable> newList = new ArrayList<Comparable>();
        newList.add(input1);
        newList.add(input2);
        return newList;
    }

    public static class MedianResult
    extends AbstractCalcResult {
        private List<Comparable> list;
        private Object median;

        public MedianResult(List<Comparable> newList) {
            this.list = newList;
            this.median = null;
        }

        public MedianResult(Object median) {
            this.list = null;
            this.median = median;
        }

        public List<Comparable> getList() {
            return this.list;
        }

        @Override
        public Object getValue() {
            if (this.median != null) {
                return this.median;
            }
            return MedianVisitor.findMedian(this.list);
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof MedianResult || targetResults == CalcResult.NULL_RESULT;
        }

        public boolean isOptimized() {
            return this.median != null;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof MedianResult) {
                MedianResult moreResults = (MedianResult)resultsToAdd;
                if (this.isOptimized() || moreResults.isOptimized()) {
                    throw new IllegalArgumentException("Optimized median results cannot be merged.");
                }
                List<Comparable> toAdd = moreResults.getList();
                ArrayList<Comparable> newList = new ArrayList<Comparable>();
                int size = this.list.size() + toAdd.size();
                Comparable[] values = new Comparable[size];
                for (int i = 0; i < this.list.size(); ++i) {
                    values[i] = this.list.get(i);
                }
                for (int j = 0; j < toAdd.size(); ++j) {
                    values[i + j] = toAdd.get(j);
                }
                Class bestClass = CalcUtil.bestClass(values);
                for (int k = 0; k < size; ++k) {
                    if (values[k].getClass() != bestClass) {
                        values[k] = (Comparable)CalcUtil.convert(values[k], bestClass);
                    }
                    newList.add(values[k]);
                }
                return new MedianResult(newList);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }
}

